/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;
import teamdraco.fins.init.FinsEntities;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsSounds;

public class WherbleEntity
extends AnimalEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(WherbleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public WherbleEntity(EntityType<? extends AnimalEntity> p_i48568_1_, World p_i48568_2_) {
        super(p_i48568_1_, p_i48568_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185164_cV}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, FoxEntity.class, 8.0f, 1.0, 1.15));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 8.0f, 1.0, 1.15));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public static boolean checkWherbleSpawnRules(EntityType<? extends WherbleEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_203425_a(Blocks.field_196658_i) && p_223316_1_.func_226659_b_(p_223316_3_, 0) > 8 && p_223316_1_.func_201674_k().nextFloat() > 0.9f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.func_70631_g_() && heldItem.func_77973_b() == Items.field_222087_nH && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            ItemStack bucket = new ItemStack((IItemProvider)FinsItems.BABY_WHERBLE_POT.get());
            if (this.func_145818_k_()) {
                bucket.func_200302_a(this.func_200201_e());
            }
            if (!this.field_70170_p.field_72995_K) {
                bucket.func_196082_o().func_74768_a("Age", this.func_70874_b());
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
            }
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, bucket);
            } else if (!player.field_71071_by.func_70441_a(bucket)) {
                player.func_71019_a(bucket, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(4));
        }
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_185164_cV;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)FinsSounds.WHERBLE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)FinsSounds.WHERBLE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)FinsSounds.WHERBLE_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        WherbleEntity wherble = (WherbleEntity)((EntityType)FinsEntities.WHERBLE.get()).func_200721_a((World)p_241840_1_);
        wherble.setVariant(this.field_70146_Z.nextInt(4));
        return wherble;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.WHERBLE_SPAWN_EGG.get());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.2f : 0.4f;
    }
}

