/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import teamdraco.fins.common.entities.BandedRedbackShrimpEntity;
import teamdraco.fins.common.entities.BluWeeEntity;
import teamdraco.fins.common.entities.HighFinnedBlueEntity;
import teamdraco.fins.common.entities.PapaWeeEntity;
import teamdraco.fins.common.entities.PeaWeeEntity;
import teamdraco.fins.common.entities.WeeWeeEntity;
import teamdraco.fins.common.entities.util.GroundAndSwimmerNavigator;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsSounds;

public class PenglilEntity
extends TameableEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(PenglilEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_LYING = EntityDataManager.func_187226_a(PenglilEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RELAX_STATE_ONE = EntityDataManager.func_187226_a(PenglilEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public PenglilEntity(EntityType<? extends PenglilEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 1.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundAndSwimmerNavigator((MobEntity)this, this.field_70170_p);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public static boolean canPenglilSpawn(EntityType<? extends TameableEntity> penglil, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m && worldIn.func_226659_b_(pos, 0) > 8;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PapaWeeEntity.class, 8.0f, 1.6, 1.4));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WanderGoal(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 1){

            public boolean func_75250_a() {
                return super.func_75250_a() && PenglilEntity.this.func_70090_H();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new MorningGiftGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PeaWeeEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BluWeeEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BandedRedbackShrimpEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, HighFinnedBlueEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WeeWeeEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        Item item = heldItem.func_77973_b();
        ItemStack itemstack1 = new ItemStack((IItemProvider)FinsItems.PENGLIL_BUCKET.get());
        ActionResultType actionresulttype = super.func_230254_b_(player, hand);
        if (heldItem.func_77973_b() == Items.field_151133_ar && this.func_70089_S() && !this.func_233685_eM_()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        float maxHealth = this.func_110138_aP();
        float health = this.func_110143_aJ();
        if (heldItem.func_77973_b() == FinsItems.BLU_WEE.get() && health < maxHealth) {
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            this.func_70691_i(2.0f);
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            return ActionResultType.SUCCESS;
        }
        if (item == FinsItems.HIGH_FINNED_BLUE.get() && !this.func_70909_n()) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_233687_w_(true);
                this.func_70624_b(null);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_152114_e((LivingEntity)player) && item != FinsItems.HIGH_FINNED_BLUE.get()) {
            this.func_233687_w_(!this.func_233684_eK_());
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            return ActionResultType.SUCCESS;
        }
        return actionresulttype;
    }

    public int func_70627_aG() {
        return 480;
    }

    private void setBucketData(ItemStack bucket) {
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
        if (this.func_70909_n()) {
            compoundnbt.func_186854_a("Owner", this.func_184753_b());
        }
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(IS_LYING, (Object)false);
        this.field_70180_af.func_187214_a(RELAX_STATE_ONE, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(8));
        } else {
            if (dataTag.func_150297_b("Variant", 3)) {
                this.setVariant(dataTag.func_74762_e("Variant"));
            }
            if (dataTag.func_186855_b("Owner")) {
                this.func_184754_b(dataTag.func_186857_a("Owner"));
                this.func_70903_f(true);
            }
        }
        return spawnDataIn;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)FinsSounds.PENGLIL_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)FinsSounds.PENGLIL_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)FinsSounds.PENGLIL_HURT.get();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.PENGLIL_SPAWN_EGG.get());
    }

    public boolean isLying() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LYING);
    }

    public void setLying(boolean p_213419_1_) {
        this.field_70180_af.func_187227_b(IS_LYING, (Object)p_213419_1_);
    }

    public void setRelaxStateOne(boolean p_213415_1_) {
        this.field_70180_af.func_187227_b(RELAX_STATE_ONE, (Object)p_213415_1_);
    }

    public boolean isRelaxStateOne() {
        return (Boolean)this.field_70180_af.func_187225_a(RELAX_STATE_ONE);
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private WanderGoal(PenglilEntity penglil, double speedIn, int chance) {
            super((CreatureEntity)penglil, speedIn, chance);
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final PenglilEntity penglil;

        MoveHelperController(PenglilEntity penglil) {
            super((MobEntity)penglil);
            this.penglil = penglil;
        }

        private void updateSpeed() {
            if (this.penglil.func_70090_H()) {
                this.penglil.func_213317_d(this.penglil.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (this.penglil.func_70631_g_()) {
                    this.penglil.func_70659_e(Math.max(this.penglil.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.penglil.field_70122_E) {
                this.penglil.func_70659_e(Math.max(this.penglil.func_70689_ay(), 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.penglil.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.penglil.func_226277_ct_();
                double d1 = this.field_75647_c - this.penglil.func_226278_cu_();
                double d2 = this.field_75644_d - this.penglil.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.penglil.field_70761_aq = this.penglil.field_70177_z = this.func_75639_a(this.penglil.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.penglil.func_233637_b_(Attributes.field_233821_d_));
                this.penglil.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.penglil.func_70689_ay(), (float)f1));
                this.penglil.func_213317_d(this.penglil.func_213322_ci().func_72441_c(0.0, (double)this.penglil.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.penglil.func_70659_e(0.0f);
            }
        }
    }

    static class MorningGiftGoal
    extends Goal {
        private final PenglilEntity penglil;
        private PlayerEntity owner;
        private BlockPos bedPos;
        private int tickCounter;

        public MorningGiftGoal(PenglilEntity catIn) {
            this.penglil = catIn;
        }

        public boolean func_75250_a() {
            if (!this.penglil.func_70909_n()) {
                return false;
            }
            if (this.penglil.func_233685_eM_()) {
                return false;
            }
            LivingEntity livingentity = this.penglil.func_70902_q();
            if (livingentity instanceof PlayerEntity) {
                this.owner = (PlayerEntity)livingentity;
                if (!livingentity.func_70608_bn()) {
                    return false;
                }
                if (this.penglil.func_70068_e((Entity)this.owner) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.owner.func_233580_cy_();
                BlockState blockstate = this.penglil.field_70170_p.func_180495_p(blockpos);
                if (blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
                    this.bedPos = blockstate.func_235903_d_((Property)BedBlock.field_185512_D).map(p_234186_1_ -> blockpos.func_177972_a(p_234186_1_.func_176734_d())).orElseGet(() -> new BlockPos((Vector3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            for (PenglilEntity penglilentity : this.penglil.field_70170_p.func_217357_a(PenglilEntity.class, new AxisAlignedBB(this.bedPos).func_186662_g(2.0))) {
                if (penglilentity == this.penglil || !penglilentity.isLying() && !penglilentity.isRelaxStateOne()) continue;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.penglil.func_70909_n() && !this.penglil.func_233685_eM_() && this.owner != null && this.owner.func_70608_bn() && this.bedPos != null && !this.spaceIsOccupied();
        }

        public void func_75249_e() {
            if (this.bedPos != null) {
                this.penglil.func_233686_v_(false);
                this.penglil.func_70661_as().func_75492_a((double)this.bedPos.func_177958_n(), (double)this.bedPos.func_177956_o(), (double)this.bedPos.func_177952_p(), (double)1.1f);
            }
        }

        public void func_75251_c() {
            this.penglil.setLying(false);
            float f = this.penglil.field_70170_p.func_242415_f(1.0f);
            if (this.owner.func_71060_bI() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.penglil.field_70170_p.func_201674_k().nextFloat() < 0.5) {
                this.giveMorningGift();
            }
            this.tickCounter = 0;
            this.penglil.setRelaxStateOne(false);
            this.penglil.func_70661_as().func_75499_g();
        }

        private void giveMorningGift() {
            Random random = this.penglil.func_70681_au();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            blockpos$mutable.func_189533_g((Vector3i)this.penglil.func_233580_cy_());
            this.penglil.func_213373_a(blockpos$mutable.func_177958_n() + random.nextInt(11) - 5, blockpos$mutable.func_177956_o() + random.nextInt(5) - 2, blockpos$mutable.func_177952_p() + random.nextInt(11) - 5, false);
            blockpos$mutable.func_189533_g((Vector3i)this.penglil.func_233580_cy_());
            LootTable loottable = this.penglil.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.penglil.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.penglil.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this.penglil).func_216023_a(random);
            for (ItemStack itemstack : loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216264_e))) {
                this.penglil.field_70170_p.func_217376_c((Entity)new ItemEntity(this.penglil.field_70170_p, (double)blockpos$mutable.func_177958_n() - (double)MathHelper.func_76126_a((float)(this.penglil.field_70761_aq * ((float)Math.PI / 180))), (double)blockpos$mutable.func_177956_o(), (double)blockpos$mutable.func_177952_p() + (double)MathHelper.func_76134_b((float)(this.penglil.field_70761_aq * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void func_75246_d() {
            if (this.owner != null && this.bedPos != null) {
                this.penglil.func_233686_v_(false);
                this.penglil.func_70661_as().func_75492_a((double)this.bedPos.func_177958_n(), (double)this.bedPos.func_177956_o(), (double)this.bedPos.func_177952_p(), (double)1.1f);
                if (this.penglil.func_70068_e((Entity)this.owner) < 2.5) {
                    ++this.tickCounter;
                    if (this.tickCounter > 16) {
                        this.penglil.setLying(true);
                        this.penglil.setRelaxStateOne(false);
                    } else {
                        this.penglil.func_70625_a((Entity)this.owner, 45.0f, 45.0f);
                        this.penglil.setRelaxStateOne(true);
                    }
                } else {
                    this.penglil.setLying(false);
                }
            }
        }
    }
}

