/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import teamdraco.fins.common.entities.TealArrowfishEntity;
import teamdraco.fins.init.FinsItems;

public class GopjetEntity
extends AbstractFishEntity {
    private static final EntityPredicate SWIM_WITH_PLAYER_TARGETING = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a().func_221014_c();
    private static final DataParameter<Boolean> IS_BOOSTING = EntityDataManager.func_187226_a(GopjetEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final int BOOST_TIMER = 400;
    private int boostTimer = 400;

    public GopjetEntity(EntityType<? extends GopjetEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, TealArrowfishEntity.class, 6.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimWithPlayerGoal(this, 4.0));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BOOSTING, (Object)false);
    }

    public void func_70071_h_() {
        List list = this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(3.0), EntityPredicates.field_188444_d);
        super.func_70071_h_();
        if (this.boostTimer > 0) {
            --this.boostTimer;
        }
        if (this.boostTimer == 0 || !list.isEmpty()) {
            this.boostTimer = 400;
            this.func_213317_d(this.func_174806_f(this.field_70125_A, this.field_70177_z).func_216372_d(2.0, 0.0, 2.0));
        }
        if (this.boostTimer <= 350) {
            this.setBoosting(false);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)38);
        if (this.isBoosting()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)39);
        }
    }

    public void setBoosting(boolean isBoosting) {
        this.func_184212_Q().func_187227_b(IS_BOOSTING, (Object)isBoosting);
    }

    public boolean isBoosting() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BOOSTING);
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)FinsItems.GOPJET_BUCKET.get());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203818_az;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 38) {
            this.swimmingParticles((IParticleData)ParticleTypes.field_197612_e);
        }
        if (id == 39) {
            this.boostingParticles((IParticleData)ParticleTypes.field_197612_e);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void swimmingParticles(IParticleData p_208401_1_) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.056;
        double d1 = this.field_70146_Z.nextGaussian() * 0.034;
        double d2 = this.field_70146_Z.nextGaussian() * 0.025;
        this.field_70170_p.func_195594_a(p_208401_1_, this.func_226277_ct_(), this.func_226279_cv_(), this.func_226281_cx_(), d0, d1, d2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void boostingParticles(IParticleData p_208401_1_) {
        for (int i = 0; i < 4; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.056;
            double d1 = this.field_70146_Z.nextGaussian() * 0.034;
            double d2 = this.field_70146_Z.nextGaussian() * 0.025;
            this.field_70170_p.func_195594_a(p_208401_1_, this.func_226277_ct_(), this.func_226279_cv_(), this.func_226281_cx_(), d0, d1, d2);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.GOPJET_SPAWN_EGG.get());
    }

    static class SwimWithPlayerGoal
    extends Goal {
        private final GopjetEntity gopjet;
        private final double speed;
        private PlayerEntity targetPlayer;

        SwimWithPlayerGoal(GopjetEntity gopjetIn, double speedIn) {
            this.gopjet = gopjetIn;
            this.speed = speedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            this.targetPlayer = this.gopjet.field_70170_p.func_217370_a(SWIM_WITH_PLAYER_TARGETING, (LivingEntity)this.gopjet);
            if (this.targetPlayer == null) {
                return false;
            }
            return this.targetPlayer.func_203007_ba() && this.gopjet.func_70638_az() != this.targetPlayer;
        }

        public boolean func_75253_b() {
            return this.targetPlayer != null && this.targetPlayer.func_203007_ba() && this.gopjet.func_70068_e((Entity)this.targetPlayer) < 256.0;
        }

        public void func_75251_c() {
            this.targetPlayer = null;
            this.gopjet.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.gopjet.func_70671_ap().func_75651_a((Entity)this.targetPlayer, (float)(this.gopjet.func_184649_cE() + 20), (float)this.gopjet.func_70646_bf());
            if (this.gopjet.func_70068_e((Entity)this.targetPlayer) < 6.25) {
                this.gopjet.func_70661_as().func_75499_g();
            } else {
                this.gopjet.func_70661_as().func_75497_a((Entity)this.targetPlayer, this.speed);
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GopjetEntity gopjet;

        public MoveHelperController(GopjetEntity gopjetEntity) {
            super((MobEntity)gopjetEntity);
            this.gopjet = gopjetEntity;
        }

        public void func_75641_c() {
            if (this.gopjet.func_70090_H()) {
                this.gopjet.func_213317_d(this.gopjet.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.gopjet.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.gopjet.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.gopjet.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.gopjet.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.gopjet.field_70761_aq = this.gopjet.field_70177_z = this.func_75639_a(this.gopjet.field_70177_z, f, 10.0f);
                    this.gopjet.field_70759_as = this.gopjet.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.gopjet.func_233637_b_(Attributes.field_233821_d_));
                    if (this.gopjet.func_70090_H()) {
                        this.gopjet.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.gopjet.field_70125_A = this.func_75639_a(this.gopjet.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.gopjet.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.gopjet.field_70125_A * ((float)Math.PI / 180)));
                        this.gopjet.field_191988_bg = f3 * f1;
                        this.gopjet.field_70701_bs = -f4 * f1;
                    } else {
                        this.gopjet.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.gopjet.func_70659_e(0.0f);
                this.gopjet.func_184646_p(0.0f);
                this.gopjet.func_70657_f(0.0f);
                this.gopjet.func_191989_p(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final GopjetEntity fish;

        public SwimGoal(GopjetEntity fish) {
            super((CreatureEntity)fish, 1.5, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }
}

