/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import teamdraco.fins.common.entities.RiverPebbleSnailEntity;
import teamdraco.fins.init.FinsItems;

public class GoldenRiverRayEntity
extends AbstractGroupFishEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(GoldenRiverRayEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GoldenRiverRayEntity(EntityType<? extends GoldenRiverRayEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 1.0, 1.85));
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.85));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RiverPebbleSnailEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (entityIn instanceof ServerPlayerEntity && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f)) {
            ((ServerPlayerEntity)entityIn).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241773_j_, 0.0f));
            entityIn.func_195064_c(new EffectInstance(Effects.field_76436_u, 120, 0));
        }
    }

    protected void func_204211_f(ItemStack bucket) {
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(3));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)FinsItems.GOLDEN_RIVER_RAY_BUCKET.get());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203818_az;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.GOLDEN_RIVER_RAY_SPAWN_EGG.get());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final GoldenRiverRayEntity fish;

        public SwimGoal(GoldenRiverRayEntity fish) {
            super((CreatureEntity)fish, 1.0, 1);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }
}

