/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import teamdraco.fins.FinsConfig;
import teamdraco.fins.common.entities.WherbleEntity;
import teamdraco.fins.init.FinsEnchantments;
import teamdraco.fins.init.FinsEntities;
import teamdraco.fins.init.FinsItems;

@Mod.EventBusSubscriber(modid="fins", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void livingDamage(LivingDamageEvent event) {
        if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == FinsItems.GOPJET_JETPACK.get() && event.getSource() == DamageSource.field_76379_h) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof WolfEntity || event.getEntity() instanceof FoxEntity) {
            ((MobEntity)event.getEntity()).field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)event.getEntity(), WherbleEntity.class, true));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.SWAMP) {
            event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.SWAMP_MUCKER.get(), ((Integer)FinsConfig.Common.INSTANCE.swampMuckerSpawnWeight.get()).intValue(), 2, 4));
            event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.FLATBACK_SUCKER.get(), ((Integer)FinsConfig.Common.INSTANCE.flatbackSuckerSpawnWeight.get()).intValue(), 1, 1));
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.MUDHORSE.get(), ((Integer)FinsConfig.Common.INSTANCE.mudhorseSpawnWeight.get()).intValue(), 2, 3));
        }
        if (event.getCategory() == Biome.Category.JUNGLE) {
            event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.PEA_WEE.get(), ((Integer)FinsConfig.Common.INSTANCE.peaWeeSpawnWeight.get()).intValue(), 1, 3));
            event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.VIBRA_WEE.get(), ((Integer)FinsConfig.Common.INSTANCE.vibraWeeSpawnWeight.get()).intValue(), 2, 5));
        }
        if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.SIDEROL_WHISKERED_SNAIL.get(), ((Integer)FinsConfig.Common.INSTANCE.siderolWhiskeredSnailSpawnWeight.get()).intValue(), 1, 2));
        }
        if (event.getCategory() == Biome.Category.BEACH) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.PENGLIL.get(), ((Integer)FinsConfig.Common.INSTANCE.penglilSpawnWeight.get()).intValue(), 3, 5));
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.RUBBER_BELLY_GLIDER.get(), ((Integer)FinsConfig.Common.INSTANCE.rubberBellyGliderSpawnWeight.get()).intValue(), 1, 2));
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.FLATBACK_LEAF_SNAIL.get(), ((Integer)FinsConfig.Common.INSTANCE.flatbackLeafSnailSpawnWeight.get()).intValue(), 1, 2));
        }
        if (event.getCategory() == Biome.Category.ICY) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.WHERBLE.get(), ((Integer)FinsConfig.Common.INSTANCE.wherbleSpawnWeight.get()).intValue(), 2, 6));
        }
        if (event.getName() != null) {
            String name = event.getName().func_110623_a();
            if (name.equals("cold_ocean") || name.equals("deep_cold_ocean")) {
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.BLU_WEE.get(), ((Integer)FinsConfig.Common.INSTANCE.bluWeeSpawnWeight.get()).intValue(), 4, 8));
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.TEAL_ARROWFISH.get(), ((Integer)FinsConfig.Common.INSTANCE.tealArrowfishSpawnWeight.get()).intValue(), 1, 1));
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.PHANTOM_NUDIBRANCH.get(), ((Integer)FinsConfig.Common.INSTANCE.phantomNudibranchSpawnWeight.get()).intValue(), 1, 1));
            }
            if (name.equals("warm_ocean") || name.equals("deep_warm_ocean")) {
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.BANDED_REDBACK_SHRIMP.get(), ((Integer)FinsConfig.Common.INSTANCE.bandedRedbackShrimpSpawnWeight.get()).intValue(), 3, 3));
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.ORNATE_BUGFISH.get(), ((Integer)FinsConfig.Common.INSTANCE.ornateBugfishSpawnWeight.get()).intValue(), 5, 5));
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.SPINDLY_GEM_CRAB.get(), ((Integer)FinsConfig.Common.INSTANCE.spindlyGemCrabSpawnWeight.get()).intValue(), 1, 3));
                event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.RUBBER_BELLY_GLIDER.get(), ((Integer)FinsConfig.Common.INSTANCE.rubberBellyGliderSpawnWeight.get()).intValue(), 1, 2));
            }
            if (name.equals("ocean") || name.equals("deep_ocean")) {
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.HIGH_FINNED_BLUE.get(), ((Integer)FinsConfig.Common.INSTANCE.highFinnedBlueSpawnWeight.get()).intValue(), 6, 12));
                event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.GOPJET.get(), ((Integer)FinsConfig.Common.INSTANCE.gopjetSpawnWeight.get()).intValue(), 2, 3));
            }
            if (name.equals("lukewarm_ocean") || name.equals("deep_lukewarm_ocean")) {
                event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.RED_BULL_CRAB.get(), ((Integer)FinsConfig.Common.INSTANCE.redBullCrabSpawnWeight.get()).intValue(), 1, 1));
                event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.WHITE_BULL_CRAB.get(), ((Integer)FinsConfig.Common.INSTANCE.whiteBullCrabSpawnWeight.get()).intValue(), 2, 4));
            }
            if (name.equals("frozen_ocean") || name.equals("deep_frozen_ocean")) {
                event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.NIGHT_LIGHT_SQUID.get(), ((Integer)FinsConfig.Common.INSTANCE.nightLightSquidSpawnWeight.get()).intValue(), 1, 2));
            }
            if (name.equals("river")) {
                event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.WEE_WEE.get(), ((Integer)FinsConfig.Common.INSTANCE.weeWeeSpawnWeight.get()).intValue(), 2, 6));
                event.getSpawns().getSpawner(EntityClassification.AMBIENT).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.RIVER_PEBBLE_SNAIL.get(), ((Integer)FinsConfig.Common.INSTANCE.riverPebbleSnailSpawnWeight.get()).intValue(), 1, 1));
                event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners((EntityType)FinsEntities.GOLDEN_RIVER_RAY.get(), ((Integer)FinsConfig.Common.INSTANCE.goldenRiverRaySpawnWeight.get()).intValue(), 1, 1));
            }
        }
    }

    @SubscribeEvent
    public static void crabsFavorXPDrops(LivingExperienceDropEvent event) {
        LivingEntity livingEntity;
        ItemStack heldItem;
        PlayerEntity attacker = event.getAttackingPlayer();
        if (attacker != null && EnchantmentHelper.func_82781_a((ItemStack)(heldItem = (livingEntity = (LivingEntity)attacker).func_184614_ca())).containsKey(FinsEnchantments.CRABS_FAVOR.get())) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)FinsEnchantments.CRABS_FAVOR.get()), (ItemStack)event.getAttackingPlayer().func_184586_b(Hand.MAIN_HAND));
            event.setDroppedExperience(event.getOriginalExperience() * i + attacker.func_130014_f_().field_73012_v.nextInt(3));
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) throws IllegalAccessException {
        ResourceLocation name = event.getName();
        if (name.equals((Object)LootTables.field_186390_ao)) {
            LootPool pool = event.getTable().getPool("main");
            if (((Boolean)FinsConfig.Common.INSTANCE.finsFishingLoot.get()).booleanValue()) {
                CommonEvents.addEntry(pool, CommonEvents.getInjectEntry(new ResourceLocation("fins", "inject/fishing"), 10, 1));
            }
            if (name.equals((Object)LootTables.field_215803_al)) {
                CommonEvents.addEntry(pool, CommonEvents.getInjectEntry(new ResourceLocation("fins:inject/fisherman_gift"), 15, 1));
            }
        }
    }

    private static LootEntry getInjectEntry(ResourceLocation location, int weight, int quality) {
        return TableLootEntry.func_216171_a((ResourceLocation)location).func_216086_a(weight).func_216085_b(quality).func_216081_b();
    }

    private static void addEntry(LootPool pool, LootEntry entry) throws IllegalAccessException {
        List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a").get(pool);
        if (lootEntries.stream().anyMatch(e -> e == entry)) {
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry);
        }
        lootEntries.add(entry);
    }

    @SubscribeEvent
    public static void addWandererTrades(WandererTradesEvent event) {
        List list = event.getGenericTrades();
        list.add(CommonEvents.cdForItems((Item)FinsItems.HIGH_FINNED_BLUE_BUCKET.get(), 1, 4, 1));
        list.add(CommonEvents.cdForItems((Item)FinsItems.PEA_WEE_BUCKET.get(), 1, 4, 2));
        list.add(CommonEvents.cdForItems((Item)FinsItems.BLU_WEE_BUCKET.get(), 1, 4, 1));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 6), new ItemStack((IItemProvider)FinsItems.SPINDLY_GEM_CRAB_GEM.get(), 1), 2, 4, 1.5f));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 4), new ItemStack((IItemProvider)FinsItems.FWIN.get(), 1), 2, 3, 1.5f));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 7), new ItemStack((IItemProvider)FinsItems.MUDHORSE_LEATHER.get(), 1), 2, 4, 1.5f));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3), new ItemStack((IItemProvider)FinsItems.FLATBACK_LEAF_SNAIL_SHELL.get(), 1), 2, 4, 1.5f));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3), new ItemStack((IItemProvider)FinsItems.RIVER_PEBBLE_SNAIL_SHELL.get(), 1), 2, 4, 1.5f));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 4), new ItemStack((IItemProvider)FinsItems.SIDEROL_WHISKERED_SNAIL_SHELL.get(), 1), 2, 4, 1.5f));
        list.add(new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 4), new ItemStack((IItemProvider)FinsItems.GOPJET_JET.get(), 1), 2, 4, 2.0f));
    }

    private static VillagerTrades.ITrade cdForItems(ItemStack selling, int maxUses, int xp) {
        return new ItemsForItemsTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 5), selling, maxUses, xp, 0.0f);
    }

    private static VillagerTrades.ITrade cdForItems(Item item, int count, int maxUses, int xp) {
        return CommonEvents.cdForItems(new ItemStack((IItemProvider)item, count), maxUses, xp);
    }

    private static class ItemsForItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack buying1;
        private final ItemStack buying2;
        private final ItemStack selling;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        public ItemsForItemsTrade(ItemStack buying1, ItemStack buying2, ItemStack selling, int maxUses, int xp, float priceMultiplier) {
            this.buying1 = buying1;
            this.buying2 = buying2;
            this.selling = selling;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public ItemsForItemsTrade(ItemStack buying1, ItemStack selling, int maxUses, int xp, float priceMultiplier) {
            this(buying1, ItemStack.field_190927_a, selling, maxUses, xp, priceMultiplier);
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(this.buying1, this.buying2, this.selling, this.maxUses, this.xp, this.priceMultiplier);
        }
    }
}

