/*
 * Decompiled with CFR 0.152.
 */
package uppers.tiles;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import uppers.ModBlocks;
import uppers.blocks.UpperBlock;
import uppers.tiles.IUpper;
import uppers.tiles.InventoryCodeHooksTweaked;
import uppers.tiles.UpperItemHandler;

public class UpperTileEntity
extends LockableLootTileEntity
implements IUpper,
ITickableTileEntity {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int transferCooldown = -1;
    private long tickedGameTime;

    public UpperTileEntity() {
        super(ModBlocks.UPPER_TILE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        }
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        return compound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public ITextComponent func_200200_C_() {
        return this.func_200201_e() != null ? this.func_200201_e() : new TranslationTextComponent("container.upper", new Object[0]);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.upper", new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateUpper(() -> UpperTileEntity.pullItems(this));
            }
        }
    }

    private boolean updateUpper(Supplier<Boolean> supplier) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown() && ((Boolean)this.func_195044_w().func_177229_b((Property)UpperBlock.ENABLED)).booleanValue()) {
                boolean flag = false;
                if (!this.isInventoryEmpty()) {
                    flag = this.transferItemsOut();
                }
                if (!this.isFull()) {
                    flag |= supplier.get().booleanValue();
                }
                if (flag) {
                    this.setTransferCooldown(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        if (InventoryCodeHooksTweaked.insertHook(this)) {
            return true;
        }
        IInventory iinventory = this.getInventoryForUpperTransfer();
        if (iinventory == null) {
            return false;
        }
        Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)UpperBlock.FACING)).func_176734_d();
        if (this.isInventoryFull(iinventory, direction)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = UpperTileEntity.putStackInInventoryAllSlots((IInventory)this, iinventory, this.func_70298_a(i, 1), direction);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private static IntStream inventoryChecked(IInventory inventoryIn, Direction direction) {
        return inventoryIn instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inventoryIn).func_180463_a(direction)) : IntStream.range(0, inventoryIn.func_70302_i_());
    }

    private boolean isInventoryFull(IInventory inventoryIn, Direction side) {
        return UpperTileEntity.inventoryChecked(inventoryIn, side).allMatch(stackInSlot -> {
            ItemStack itemstack = inventoryIn.func_70301_a(stackInSlot);
            return itemstack.func_190916_E() >= itemstack.func_77976_d();
        });
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, Direction side) {
        return UpperTileEntity.inventoryChecked(inventoryIn, side).allMatch(stackInSlot -> inventoryIn.func_70301_a(stackInSlot).func_190926_b());
    }

    public static boolean pullItems(IUpper upper) {
        Boolean ret = InventoryCodeHooksTweaked.extractHook(upper);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = UpperTileEntity.getSourceInventory(upper);
        if (iinventory != null) {
            Direction direction = Direction.DOWN;
            return UpperTileEntity.isInventoryEmpty(iinventory, direction) ? false : UpperTileEntity.inventoryChecked(iinventory, direction).anyMatch(inventoryIn -> UpperTileEntity.pullItemFromSlot(upper, iinventory, inventoryIn, direction));
        }
        for (ItemEntity itementity : UpperTileEntity.getCaptureItems(upper)) {
            if (!UpperTileEntity.captureItem((IInventory)upper, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean pullItemFromSlot(IUpper upper, IInventory inventoryIn, int index, Direction direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && UpperTileEntity.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = UpperTileEntity.putStackInInventoryAllSlots(inventoryIn, (IInventory)upper, inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    public static boolean captureItem(IInventory destination, ItemEntity entity) {
        boolean flag = false;
        ItemStack itemstack = entity.func_92059_d().func_77946_l();
        ItemStack itemstack1 = UpperTileEntity.putStackInInventoryAllSlots(null, destination, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            entity.func_70106_y();
        } else {
            entity.func_92058_a(itemstack1);
        }
        return flag;
    }

    protected IItemHandler createUnSidedHandler() {
        return new UpperItemHandler(this);
    }

    public static ItemStack putStackInInventoryAllSlots(@Nullable IInventory source, IInventory destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory isidedinventory = (ISidedInventory)destination;
            int[] aint = isidedinventory.func_180463_a(direction);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = UpperTileEntity.insertStack(source, destination, stack, aint[k], direction);
            }
        } else {
            int i = destination.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = UpperTileEntity.insertStack(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private static ItemStack insertStack(@Nullable IInventory source, IInventory destination, ItemStack stack, int index, @Nullable Direction direction) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (UpperTileEntity.canInsertItemInSlot(destination, stack, index, direction)) {
            boolean flag = false;
            boolean flag1 = destination.func_191420_l();
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (UpperTileEntity.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                UpperTileEntity tileentityupper1;
                if (flag1 && destination instanceof UpperTileEntity && !(tileentityupper1 = (UpperTileEntity)destination).mayTransfer()) {
                    int k = 0;
                    if (source instanceof UpperTileEntity) {
                        UpperTileEntity tileentityupper = (UpperTileEntity)source;
                        if (tileentityupper1.tickedGameTime >= tileentityupper.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileentityupper1.setTransferCooldown(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    @Nullable
    private IInventory getInventoryForUpperTransfer() {
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)UpperBlock.FACING);
        return UpperTileEntity.getInventoryAtPosition(this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
    }

    public static IInventory getSourceInventory(IUpper upper) {
        return UpperTileEntity.getInventoryAtPosition(upper.func_145831_w(), upper.func_96107_aA(), upper.func_96109_aB() - 1.0, upper.func_96108_aC());
    }

    public static List<ItemEntity> getCaptureItems(IUpper upper) {
        return upper.func_200100_i().func_197756_d().stream().flatMap(something -> upper.func_145831_w().func_175647_a(ItemEntity.class, something.func_72317_d(upper.func_96107_aA() - 0.5, upper.func_96109_aB() - 0.5, upper.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory getInventoryAtPosition(World world, BlockPos pos) {
        return UpperTileEntity.getInventoryAtPosition(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @Nullable
    public static IInventory getInventoryAtPosition(World world, double x, double y, double z) {
        List list;
        TileEntity tileentity;
        ISidedInventory iinventory = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        if (block instanceof ISidedInventoryProvider) {
            iinventory = ((ISidedInventoryProvider)block).func_219966_a(state, (IWorld)world, blockpos);
        } else if (state.hasTileEntity() && (tileentity = world.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof ChestTileEntity && block instanceof ChestBlock) {
            iinventory = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)state, (World)world, (BlockPos)blockpos, (boolean)true);
        }
        if (iinventory == null && !(list = world.func_175674_a((Entity)null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(world.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new HopperContainer(id, player, (IInventory)this);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventory = itemsIn;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos blockpos = this.func_174877_v();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.func_200100_i(), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.updateUpper(() -> UpperTileEntity.captureItem((IInventory)this, (ItemEntity)entity));
            }
        }
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

