/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterOptions;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractFluidFilter
implements IFilter,
IFilterOptions {
    public static final int SIZE = 12;
    protected List<FluidStack> fluids;
    protected Predicate<FluidStack> rules;
    protected boolean allowList = false;
    protected boolean checkNBT = false;

    public AbstractFluidFilter(int size) {
        this.fluids = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            this.fluids.add(FluidStack.EMPTY);
        }
    }

    public int size() {
        return this.fluids.size();
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public void setFluids(List<FluidStack> fluids) {
        this.fluids = fluids;
    }

    @Override
    public Predicate<FluidStack> getFluidRules() {
        if (this.rules == null) {
            ObjectOpenHashSet fluidSet = new ObjectOpenHashSet();
            for (FluidStack fluid : this.fluids) {
                fluidSet.add(fluid.getFluid());
            }
            this.rules = arg_0 -> this.lambda$getFluidRules$0((Set)fluidSet, arg_0);
        }
        return this.rules;
    }

    @Override
    public IFilter read(CompoundNBT nbt) {
        CompoundNBT subTag = nbt.func_74775_l("Filter");
        ListNBT list = subTag.func_150295_c("TankInv", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tankTag = list.func_150305_b(i);
            byte tank = tankTag.func_74771_c("Tank");
            if (tank < 0 || tank >= this.fluids.size()) continue;
            this.fluids.set(tank, FluidStack.loadFluidStackFromNBT((CompoundNBT)tankTag));
        }
        this.allowList = subTag.func_74767_n("AllowList");
        this.checkNBT = subTag.func_74767_n("CheckNBT");
        return this;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        CompoundNBT subTag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.fluids.size(); ++i) {
            if (this.fluids.get(i).isEmpty()) continue;
            CompoundNBT tankTag = new CompoundNBT();
            tankTag.func_74774_a("Tank", (byte)i);
            this.fluids.get(i).writeToNBT(tankTag);
            list.add((Object)tankTag);
        }
        subTag.func_218657_a("TankInv", (INBT)list);
        subTag.func_74757_a("AllowList", this.allowList);
        subTag.func_74757_a("CheckNBT", this.checkNBT);
        nbt.func_218657_a("Filter", (INBT)subTag);
        return nbt;
    }

    @Override
    public boolean getAllowList() {
        return this.allowList;
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        this.allowList = allowList;
        return true;
    }

    @Override
    public boolean getCheckNBT() {
        return this.checkNBT;
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        this.checkNBT = checkNBT;
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("info.cofh.fluid_filter");
    }

    private /* synthetic */ boolean lambda$getFluidRules$0(Set fluidSet, FluidStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (this.allowList != fluidSet.contains(stack.getFluid())) {
            return false;
        }
        if (this.checkNBT) {
            for (FluidStack fluid : this.fluids) {
                if (!FluidHelper.fluidsEqual(stack, fluid)) continue;
                return this.allowList;
            }
        }
        return true;
    }
}

