/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.potion;

import cofh.lib.capability.CapabilityRedstoneFlux;
import cofh.lib.potion.EffectCoFH;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectType;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyChargeEffect
extends EffectCoFH {
    private final int amount;

    public EnergyChargeEffect(EffectType typeIn, int liquidColorIn, int amount) {
        super(typeIn, liquidColorIn);
        this.amount = amount;
    }

    public void func_76394_a(LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity entity = (ServerPlayerEntity)entityLivingBaseIn;
            if (this.amount <= 0) {
                this.drainForgeEnergy(entity, this.amount);
                this.drainRedstoneFlux(entity, this.amount);
            } else {
                this.chargeForgeEnergy(entity, this.amount);
                this.chargeRedstoneFlux(entity, this.amount);
            }
        }
    }

    private void chargeForgeEnergy(ServerPlayerEntity entity, int chargeAmount) {
        for (ItemStack stack : entity.field_71071_by.field_70462_a) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_70460_b) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_184439_c) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
    }

    private void chargeRedstoneFlux(ServerPlayerEntity entity, int chargeAmount) {
        for (ItemStack stack : entity.field_71071_by.field_70462_a) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_70460_b) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_184439_c) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.receiveEnergy(chargeAmount, false));
        }
    }

    private void drainForgeEnergy(ServerPlayerEntity entity, int drainAmount) {
        for (ItemStack stack : entity.field_71071_by.field_70462_a) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_70460_b) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_184439_c) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
    }

    private void drainRedstoneFlux(ServerPlayerEntity entity, int drainAmount) {
        for (ItemStack stack : entity.field_71071_by.field_70462_a) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_70460_b) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
        for (ItemStack stack : entity.field_71071_by.field_184439_c) {
            stack.getCapability(CapabilityRedstoneFlux.RF_ENERGY, null).ifPresent(c -> c.extractEnergy(drainAmount, false));
        }
    }
}

