/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreConfig;
import cofh.lib.client.renderer.entity.ITranslucentRenderer;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class CoreClientEvents {
    public static int renderTime;
    public static float renderFrame;
    public static MatrixStack levelStack;
    private static final Set<String> NAMESPACES;

    private CoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        String enchKey;
        Enchantment ench;
        ListNBT list;
        String infoKey;
        String keywordKey;
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoreConfig.enableKeywords && NAMESPACES.contains(Utils.getItemNamespace(stack.func_77973_b())) && StringHelper.canLocalize(keywordKey = stack.func_77977_a() + ".keyword") && tooltip.get(0) instanceof IFormattableTextComponent) {
            IFormattableTextComponent formatted = (IFormattableTextComponent)tooltip.get(0);
            formatted.func_230529_a_((ITextComponent)StringHelper.getKeywordTextComponent(keywordKey));
        }
        if (CoreConfig.enableItemDescriptions && NAMESPACES.contains(Utils.getItemNamespace(stack.func_77973_b())) && StringHelper.canLocalize(infoKey = stack.func_77977_a() + ".desc")) {
            tooltip.add(1, StringHelper.getInfoTextComponent(infoKey));
        }
        if (CoreConfig.enableEnchantmentDescriptions && stack.func_77978_p() != null && (list = stack.func_77978_p().func_150295_c("StoredEnchantments", 10)).size() == 1 && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)list.func_150305_b(0).func_74779_i("id")))) != null && ench.getRegistryName() != null && StringHelper.canLocalize(enchKey = ench.func_77320_a() + ".desc")) {
            tooltip.add(StringHelper.getInfoTextComponent(enchKey));
        }
        if (CoreConfig.enableItemTags && event.getFlags().func_194127_a()) {
            Item item = event.getItemStack().func_77973_b();
            Set blockTags = Block.func_149634_a((Item)item).getTags();
            Set itemTags = item.getTags();
            if (!blockTags.isEmpty() || !itemTags.isEmpty()) {
                if (Screen.func_231172_r_()) {
                    if (!blockTags.isEmpty()) {
                        tooltip.add(StringHelper.getTextComponent("info.cofh.block_tags").func_240699_a_(TextFormatting.GRAY));
                        blockTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).func_240699_a_(TextFormatting.DARK_GRAY)).forEach(tooltip::add);
                    }
                    if (!itemTags.isEmpty()) {
                        tooltip.add(StringHelper.getTextComponent("info.cofh.item_tags").func_240699_a_(TextFormatting.GRAY));
                        itemTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).func_240699_a_(TextFormatting.DARK_GRAY)).forEach(tooltip::add);
                    }
                } else {
                    tooltip.add(StringHelper.getTextComponent("info.cofh.hold_ctrl_for_tags").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleRenderTooltipEvent(RenderTooltipEvent.Pre event) {
        if (event.getLines().isEmpty()) {
            return;
        }
        if (event.getLines().get(0) instanceof IFormattableTextComponent) {
            IFormattableTextComponent formatted = (IFormattableTextComponent)event.getLines().get(0);
            formatted.func_150253_a().removeIf(string -> string.func_150256_b().equals((Object)Constants.INVIS_STYLE));
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++renderTime;
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            renderFrame = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void renderTranslucentEntities(RenderWorldLastEvent event) {
        ITranslucentRenderer.renderTranslucent(event.getMatrixStack(), event.getPartialTicks(), event.getContext(), event.getProjectionMatrix());
    }

    static {
        levelStack = new MatrixStack();
        NAMESPACES = new ObjectOpenHashSet();
        NAMESPACES.add("cofh_core");
        NAMESPACES.add("archers_paradox");
        NAMESPACES.add("ensorcellation");
        NAMESPACES.add("redstone_arsenal");
        NAMESPACES.add("thermal");
    }
}

