/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.core.tileentity.EnderAirTile;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderAirBlock
extends AirBlock {
    protected static boolean teleport = true;
    protected static int duration = 40;

    public EnderAirBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderAirTile();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(8) == 0) {
            Utils.spawnBlockParticlesClient(worldIn, (IParticleData)ParticleTypes.field_197599_J, pos, rand, 2);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!teleport || Utils.isClientWorld(worldIn)) {
            return;
        }
        if (entityIn instanceof ItemEntity || entityIn instanceof ExperienceOrbEntity) {
            return;
        }
        BlockPos randPos = pos.func_177982_a(-128 + worldIn.field_73012_v.nextInt(257), worldIn.field_73012_v.nextInt(8), -128 + worldIn.field_73012_v.nextInt(257));
        if (!worldIn.func_180495_p(randPos).func_185904_a().func_76220_a()) {
            if (entityIn instanceof LivingEntity) {
                if (Utils.teleportEntityTo(entityIn, randPos)) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(CoreReferences.ENDERFERENCE, duration, 0, false, false));
                }
            } else if (worldIn.func_82737_E() % (long)duration == 0L) {
                entityIn.func_70107_b((double)randPos.func_177958_n(), (double)randPos.func_177956_o(), (double)randPos.func_177952_p());
                entityIn.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
    }
}

