/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.GrindstoneBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SolidGemSword
extends SwordItem {
    private final float baseAttackDamage;
    private final float baseAttackSpeed;
    private final IItemTier tier;

    public SolidGemSword(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties p_i48460_4_) {
        super(tier, attackDamageIn + 3, attackSpeedIn, p_i48460_4_);
        this.tier = tier;
        this.baseAttackDamage = (float)attackDamageIn + tier.func_200929_c();
        this.baseAttackSpeed = attackSpeedIn;
    }

    public float getBaseDamage() {
        return this.baseAttackDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue() && world.func_180495_p(blockpos).func_177230_c() instanceof GrindstoneBlock) {
            ItemStack stack = context.func_195996_i();
            if (!world.field_72995_K) {
                CompoundNBT nbt;
                int attackBoost;
                world.func_184133_a(null, context.func_195995_a(), SoundEvents.field_219642_eu, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                EffectInstance luck = context.func_195999_j().func_70660_b(Effects.field_188425_z);
                int randToolDamage = context.func_195999_j().field_70170_p.field_73012_v.nextInt(stack.func_77958_k() / 3);
                if (luck != null) {
                    randToolDamage /= luck.func_76458_c() + 1 + 1;
                }
                if ((attackBoost = this.getAttackDamageBoost(context.func_195996_i())) < 3) {
                    stack.func_222118_a(randToolDamage, (LivingEntity)context.func_195999_j(), p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
                }
                if ((nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT()).func_74764_b("Edge")) {
                    nbt.func_74768_a("Edge", nbt.func_74762_e("Edge") + 1);
                } else {
                    nbt.func_74768_a("Edge", 1);
                }
                stack.func_77982_d(nbt);
            }
        }
        return super.func_195939_a(context);
    }

    public int getAttackDamageBoost(ItemStack stack) {
        int kills = 0;
        int edge = 0;
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag.func_74764_b("Kills")) {
                kills = tag.func_74762_e("Kills");
            }
            if (tag.func_74764_b("Edge")) {
                edge = tag.func_74762_e("Edge");
            }
        }
        int attackDamageBonus = kills / 50 + edge;
        return Math.min(3, attackDamageBonus);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Kills")) {
            int killCount = stack.func_77978_p().func_74762_e("Kills");
            String kills = "\u00a7e" + Integer.toString(killCount);
            StringTextComponent slain = new StringTextComponent("Mobs Slain: " + kills);
            tooltip.add((ITextComponent)slain);
        }
        if (KeyboardHelper.isHoldingShift()) {
            float maxDamage = this.getBaseDamage() + 4.0f;
            int harvestLvl = this.tier.func_200925_d();
            int enchantLvl = this.tier.func_200927_e();
            int durability = this.tier.func_200926_a();
            int attackBoost = this.getAttackDamageBoost(stack);
            if (attackBoost >= 3) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a77Attack Damage: " + maxDamage));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a77Sharpened Damage: " + maxDamage));
            }
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Durability: " + durability));
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Enchantability: " + enchantLvl));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for tool details"));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        int edge;
        int kills;
        float attackSpeedBonus;
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
            kills = 0;
            edge = 0;
            if (stack.func_77942_o()) {
                CompoundNBT tag = stack.func_77978_p();
                if (tag.func_74764_b("Kills")) {
                    kills = tag.func_74762_e("Kills");
                }
                if (tag.func_74764_b("Edge")) {
                    edge = tag.func_74762_e("Edge");
                }
            }
        } else {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        attackSpeedBonus = attackSpeedBonus * (float)(kills / 10) * 10.0f / 100.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        float attackDamageBonus = kills / 50 + edge;
        attackDamageBonus = Math.min(3.0f, attackDamageBonus);
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getBaseDamage() + (double)attackDamageBonus, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getBaseAttackSpeed(), AttributeModifier.Operation.ADDITION));
        return multimap;
    }
}

