/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SolidGemHoe
extends HoeItem {
    private final float baseAttackSpeed;
    private final IItemTier tier;

    public SolidGemHoe(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.baseAttackSpeed = attackSpeedIn;
        this.tier = tier;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlotType.MAINHAND) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getBaseAttackSpeed(), AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Ores")) {
            int killCount = stack.func_77978_p().func_74762_e("Ores");
            String kills = "\u00a7e" + Integer.toString(killCount);
            StringTextComponent slain = new StringTextComponent("Ores Mined: " + kills);
            tooltip.add((ITextComponent)slain);
        }
        if (KeyboardHelper.isHoldingShift()) {
            int harvestLvl = this.tier.func_200925_d();
            int enchantLvl = this.tier.func_200927_e();
            int durability = this.tier.func_200926_a();
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Mining Level: " + harvestLvl));
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Durability: " + durability));
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Enchantability: " + enchantLvl));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for tool details"));
        }
    }
}

