/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.Main;
import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GemSetSword
extends SwordItem {
    private final float totalBaseDamage;
    private final float baseAttackSpeed;

    public GemSetSword() {
        super((IItemTier)ItemTier.DIAMOND, 3, -2.4f, new Item.Properties().func_200916_a(Main.TOOL_TAB));
        this.totalBaseDamage = 3.0f + ItemTier.DIAMOND.func_200929_c();
        this.baseAttackSpeed = -2.4f;
    }

    public GemSetSword(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties p_i48460_4_) {
        super(tier, attackDamageIn, attackSpeedIn, p_i48460_4_);
        this.totalBaseDamage = (float)attackDamageIn + tier.func_200929_c();
        this.baseAttackSpeed = attackSpeedIn;
    }

    public float getTotalBaseDamage() {
        return this.totalBaseDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getLevelProgress(ItemStack stack) {
        CompoundNBT nbt;
        int killProgress = 0;
        if (stack.func_77942_o() && (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() > 0 && (nbt = stack.func_77978_p()).func_74764_b("Kills")) {
            killProgress = nbt.func_74762_e("Kills") % (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() / ((Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() / 10);
        }
        return killProgress;
    }

    public int getCurrentLevel(ItemStack stack) {
        CompoundNBT nbt;
        int level = 0;
        if (stack.func_77942_o() && (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() > 0 && (nbt = stack.func_77978_p()).func_74764_b("Kills")) {
            level = nbt.func_74762_e("Kills") / (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get();
        }
        return level;
    }

    public String getEffectType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Effect")) {
            String effectName = stack.func_77978_p().func_74779_i("Effect");
            return effectName;
        }
        return null;
    }

    public void purifyPotionEffects(LivingEntity livingEntity) {
        if (!livingEntity.field_70170_p.field_72995_K) {
            ArrayList<Effect> effectsToRemove = new ArrayList<Effect>();
            for (EffectInstance effect : livingEntity.func_70651_bq()) {
                if (effect.func_188419_a().func_188408_i()) continue;
                effectsToRemove.add(effect.func_188419_a());
            }
            for (Effect e : effectsToRemove) {
                livingEntity.func_195063_d(e);
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77942_o() && stack.func_77978_p().func_74764_b("Effect");
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Effect")) {
                String effectType;
                Effect ringEffect = Effects.field_188425_z;
                switch (effectType = this.getEffectType(stack)) {
                    case "Speed": {
                        ringEffect = Effects.field_76424_c;
                        break;
                    }
                    case "Slowness": {
                        ringEffect = Effects.field_76421_d;
                        break;
                    }
                    case "Leaping": {
                        ringEffect = Effects.field_76430_j;
                        break;
                    }
                    case "Strength": {
                        ringEffect = Effects.field_76420_g;
                        break;
                    }
                    case "Healing": {
                        ringEffect = Effects.field_76432_h;
                        break;
                    }
                    case "Harming": {
                        ringEffect = Effects.field_76433_i;
                        break;
                    }
                    case "Poison": {
                        ringEffect = Effects.field_76436_u;
                        break;
                    }
                    case "Regeneration": {
                        ringEffect = Effects.field_76428_l;
                        break;
                    }
                    case "FireResistance": {
                        ringEffect = Effects.field_76426_n;
                        break;
                    }
                    case "WaterBreathing": {
                        ringEffect = Effects.field_76427_o;
                        break;
                    }
                    case "NightVision": {
                        ringEffect = Effects.field_76439_r;
                        break;
                    }
                    case "Invisibility": {
                        ringEffect = Effects.field_76441_p;
                        break;
                    }
                    case "Resistance": {
                        ringEffect = Effects.field_76429_m;
                        break;
                    }
                    case "SlowFalling": {
                        ringEffect = Effects.field_204839_B;
                        break;
                    }
                    case "Weakness": {
                        ringEffect = Effects.field_76437_t;
                        break;
                    }
                    case "Haste": {
                        ringEffect = Effects.field_76422_e;
                        break;
                    }
                    case "InstantHealth": {
                        ringEffect = Effects.field_76432_h;
                        break;
                    }
                    case "Absorption": {
                        ringEffect = Effects.field_76444_x;
                        break;
                    }
                    case "Luck": {
                        ringEffect = Effects.field_188425_z;
                        break;
                    }
                    case "SpellBreaking": {
                        if (attacker.field_70170_p.field_72995_K) break;
                        target.curePotionEffects(new ItemStack((IItemProvider)Items.field_151117_aB, 1));
                        break;
                    }
                    case "Purification": {
                        this.purifyPotionEffects(target);
                        break;
                    }
                    case "Levitation": {
                        ringEffect = Effects.field_188424_y;
                        break;
                    }
                    case "HealthBoost": {
                        ringEffect = Effects.field_180152_w;
                        break;
                    }
                    case "Saturation": {
                        ringEffect = Effects.field_76443_y;
                    }
                }
                if (!(effectType == null || effectType.equals("SpellBreaking") && effectType.equals("Purification"))) {
                    int pastDurration = 0;
                    if (target.func_70660_b(ringEffect) != null) {
                        pastDurration = target.func_70660_b(ringEffect).func_76459_b();
                    }
                    if (ringEffect.func_76403_b()) {
                        ringEffect.func_180793_a((Entity)target, (Entity)target, target, 0, 1.0);
                    } else {
                        target.func_195064_c(new EffectInstance(ringEffect, pastDurration + 200, 0, true, true));
                    }
                }
            }
            if (nbt.func_74764_b("Kills") && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                int level = this.getCurrentLevel(stack);
                int randomChance = attacker.field_70170_p.field_73012_v.nextInt(2);
                if (level >= 7 && randomChance == 1) {
                    return true;
                }
            }
        }
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String effectType = this.getEffectType(stack);
        if (this.getEffectType(stack) != null && this.func_77636_d(stack)) {
            String charmText = "\u00a75Charm: ";
            String curseText = "\u00a7cCurse: ";
            switch (effectType) {
                case "Speed": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Speed"));
                    break;
                }
                case "Slowness": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Slowness"));
                    break;
                }
                case "Leaping": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Leaping"));
                    break;
                }
                case "Strength": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Strength"));
                    break;
                }
                case "Healing": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Healing"));
                    break;
                }
                case "Harming": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Harming"));
                    break;
                }
                case "Poison": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Poison"));
                    break;
                }
                case "Regeneration": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Regeneration"));
                    break;
                }
                case "FireResistance": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Fire Resistance"));
                    break;
                }
                case "WaterBreathing": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Water Breathing"));
                    break;
                }
                case "NightVision": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Night Vision"));
                    break;
                }
                case "Invisibility": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Invisibility"));
                    break;
                }
                case "Resistance": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Resistance"));
                    break;
                }
                case "SlowFalling": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Slow Falling"));
                    break;
                }
                case "Weakness": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Weakness"));
                    break;
                }
                case "Haste": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Haste"));
                    break;
                }
                case "InstantHealth": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Instant Health"));
                    break;
                }
                case "Absorption": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Absorption"));
                    break;
                }
                case "Luck": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Luck"));
                    break;
                }
                case "SpellBreaking": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Spell Breaking"));
                    break;
                }
                case "Purification": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Purification"));
                    break;
                }
                case "Levitation": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Levitation"));
                    break;
                }
                case "HealthBoost": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Health Boost"));
                    break;
                }
                case "Saturation": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Saturation"));
                }
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Kills")) {
            int i;
            int killCount = stack.func_77978_p().func_74762_e("Kills");
            int levelProgress = this.getLevelProgress(stack);
            int currentLevel = this.getCurrentLevel(stack);
            String kills = "\u00a7e" + Integer.toString(killCount);
            String level = "Mastery Lvl: " + currentLevel;
            level = currentLevel < 5 ? level + " \u00a77Novice" : (currentLevel < 10 ? level + " \u00a7aAdept" : (currentLevel < 20 ? level + " \u00a7bHeroic" : (currentLevel < 30 ? level + " \u00a7dMaster" : (currentLevel < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            String progression = "|\u00a7a";
            for (i = 0; i < levelProgress; ++i) {
                progression = progression + "=";
            }
            progression = progression + "\u00a77";
            for (i = levelProgress; i < 10; ++i) {
                progression = progression + "-";
            }
            progression = progression + "\u00a7f|";
            StringTextComponent slain = new StringTextComponent("Mobs Slain: " + kills);
            StringTextComponent levelText = new StringTextComponent(level);
            StringTextComponent progText = new StringTextComponent(progression);
            tooltip.add((ITextComponent)slain);
            if (KeyboardHelper.isHoldingShift() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)levelText);
                tooltip.add((ITextComponent)progText);
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Gains bonus attack speed per level"));
                if (currentLevel >= 3) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Bleeds experience from mobs"));
                }
                if (currentLevel >= 7) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for mastery details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gains perks from slaying mobs"));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlotType.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int currentLevel = this.getCurrentLevel(stack);
        attackSpeedBonus = attackSpeedBonus * (float)currentLevel / 20.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getTotalBaseDamage(), AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }
}

