/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.Main;
import com.chrisgli.gemsnjewels.compat.CuriosCompatability;
import com.chrisgli.gemsnjewels.tools.JewelItemTier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

public class GemSetRing
extends Item {
    private final JewelItemTier tier;

    public GemSetRing(JewelItemTier tierIn) {
        super(new Item.Properties().func_200917_a(1).func_200918_c(30).func_200916_a(Main.TAB));
        this.tier = tierIn;
    }

    public String getEffectType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Effect")) {
            String effectName = stack.func_77978_p().func_74779_i("Effect");
            return effectName;
        }
        return null;
    }

    public void purifyPotionEffects(LivingEntity livingEntity) {
        if (!livingEntity.field_70170_p.field_72995_K) {
            ArrayList<Effect> effectsToRemove = new ArrayList<Effect>();
            for (EffectInstance effect : livingEntity.func_70651_bq()) {
                if (effect.func_188419_a().func_188408_i()) continue;
                effectsToRemove.add(effect.func_188419_a());
            }
            for (Effect e : effectsToRemove) {
                livingEntity.func_195063_d(e);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (this.func_77636_d(stack) && this.getEffectType(stack) != null) {
            String effectType;
            Effect ringEffect = Effects.field_188425_z;
            switch (effectType = this.getEffectType(stack)) {
                case "Speed": {
                    ringEffect = Effects.field_76424_c;
                    break;
                }
                case "Slowness": {
                    ringEffect = Effects.field_76421_d;
                    break;
                }
                case "Leaping": {
                    ringEffect = Effects.field_76430_j;
                    break;
                }
                case "Strength": {
                    ringEffect = Effects.field_76420_g;
                    break;
                }
                case "Healing": {
                    ringEffect = Effects.field_76432_h;
                    break;
                }
                case "Harming": {
                    ringEffect = Effects.field_76433_i;
                    break;
                }
                case "Poison": {
                    ringEffect = Effects.field_76436_u;
                    break;
                }
                case "Regeneration": {
                    ringEffect = Effects.field_76428_l;
                    break;
                }
                case "FireResistance": {
                    ringEffect = Effects.field_76426_n;
                    break;
                }
                case "WaterBreathing": {
                    ringEffect = Effects.field_76427_o;
                    break;
                }
                case "NightVision": {
                    ringEffect = Effects.field_76439_r;
                    break;
                }
                case "Invisibility": {
                    ringEffect = Effects.field_76441_p;
                    break;
                }
                case "Resistance": {
                    ringEffect = Effects.field_76429_m;
                    break;
                }
                case "SlowFalling": {
                    ringEffect = Effects.field_204839_B;
                    break;
                }
                case "Weakness": {
                    ringEffect = Effects.field_76437_t;
                    break;
                }
                case "Haste": {
                    ringEffect = Effects.field_76422_e;
                    break;
                }
                case "InstantHealth": {
                    ringEffect = Effects.field_76432_h;
                    break;
                }
                case "Absorption": {
                    ringEffect = Effects.field_76444_x;
                    break;
                }
                case "Luck": {
                    ringEffect = Effects.field_188425_z;
                    break;
                }
                case "SpellBreaking": {
                    if (worldIn.field_72995_K) break;
                    entityLiving.curePotionEffects(new ItemStack((IItemProvider)Items.field_151117_aB, 1));
                    break;
                }
                case "Purification": {
                    this.purifyPotionEffects(entityLiving);
                    break;
                }
                case "Levitation": {
                    ringEffect = Effects.field_188424_y;
                    break;
                }
                case "HealthBoost": {
                    ringEffect = Effects.field_180152_w;
                    break;
                }
                case "Saturation": {
                    ringEffect = Effects.field_76443_y;
                }
            }
            stack.func_222118_a(1, entityLiving, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
            if (effectType.equals("SpellBreaking") || effectType.equals("Purification")) {
                return stack;
            }
            PlayerEntity playerEntity = entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null;
            int pastDurration = 0;
            if (entityLiving.func_70660_b(ringEffect) != null) {
                pastDurration = entityLiving.func_70660_b(ringEffect).func_76459_b();
            }
            if (ringEffect.func_76403_b()) {
                ringEffect.func_180793_a((Entity)playerEntity, (Entity)playerEntity, entityLiving, 0, 1.0);
            } else {
                entityLiving.func_195064_c(new EffectInstance(ringEffect, pastDurration + 200, 0, true, true));
            }
        }
        return stack;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Effect")) {
            return true;
        }
        return super.func_77636_d(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT unused) {
        boolean isCuriosLoaded;
        boolean bl = isCuriosLoaded = ModList.get() != null && ModList.get().getModContainerById("curios").isPresent();
        if (isCuriosLoaded) {
            return CuriosCompatability.initCapabilities(stack);
        }
        return super.initCapabilities(stack, unused);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String effectType = this.getEffectType(stack);
        if (this.getEffectType(stack) != null && this.func_77636_d(stack)) {
            String charmText = "\u00a75Charm: ";
            String curseText = "\u00a7cCurse: ";
            switch (effectType) {
                case "Speed": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Speed"));
                    break;
                }
                case "Slowness": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Slowness"));
                    break;
                }
                case "Leaping": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Leaping"));
                    break;
                }
                case "Strength": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Strength"));
                    break;
                }
                case "Healing": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Healing"));
                    break;
                }
                case "Harming": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Harming"));
                    break;
                }
                case "Poison": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Poison"));
                    break;
                }
                case "Regeneration": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Regeneration"));
                    break;
                }
                case "FireResistance": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Fire Resistance"));
                    break;
                }
                case "WaterBreathing": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Water Breathing"));
                    break;
                }
                case "NightVision": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Night Vision"));
                    break;
                }
                case "Invisibility": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Invisibility"));
                    break;
                }
                case "Resistance": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Resistance"));
                    break;
                }
                case "SlowFalling": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Slow Falling"));
                    break;
                }
                case "Weakness": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Weakness"));
                    break;
                }
                case "Haste": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Haste"));
                    break;
                }
                case "InstantHealth": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Instant Health"));
                    break;
                }
                case "Absorption": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Absorption"));
                    break;
                }
                case "Luck": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Luck"));
                    break;
                }
                case "SpellBreaking": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Spell Breaking"));
                    break;
                }
                case "Purification": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Purification"));
                    break;
                }
                case "Levitation": {
                    tooltip.add((ITextComponent)new StringTextComponent(curseText + "Levitation"));
                    break;
                }
                case "HealthBoost": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Health Boost"));
                    break;
                }
                case "Saturation": {
                    tooltip.add((ITextComponent)new StringTextComponent(charmText + "Saturation"));
                }
            }
        }
    }

    public int func_77619_b() {
        return this.tier.getEnchantability();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.tier.getRepairMaterial().test(repair) || super.func_82789_a(toRepair, repair);
    }
}

