/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GemSetHoe
extends HoeItem {
    private final float baseAttackSpeed;
    private final int baseAttackDamage;

    public GemSetHoe(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.baseAttackSpeed = attackSpeedIn;
        this.baseAttackDamage = attackDamageIn;
    }

    public int getBaseAttackDamage() {
        return this.baseAttackDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getLevelProgress(ItemStack stack) {
        double blockCount = 0.0;
        double cropCount = 0.0;
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeHoesPerLevel.get();
        int cropsPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeCropsPerLevel.get();
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Blocks") && blocksPerLevel > 0) {
                blockCount = (double)(nbt.func_74762_e("Blocks") % blocksPerLevel) * (10.0 / (double)blocksPerLevel);
            }
            if (nbt.func_74764_b("Crops") && cropsPerLevel > 0) {
                cropCount = (double)(nbt.func_74762_e("Crops") % cropsPerLevel) * (10.0 / (double)cropsPerLevel);
            }
        }
        return (int)Math.floor(blockCount + cropCount);
    }

    public int getCurrentLevel(ItemStack stack) {
        double blockProgress = 0.0;
        double cropProgress = 0.0;
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeHoesPerLevel.get();
        int cropsPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeCropsPerLevel.get();
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Blocks") && blocksPerLevel > 0) {
                blockProgress = (double)nbt.func_74762_e("Blocks") / (double)blocksPerLevel;
            }
            if (nbt.func_74764_b("Crops") && cropsPerLevel > 0) {
                cropProgress = (double)nbt.func_74762_e("Crops") / (double)cropsPerLevel;
            }
        }
        return (int)(blockProgress + cropProgress);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType pass = super.func_195939_a(context);
        if (pass.equals((Object)ActionResultType.SUCCESS) || pass.equals((Object)ActionResultType.CONSUME)) {
            ItemStack stack = context.func_195996_i();
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            if (nbt.func_74764_b("Blocks")) {
                nbt.func_74768_a("Blocks", nbt.func_74762_e("Blocks") + 1);
            } else {
                nbt.func_74768_a("Blocks", 1);
            }
            stack.func_77982_d(nbt);
            if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                int level = this.getCurrentLevel(stack);
                World world = context.func_195991_k();
                if (level >= 7 && !world.field_72995_K) {
                    PlayerEntity playerentity = context.func_195999_j();
                    int randomChance = world.field_73012_v.nextInt(2);
                    if (playerentity != null && randomChance == 1) {
                        context.func_195996_i().func_222118_a(-1, (LivingEntity)playerentity, p_220041_1_ -> p_220041_1_.func_213334_d(context.func_221531_n()));
                    }
                }
                if (level >= 3 && !world.field_72995_K) {
                    int j;
                    for (int i = world.field_73012_v.nextInt(2) + world.field_73012_v.nextInt(2); i > 0; i -= j) {
                        j = ExperienceOrbEntity.func_70527_a((int)i);
                        world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)context.func_195995_a().func_177958_n(), (double)(context.func_195995_a().func_177956_o() + 1), (double)context.func_195995_a().func_177952_p(), j));
                    }
                }
            }
        }
        return pass;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        CropsBlock crop;
        if (state.func_177230_c() instanceof CropsBlock && (crop = (CropsBlock)state.func_177230_c()).func_185525_y(state)) {
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            if (nbt.func_74764_b("Crops")) {
                nbt.func_74768_a("Crops", nbt.func_74762_e("Crops") + 1);
            } else {
                nbt.func_74768_a("Crops", 1);
            }
            stack.func_77982_d(nbt);
            return true;
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int level = this.getCurrentLevel(stack);
        if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int randomChance = attacker.field_70170_p.field_73012_v.nextInt(2);
            if (level >= 7 && randomChance == 1) {
                return true;
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlotType.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int lvl = this.getCurrentLevel(stack);
        attackSpeedBonus = attackSpeedBonus * (float)lvl / 20.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && (stack.func_77978_p().func_74764_b("Blocks") || stack.func_77978_p().func_74764_b("Crops"))) {
            int i;
            int blockCount = stack.func_77978_p().func_74762_e("Blocks");
            String blocks = "\u00a7e" + Integer.toString(blockCount);
            int cropCount = stack.func_77978_p().func_74762_e("Crops");
            String crops = "\u00a7e" + Integer.toString(cropCount);
            if (blockCount > 0) {
                StringTextComponent hoed = new StringTextComponent("Blocks Hoed: " + blocks);
                tooltip.add((ITextComponent)hoed);
            }
            if (cropCount > 0) {
                StringTextComponent farmed = new StringTextComponent("Crops Farmed: " + crops);
                tooltip.add((ITextComponent)farmed);
            }
            int lvlProgress = this.getLevelProgress(stack);
            int lvl = this.getCurrentLevel(stack);
            String level = "Lvl: " + lvl;
            level = lvl < 5 ? level + " \u00a77Novice" : (lvl < 10 ? level + " \u00a7aAdept" : (lvl < 20 ? level + " \u00a7bHeroic" : (lvl < 30 ? level + " \u00a7dMaster" : (lvl < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            String progression = "|\u00a7a";
            for (i = 0; i < lvlProgress; ++i) {
                progression = progression + "=";
            }
            progression = progression + "\u00a77";
            for (i = lvlProgress; i < 10; ++i) {
                progression = progression + "-";
            }
            progression = progression + "\u00a7f|";
            StringTextComponent levelText = new StringTextComponent(level);
            StringTextComponent progText = new StringTextComponent(progression);
            if (KeyboardHelper.isHoldingShift() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)levelText);
                tooltip.add((ITextComponent)progText);
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Gains bonus swing speed per level"));
                if (lvl >= 3) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Hoeing blocks grants experience"));
                }
                if (lvl >= 7) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for level details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gains perks from use"));
        }
    }
}

