/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GemSetCrossbow
extends CrossbowItem {
    public GemSetCrossbow(Item.Properties propertiesIn) {
        super(propertiesIn);
    }

    public float getTotalBaseDamage() {
        return 5.0f;
    }

    public int getLevelProgress(ItemStack stack) {
        int shotProgress = 0;
        int killProgress = 0;
        if (stack.func_77942_o() && (Integer)GemsNJewelsConfig.COMMON.crossbowShotsFiredPerLevel.get() > 0) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Shots")) {
                shotProgress = nbt.func_74762_e("Shots") % (Integer)GemsNJewelsConfig.COMMON.crossbowShotsFiredPerLevel.get() / Math.max(1, (Integer)GemsNJewelsConfig.COMMON.crossbowShotsFiredPerLevel.get() / 10);
            }
            if (nbt.func_74764_b("Kills")) {
                killProgress = nbt.func_74762_e("Kills") % (Integer)GemsNJewelsConfig.COMMON.crossbowKillsPerLevel.get() / Math.max(1, (Integer)GemsNJewelsConfig.COMMON.crossbowKillsPerLevel.get() / 10);
            }
        }
        return (shotProgress + killProgress) % 10;
    }

    public int getCurrentLevel(ItemStack stack) {
        double killProgress = 0.0;
        double shotProgress = 0.0;
        int killsPerLevel = (Integer)GemsNJewelsConfig.COMMON.crossbowKillsPerLevel.get();
        int shotsPerLevel = (Integer)GemsNJewelsConfig.COMMON.crossbowShotsFiredPerLevel.get();
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Kills") && killsPerLevel > 0) {
                killProgress = (double)nbt.func_74762_e("Kills") / (double)killsPerLevel;
            }
            if (nbt.func_74764_b("Shots") && shotsPerLevel > 0) {
                shotProgress = (double)nbt.func_74762_e("Shots") / (double)shotsPerLevel;
            }
        }
        return (int)(killProgress + shotProgress);
    }

    public float getAccuracy(ItemStack stack) {
        return Math.max(0.0f, 1.0f - (float)this.getCurrentLevel(stack) / 10.0f);
    }

    private float getVelocity(ItemStack p_220013_0_) {
        float baseVelocity = GemSetCrossbow.func_220019_a((ItemStack)p_220013_0_, (Item)Items.field_196152_dE) ? 1.6f : 3.15f;
        float levelBonus = (float)this.getCurrentLevel(p_220013_0_) / 5.0f;
        float maxVelocity = ((Double)GemsNJewelsConfig.COMMON.crossbowMaxVelocityLevel.get()).floatValue();
        return Math.min(maxVelocity, baseVelocity + levelBonus);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (GemSetCrossbow.isCharged(itemstack)) {
            CompoundNBT nbt = itemstack.func_77942_o() ? itemstack.func_77978_p() : new CompoundNBT();
            if (nbt.func_74764_b("Shots")) {
                nbt.func_74768_a("Shots", nbt.func_74762_e("Shots") + 1);
            } else {
                nbt.func_74768_a("Shots", 1);
            }
            itemstack.func_77982_d(nbt);
            int level = this.getCurrentLevel(itemstack);
            GemSetCrossbow.fireProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, this.getVelocity(itemstack), this.getAccuracy(itemstack), level);
            GemSetCrossbow.setCharged(itemstack, false);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!playerIn.func_213356_f(itemstack).func_190926_b()) {
            if (!GemSetCrossbow.isCharged(itemstack)) {
                playerIn.func_184598_c(handIn);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        float f = GemSetCrossbow.getCharge(i, stack);
        if (f >= 1.0f && !GemSetCrossbow.isCharged(stack) && GemSetCrossbow.hasAmmo(entityLiving, stack)) {
            GemSetCrossbow.setCharged(stack, true);
            SoundCategory soundcategory = entityLiving instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a((PlayerEntity)null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public static void fireProjectiles(World worldIn, LivingEntity shooter, Hand handIn, ItemStack stack, float velocityIn, float inaccuracyIn, int level) {
        List<ItemStack> list = GemSetCrossbow.getChargedProjectiles(stack);
        float[] afloat = GemSetCrossbow.getRandomSoundPitches(shooter.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                GemSetCrossbow.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, 0.0f, level);
                continue;
            }
            if (i == 1) {
                GemSetCrossbow.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, -10.0f, level);
                continue;
            }
            if (i != 2) continue;
            GemSetCrossbow.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, 10.0f, level);
        }
        GemSetCrossbow.fireProjectilesAfter(worldIn, shooter, stack);
    }

    private static void fireProjectile(World worldIn, LivingEntity shooter, Hand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle, int level) {
        if (!worldIn.field_72995_K) {
            AbstractArrowEntity projectileentity;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                projectileentity = new FireworkRocketEntity(worldIn, projectile, (Entity)shooter, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                projectileentity = GemSetCrossbow.createArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                icrossbowuser.func_82196_d(icrossbowuser.func_70638_az(), projectileAngle);
            } else {
                Vector3d vec3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vec3d1), projectileAngle, true);
                Vector3d vec3d = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vec3d);
                vector3f.func_214905_a(quaternion);
                projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, inaccuracy);
            }
            int randomChance = worldIn.field_73012_v.nextInt(2);
            boolean damageAmount = false;
            if (level >= 7 && randomChance == 1) {
                damageAmount = true;
            }
            crossbow.func_222118_a(damageAmount ? 0 : (flag ? 3 : 1), shooter, p_220017_1_ -> p_220017_1_.func_213334_d(handIn));
            worldIn.func_217376_c((Entity)projectileentity);
            worldIn.func_184148_a((PlayerEntity)null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static AbstractArrowEntity createArrow(World worldIn, LivingEntity shooter, ItemStack crossbow, ItemStack ammo) {
        ArrowItem arrowitem = (ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, ammo, shooter);
        abstractarrowentity.func_70243_d(true);
        abstractarrowentity.func_213869_a(SoundEvents.field_219609_bA);
        abstractarrowentity.func_213865_o(true);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)crossbow);
        if (i > 0) {
            abstractarrowentity.func_213872_b((byte)i);
        }
        return abstractarrowentity;
    }

    private static void fireProjectilesAfter(World worldIn, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)shooter;
            if (!worldIn.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, stack);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
        GemSetCrossbow.clearProjectiles(stack);
    }

    private static void clearProjectiles(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    private static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, GemSetCrossbow.getRandomSoundPitch(flag), GemSetCrossbow.getRandomSoundPitch(!flag)};
    }

    private static float getRandomSoundPitch(boolean flagIn) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    public static void setCharged(ItemStack stack, boolean chargedIn) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74757_a("Charged", chargedIn);
    }

    public static boolean isCharged(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74767_n("Charged");
    }

    public int func_77626_a(ItemStack stack) {
        return GemSetCrossbow.getChargeTime(stack) + 3;
    }

    public static int getChargeTime(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)GemSetCrossbow.getChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private static boolean hasAmmo(LivingEntity entityIn, ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(stack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (GemSetCrossbow.func_220023_a(entityIn, stack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean func_220023_a(LivingEntity p_220023_0_, ItemStack p_220023_1_, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = p_220023_2_.func_77979_a(1);
            if (p_220023_2_.func_190926_b() && p_220023_0_ instanceof PlayerEntity) {
                ((PlayerEntity)p_220023_0_).field_71071_by.func_184437_d(p_220023_2_);
            }
        } else {
            itemstack = p_220023_2_.func_77946_l();
        }
        GemSetCrossbow.addChargedProjectile(p_220023_1_, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT compoundnbt = crossbow.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int i;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int levelProgress = this.getLevelProgress(stack);
        int currentLevel = this.getCurrentLevel(stack);
        StringTextComponent slain = new StringTextComponent("Velocity: " + (float)Math.round(this.getVelocity(stack) * 100.0f) / 100.0f + " Accuracy: " + (float)Math.round(this.getAccuracy(stack) * 100.0f) / 100.0f);
        tooltip.add((ITextComponent)slain);
        String level = "Mastery Lvl: " + currentLevel;
        level = currentLevel < 5 ? level + " \u00a77Novice" : (currentLevel < 10 ? level + " \u00a7aAdept" : (currentLevel < 20 ? level + " \u00a7bHeroic" : (currentLevel < 30 ? level + " \u00a7dMaster" : (currentLevel < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
        String progression = "|\u00a7a";
        for (i = 0; i < levelProgress; ++i) {
            progression = progression + "=";
        }
        progression = progression + "\u00a77";
        for (i = levelProgress; i < 10; ++i) {
            progression = progression + "-";
        }
        progression = progression + "\u00a7f|";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Shots")) {
            int shotCount = stack.func_77978_p().func_74762_e("Shots");
            StringTextComponent shots = new StringTextComponent("Shots Fired: \u00a7e" + shotCount);
            tooltip.add((ITextComponent)shots);
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Kills")) {
            int killCount = stack.func_77978_p().func_74762_e("Kills");
            StringTextComponent kills = new StringTextComponent("Mobs Slain: \u00a7e" + killCount);
            tooltip.add((ITextComponent)kills);
        }
        StringTextComponent levelText = new StringTextComponent(level);
        StringTextComponent progText = new StringTextComponent(progression);
        if (stack.func_77942_o() && (stack.func_77978_p().func_74764_b("Kills") || stack.func_77978_p().func_74764_b("Shots"))) {
            if (KeyboardHelper.isHoldingShift() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)levelText);
                tooltip.add((ITextComponent)progText);
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Gains bonus firepower per level"));
                if (currentLevel >= 3) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Bleeds experience from mobs"));
                }
                if (currentLevel >= 7) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for mastery details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gains perks from firing shots or slaying mobs"));
        }
    }
}

