/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class GemSetBow
extends BowItem {
    public GemSetBow(Item.Properties builder) {
        super(builder);
    }

    public float getTotalBaseDamage() {
        return 7.0f;
    }

    public int getLevelProgress(ItemStack stack) {
        int shotProgress = 0;
        int killProgress = 0;
        if (stack.func_77942_o() && (Integer)GemsNJewelsConfig.COMMON.bowShotsFiredPerLevel.get() > 0) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Shots")) {
                shotProgress = nbt.func_74762_e("Shots") % (Integer)GemsNJewelsConfig.COMMON.bowShotsFiredPerLevel.get() / Math.max(1, (Integer)GemsNJewelsConfig.COMMON.bowShotsFiredPerLevel.get() / 10);
            }
            if (nbt.func_74764_b("Kills")) {
                killProgress = nbt.func_74762_e("Kills") % (Integer)GemsNJewelsConfig.COMMON.bowKillsPerLevel.get() / Math.max(1, (Integer)GemsNJewelsConfig.COMMON.bowKillsPerLevel.get() / 10);
            }
        }
        return (shotProgress + killProgress) % 10;
    }

    public int getCurrentLevel(ItemStack stack) {
        double killProgress = 0.0;
        double shotProgress = 0.0;
        int killsPerLevel = (Integer)GemsNJewelsConfig.COMMON.bowKillsPerLevel.get();
        int shotsPerLevel = (Integer)GemsNJewelsConfig.COMMON.bowShotsFiredPerLevel.get();
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Kills") && killsPerLevel > 0) {
                killProgress = (double)nbt.func_74762_e("Kills") / (double)killsPerLevel;
            }
            if (nbt.func_74764_b("Shots") && shotsPerLevel > 0) {
                shotProgress = (double)nbt.func_74762_e("Shots") / (double)shotsPerLevel;
            }
        }
        return (int)(killProgress + shotProgress);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            boolean flag = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.func_213356_f(stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)playerentity, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float f = GemSetBow.func_185059_b((int)i);
                f *= 20.0f / Math.max(1.0f, this.getDrawFactor(stack));
                if (!((double)(f = Math.min(1.4f, f)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
                    if (!worldIn.field_72995_K) {
                        CompoundNBT nbt;
                        int k;
                        int j;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
                        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, itemstack, (LivingEntity)playerentity);
                        abstractarrowentity = this.customArrow(abstractarrowentity);
                        abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            abstractarrowentity.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            abstractarrowentity.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            abstractarrowentity.func_70015_d(100);
                        }
                        if ((nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT()).func_74764_b("Shots")) {
                            nbt.func_74768_a("Shots", nbt.func_74762_e("Shots") + 1);
                        } else {
                            nbt.func_74768_a("Shots", 1);
                        }
                        stack.func_77982_d(nbt);
                        int level = this.getCurrentLevel(stack);
                        int randomChance = worldIn.field_73012_v.nextInt(2);
                        int damageAmount = 1;
                        if (level >= 7 && randomChance == 1) {
                            damageAmount = 0;
                        }
                        stack.func_222118_a(damageAmount, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.func_213334_d(playerentity.func_184600_cs()));
                        if (flag1 || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)abstractarrowentity);
                    }
                    worldIn.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !playerentity.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            playerentity.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public float getDrawFactor(ItemStack stack) {
        if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int discount = this.getCurrentLevel(stack);
            return Math.max(1.0f, 20.0f - (float)discount);
        }
        return 20.0f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int i;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        StringTextComponent slain = new StringTextComponent("Draw Factor: " + this.getDrawFactor(stack));
        tooltip.add((ITextComponent)slain);
        int levelProgress = this.getLevelProgress(stack);
        int currentLevel = this.getCurrentLevel(stack);
        String level = "Mastery Lvl: " + currentLevel;
        level = currentLevel < 5 ? level + " \u00a77Novice" : (currentLevel < 10 ? level + " \u00a7aAdept" : (currentLevel < 20 ? level + " \u00a7bHeroic" : (currentLevel < 30 ? level + " \u00a7dMaster" : (currentLevel < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
        String progression = "|\u00a7a";
        for (i = 0; i < levelProgress; ++i) {
            progression = progression + "=";
        }
        progression = progression + "\u00a77";
        for (i = levelProgress; i < 10; ++i) {
            progression = progression + "-";
        }
        progression = progression + "\u00a7f|";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Shots")) {
            int shotCount = stack.func_77978_p().func_74762_e("Shots");
            StringTextComponent shots = new StringTextComponent("Shots Fired: \u00a7e" + shotCount);
            tooltip.add((ITextComponent)shots);
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Kills")) {
            int killCount = stack.func_77978_p().func_74762_e("Kills");
            StringTextComponent kills = new StringTextComponent("Mobs Slain: \u00a7e" + killCount);
            tooltip.add((ITextComponent)kills);
        }
        StringTextComponent levelText = new StringTextComponent(level);
        StringTextComponent progText = new StringTextComponent(progression);
        if (stack.func_77942_o() && (stack.func_77978_p().func_74764_b("Kills") || stack.func_77978_p().func_74764_b("Shots"))) {
            if (KeyboardHelper.isHoldingShift() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)levelText);
                tooltip.add((ITextComponent)progText);
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Gains bonus draw speed per level"));
                if (currentLevel >= 3) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Bleeds experience from mobs"));
                }
                if (currentLevel >= 7) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for mastery details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gains perks from firing shots or slaying mobs"));
        }
    }
}

