/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="gemsnjewels", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GemsNJewelsConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public Map<String, ForgeConfigSpec.BooleanValue> overWorldGenMap = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        public Map<String, ForgeConfigSpec.BooleanValue> netherGenMap = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        public ForgeConfigSpec.BooleanValue toolLevelingEnabled;
        public ForgeConfigSpec.BooleanValue uniqueBiomeGenerationEnabled;
        public ForgeConfigSpec.ConfigValue<Integer> swordKillsPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> pickaxeOresPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> pickaxeBlocksPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> axeKillsPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> axeLogsPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> axeBlocksPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> shovelBlocksPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> hoeHoesPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> hoeCropsPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> bowKillsPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> bowShotsFiredPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> crossbowKillsPerLevel;
        public ForgeConfigSpec.ConfigValue<Integer> crossbowShotsFiredPerLevel;
        public ForgeConfigSpec.ConfigValue<Double> crossbowMaxVelocityLevel;
        public ForgeConfigSpec.BooleanValue lootSpawnEnabled;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("gem set tools leveling config").push("tool leveling");
            this.toolLevelingEnabled = builder.comment("sets whether gem set tools gain perks from levels").translation("gemsnjewels.configgui.toolLevelingEnabled").worldRestart().define("isToolLevelingEnabled", true);
            builder.push("leveling config");
            this.swordKillsPerLevel = builder.translation("gemsnjewels.configgui.swordKillsPerLevel").worldRestart().define("swordKillsPerLevel", (Object)10);
            this.pickaxeOresPerLevel = builder.translation("gemsnjewels.configgui.pickaxeOresPerLevel").worldRestart().define("pickaxeOresPerLevel", (Object)10);
            this.pickaxeBlocksPerLevel = builder.translation("gemsnjewels.configgui.pickaxeBlocksPerLevel").worldRestart().define("pickaxeBlocksPerLevel", (Object)20);
            this.axeKillsPerLevel = builder.translation("gemsnjewels.configgui.axeKillsPerLevel").worldRestart().define("axeKillsPerLevel", (Object)10);
            this.axeLogsPerLevel = builder.translation("gemsnjewels.configgui.axeLogsPerLevel").worldRestart().define("axeLogsPerLevel", (Object)10);
            this.axeBlocksPerLevel = builder.translation("gemsnjewels.configgui.axeBlocksPerLevel").worldRestart().define("axeBlocksPerLevel", (Object)20);
            this.shovelBlocksPerLevel = builder.translation("gemsnjewels.configgui.shovelBlocksPerLevel").worldRestart().define("shovelBlocksPerLevel", (Object)50);
            this.hoeHoesPerLevel = builder.translation("gemsnjewels.configgui.hoeHoesPerLevel").worldRestart().define("hoeHoesPerLevel", (Object)50);
            this.hoeCropsPerLevel = builder.translation("gemsnjewels.configgui.hoeCropsPerLevel").worldRestart().define("hoeCropsPerLevel", (Object)20);
            this.bowKillsPerLevel = builder.translation("gemsnjewels.configgui.bowKillsPerLevel").worldRestart().define("bowKillsPerLevel", (Object)10);
            this.bowShotsFiredPerLevel = builder.translation("gemsnjewels.configgui.bowShotsFiredPerLevel").worldRestart().define("bowShotsFiredPerLevel", (Object)100);
            this.crossbowKillsPerLevel = builder.translation("gemsnjewels.configgui.crossbowKillsPerLevel").worldRestart().define("crossbowKillsPerLevel", (Object)10);
            this.crossbowShotsFiredPerLevel = builder.translation("gemsnjewels.configgui.crossbowShotsFiredPerLevel").worldRestart().define("crossbowShotsFiredPerLevel", (Object)100);
            this.crossbowMaxVelocityLevel = builder.translation("gemsnjewels.configgui.crossbowMaxVelocityLevel").worldRestart().define("crossbowMaxVelocityLevel", (Object)10.0);
            builder.pop();
            builder.pop();
            builder.comment("whether mod loot spawns in chests").push("loot spawning");
            this.lootSpawnEnabled = builder.translation("gemsnjewels.configgui.lootSpawnEnabled").worldRestart().define("isLootSpawnEnabled", true);
            builder.pop();
            builder.comment("whether minor gems spawn in unique biomes").push("gem unique biome generation");
            this.uniqueBiomeGenerationEnabled = builder.comment("sets whether minor gems spawn uniquely in specific biomes.Disable to make enabled gems generate in every overworld biome").translation("gemsnjewels.configgui.uniqueBiomeGenerationEnabled").worldRestart().define("isUniqueBiomeGenerationEnabled", true);
            builder.pop();
            builder.comment("overworld world generation config").push("overworld generation");
            this.overWorldGenMap.put("emerald", builder.comment("sets whether mod emerald ore generation is enabled").translation("gemsnjewels.configgui.emeraldOreGeneration").worldRestart().define("emerald_OreGenEnabled", true));
            this.overWorldGenMap.put("ruby", builder.translation("gemsnjewels.configgui.rubyOreGeneration").worldRestart().define("ruby_OreGenEnabled", true));
            this.overWorldGenMap.put("sapphire", builder.translation("gemsnjewels.configgui.sapphireOreGeneration").worldRestart().define("sapphire_OreGenEnabled", true));
            this.overWorldGenMap.put("amethyst", builder.translation("gemsnjewels.configgui.amethystOreGeneration").worldRestart().define("amethyst_OreGenEnabled", true));
            this.overWorldGenMap.put("opal", builder.translation("gemsnjewels.configgui.opalOreGeneration").worldRestart().define("opal_OreGenEnabled", true));
            this.overWorldGenMap.put("garnet", builder.translation("gemsnjewels.configgui.garnetOreGeneration").worldRestart().define("garnet_OreGenEnabled", true));
            this.overWorldGenMap.put("topaz", builder.translation("gemsnjewels.configgui.topazOreGeneration").worldRestart().define("topaz_OreGenEnabled", true));
            this.overWorldGenMap.put("peridot", builder.translation("gemsnjewels.configgui.peridotOreGeneration").worldRestart().define("peridot_OreGenEnabled", true));
            this.overWorldGenMap.put("aquamarine", builder.translation("gemsnjewels.configgui.aquamarineOreGeneration").worldRestart().define("aquamarine_OreGenEnabled", true));
            this.overWorldGenMap.put("zircon", builder.translation("gemsnjewels.configgui.zirconOreGeneration").worldRestart().define("zircon_OreGenEnabled", true));
            this.overWorldGenMap.put("alexandrite", builder.translation("gemsnjewels.configgui.alexandriteOreGeneration").worldRestart().define("alexandrite_OreGenEnabled", true));
            this.overWorldGenMap.put("tanzanite", builder.translation("gemsnjewels.configgui.tanzaniteOreGeneration").worldRestart().define("tanzanite_OreGenEnabled", true));
            this.overWorldGenMap.put("tourmaline", builder.translation("gemsnjewels.configgui.tourmalineOreGeneration").worldRestart().define("tourmaline_OreGenEnabled", true));
            this.overWorldGenMap.put("spinel", builder.translation("gemsnjewels.configgui.spinelOreGeneration").worldRestart().define("spinel_OreGenEnabled", true));
            this.overWorldGenMap.put("black_opal", builder.translation("gemsnjewels.configgui.blackOpalOreGeneration").worldRestart().define("blackOpal_OreGenEnabled", true));
            this.overWorldGenMap.put("citrine", builder.translation("gemsnjewels.configgui.citrineOreGeneration").worldRestart().define("citrine_OreGenEnabled", true));
            this.overWorldGenMap.put("morganite", builder.translation("gemsnjewels.configgui.morganiteOreGeneration").worldRestart().define("morganite_OreGenEnabled", true));
            this.overWorldGenMap.put("ametrine", builder.translation("gemsnjewels.configgui.ametrineOreGeneration").worldRestart().define("ametrine_OreGenEnabled", true));
            this.overWorldGenMap.put("iolite", builder.translation("gemsnjewels.configgui.ioliteOreGeneration").worldRestart().define("iolite_OreGenEnabled", true));
            this.overWorldGenMap.put("kunzite", builder.translation("gemsnjewels.configgui.kunziteOreGeneration").worldRestart().define("kunzite_OreGenEnabled", true));
            this.overWorldGenMap.put("silver", builder.translation("gemsnjewels.configgui.silverOreGeneration").worldRestart().define("silver_OreGenEnabled", false));
            builder.pop();
            builder.push("nether generation");
            this.netherGenMap.put("diamond", builder.translation("gemsnjewels.configgui.diamondOreGeneration").worldRestart().define("diamond_NetherOreGenEnabled", true));
            this.netherGenMap.put("v_emerald", builder.comment("sets whether vanilla emerald ore nether generation is enabled").translation("gemsnjewels.configgui.v_emeraldOreGeneration").worldRestart().define("v_emerald_NetherOreGenEnabled", true));
            this.netherGenMap.put("emerald", builder.comment("sets whether mod emerald ore nether generation is enabled").translation("gemsnjewels.configgui.emeraldOreGeneration").worldRestart().define("emerald_NetherOreGenEnabled", true));
            this.netherGenMap.put("ruby", builder.translation("gemsnjewels.configgui.rubyOreGeneration").worldRestart().define("ruby_NetherOreGenEnabled", true));
            this.netherGenMap.put("sapphire", builder.translation("gemsnjewels.configgui.sapphireOreGeneration").worldRestart().define("sapphire_NetherOreGenEnabled", true));
            this.netherGenMap.put("amethyst", builder.translation("gemsnjewels.configgui.amethystOreGeneration").worldRestart().define("amethyst_NetherOreGenEnabled", true));
            this.netherGenMap.put("opal", builder.translation("gemsnjewels.configgui.opalOreGeneration").worldRestart().define("opal_NetherOreGenEnabled", true));
            this.netherGenMap.put("garnet", builder.translation("gemsnjewels.configgui.garnetOreGeneration").worldRestart().define("garnet_NetherOreGenEnabled", true));
            this.netherGenMap.put("topaz", builder.translation("gemsnjewels.configgui.topazOreGeneration").worldRestart().define("topaz_NetherOreGenEnabled", true));
            this.netherGenMap.put("peridot", builder.translation("gemsnjewels.configgui.peridotOreGeneration").worldRestart().define("peridot_NetherOreGenEnabled", true));
            this.netherGenMap.put("aquamarine", builder.translation("gemsnjewels.configgui.aquamarineOreGeneration").worldRestart().define("aquamarine_NetherOreGenEnabled", true));
            this.netherGenMap.put("zircon", builder.translation("gemsnjewels.configgui.zirconOreGeneration").worldRestart().define("zircon_NetherOreGenEnabled", true));
            this.netherGenMap.put("alexandrite", builder.translation("gemsnjewels.configgui.alexandriteOreGeneration").worldRestart().define("alexandrite_NetherOreGenEnabled", true));
            this.netherGenMap.put("tanzanite", builder.translation("gemsnjewels.configgui.tanzaniteOreGeneration").worldRestart().define("tanzanite_NetherOreGenEnabled", true));
            this.netherGenMap.put("tourmaline", builder.translation("gemsnjewels.configgui.tourmalineOreGeneration").worldRestart().define("tourmaline_NetherOreGenEnabled", true));
            this.netherGenMap.put("spinel", builder.translation("gemsnjewels.configgui.spinelOreGeneration").worldRestart().define("spinel_NetherOreGenEnabled", true));
            this.netherGenMap.put("black_opal", builder.translation("gemsnjewels.configgui.blackOpalOreGeneration").worldRestart().define("blackOpal_NetherOreGenEnabled", true));
            this.netherGenMap.put("citrine", builder.translation("gemsnjewels.configgui.citrineOreGeneration").worldRestart().define("citrine_NetherOreGenEnabled", true));
            this.netherGenMap.put("morganite", builder.translation("gemsnjewels.configgui.morganiteOreGeneration").worldRestart().define("morganite_NetherOreGenEnabled", true));
            this.netherGenMap.put("ametrine", builder.translation("gemsnjewels.configgui.ametrineOreGeneration").worldRestart().define("ametrine_NetherOreGenEnabled", true));
            this.netherGenMap.put("iolite", builder.translation("gemsnjewels.configgui.ioliteOreGeneration").worldRestart().define("iolite_NetherOreGenEnabled", true));
            this.netherGenMap.put("kunzite", builder.translation("gemsnjewels.configgui.kunziteOreGeneration").worldRestart().define("kunzite_NetherOreGenEnabled", true));
            builder.pop();
        }
    }
}

