/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.client;

import cech12.solarcooker.api.block.SolarCookerBlocks;
import cech12.solarcooker.block.AbstractSolarCookerBlock;
import cech12.solarcooker.tileentity.SolarCookerTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class SolarCookerTileEntityRenderer
extends TileEntityRenderer<SolarCookerTileEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("solarcooker", "textures/entity/solar_cooker.png");
    private final ModelRenderer singleLid;
    private final ModelRenderer singleBottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer singleInner;
    private final ModelRenderer singleLatch;

    public SolarCookerTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.singleBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.singleLid = new ModelRenderer(64, 64, 0, 0);
        this.singleLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.singleLid.field_78797_d = 9.0f;
        this.singleLid.field_78798_e = 1.0f;
        this.singleInner = new ModelRenderer(64, 64, 0, 43);
        this.singleInner.func_228301_a_(3.0f, 2.0f, 3.0f, 10.0f, 8.0f, 10.0f, 0.0f);
        this.singleLatch = new ModelRenderer(64, 64, 0, 0);
        this.singleLatch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.singleLatch.field_78797_d = 8.0f;
    }

    public void render(SolarCookerTileEntity tileEntityIn, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        boolean isInWorld = world != null;
        BlockState blockstate = isInWorld ? tileEntityIn.func_195044_w() : (BlockState)SolarCookerBlocks.SOLAR_COOKER.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractSolarCookerBlock) {
            ItemStack stack;
            matrixStackIn.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((Property)AbstractSolarCookerBlock.FACING)).func_185119_l();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE));
            float lidAngle = tileEntityIn.getLidAngle(partialTicks);
            this.renderModels(matrixStackIn, ivertexbuilder, this.singleLid, this.singleLatch, this.singleBottom, this.singleInner, lidAngle, combinedLightIn, combinedOverlayIn);
            if (isInWorld && !(stack = tileEntityIn.func_70301_a(0)).func_190926_b()) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.5, 0.4, 0.5);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
                matrixStackIn.func_227865_b_();
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderModels(MatrixStack matrixStackIn, IVertexBuilder bufferIn, ModelRenderer chestLid, ModelRenderer chestLatch, ModelRenderer chestBottom, ModelRenderer chestInner, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.field_78795_f = chestLid.field_78795_f = -(lidAngle * 1.5707964f);
        chestLid.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestInner.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }
}

