/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.block;

import cech12.solarcooker.api.block.SolarCookerBlocks;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ToolType;

public class ReflectorBlock
extends Block {
    public static final IntegerProperty TYPE = IntegerProperty.func_177719_a((String)"type", (int)1, (int)15);
    protected static final List<Integer> TYPES_WITH_ONE_REFLECTOR = Arrays.asList(1, 2, 4, 8);
    protected static final List<Integer> TYPES_WITH_TWO_REFLECTORS = Arrays.asList(3, 5, 6, 9, 10, 12);
    protected static final List<Integer> TYPES_WITH_THREE_REFLECTORS = Arrays.asList(7, 11, 13, 14);
    protected static final List<Integer> TYPES_WITH_FOUR_REFLECTORS = Collections.singletonList(15);
    protected static final VoxelShape SHAPE_NORTH_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_NORTH_EAST = Block.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_SOUTH_EAST = Block.func_208617_a((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0);
    protected static final VoxelShape[] SHAPES = ReflectorBlock.makeShapes();

    private static VoxelShape[] makeShapes() {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(type -> {
            HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
            if ((type | 8) == type) {
                shapes.add(SHAPE_NORTH_WEST);
                shapes.add(SHAPE_NORTH);
                shapes.add(SHAPE_NORTH_EAST);
            }
            if ((type | 4) == type) {
                shapes.add(SHAPE_NORTH_EAST);
                shapes.add(SHAPE_EAST);
                shapes.add(SHAPE_SOUTH_EAST);
            }
            if ((type | 2) == type) {
                shapes.add(SHAPE_SOUTH_EAST);
                shapes.add(SHAPE_SOUTH);
                shapes.add(SHAPE_SOUTH_WEST);
            }
            if ((type | 1) == type) {
                shapes.add(SHAPE_SOUTH_WEST);
                shapes.add(SHAPE_WEST);
                shapes.add(SHAPE_NORTH_WEST);
            }
            VoxelShape voxelshape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            for (VoxelShape shape : shapes) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)shape);
            }
            return voxelshape;
        }).toArray(VoxelShape[]::new);
    }

    public static int getType(Direction direction) {
        switch (direction) {
            case NORTH: {
                return 8;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 1;
            }
        }
        return 8;
    }

    public static boolean isFacingTo(BlockState blockstate, Direction direction) {
        if (direction != Direction.UP && direction != Direction.DOWN) {
            int type = (Integer)blockstate.func_177229_b((Property)TYPE);
            return (type | ReflectorBlock.getType(direction)) == type;
        }
        return false;
    }

    private static int getCount(int type) {
        if (TYPES_WITH_ONE_REFLECTOR.contains(type)) {
            return 1;
        }
        if (TYPES_WITH_TWO_REFLECTORS.contains(type)) {
            return 2;
        }
        if (TYPES_WITH_THREE_REFLECTORS.contains(type)) {
            return 3;
        }
        if (TYPES_WITH_FOUR_REFLECTORS.contains(type)) {
            return 4;
        }
        return 1;
    }

    public ReflectorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(ReflectorBlock.getType(Direction.NORTH))));
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder context) {
        ItemStack stack;
        List drops = super.func_220076_a(state, context);
        int count = ReflectorBlock.getCount((Integer)state.func_177229_b((Property)TYPE));
        if (!drops.isEmpty() && count > 1 && (stack = (ItemStack)drops.get(0)).func_77973_b().equals(SolarCookerBlocks.REFLECTOR.func_199767_j())) {
            stack.func_190920_e(count);
        }
        return drops;
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.AXE;
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.solarcooker.reflector.description").func_240699_a_(TextFormatting.BLUE));
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)TYPE)];
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        Direction direction = context.func_195992_f().func_176734_d();
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)blockstate.func_206870_a((Property)TYPE, (Comparable)Integer.valueOf((Integer)blockstate.func_177229_b((Property)TYPE) | ReflectorBlock.getType(direction)));
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(ReflectorBlock.getType(direction)));
    }

    public boolean func_196253_a(@Nonnull BlockState state, BlockItemUseContext context) {
        return context.func_195996_i().func_77973_b() == this.func_199767_j() && !ReflectorBlock.isFacingTo(state, context.func_195992_f().func_176734_d()) || super.func_196253_a(state, context);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        int bits;
        if (direction == Rotation.CLOCKWISE_90) {
            bits = 1;
        } else if (direction == Rotation.CLOCKWISE_180) {
            bits = 2;
        } else if (direction == Rotation.COUNTERCLOCKWISE_90) {
            bits = 3;
        } else {
            return state;
        }
        int type = (Integer)state.func_177229_b((Property)TYPE);
        int rotated = (type >> bits | type << 4 - bits) & 0xF;
        return (BlockState)state.func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(rotated));
    }
}

