/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;

public class SerializerItemStack
implements ISerializer<ItemStack> {
    public static final ISerializer<ItemStack> SERIALIZER = new SerializerItemStack();

    private SerializerItemStack() {
    }

    @Override
    public ItemStack read(JsonElement json) {
        if (json.isJsonObject()) {
            return ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject());
        }
        if (json.isJsonPrimitive()) {
            return new ItemStack((IItemProvider)Serializers.ITEM.read(json));
        }
        throw new JsonParseException("Expected JSON object, got " + JSONUtils.func_151222_d((JsonElement)json));
    }

    @Override
    public JsonElement write(ItemStack toWrite) {
        JsonObject json = new JsonObject();
        json.addProperty("item", toWrite.func_77973_b().getRegistryName().toString());
        json.addProperty("count", (Number)toWrite.func_190916_E());
        if (toWrite.func_77942_o()) {
            json.add("nbt", Serializers.NBT.write(toWrite.func_77978_p()));
        }
        return json;
    }

    @Override
    public ItemStack read(PacketBuffer buffer) {
        return buffer.func_150791_c();
    }

    @Override
    public void write(PacketBuffer buffer, ItemStack toWrite) {
        buffer.func_150788_a(toWrite);
    }

    @Override
    public INBT writeNBT(ItemStack toWrite) {
        return toWrite.func_77955_b(new CompoundNBT());
    }

    @Override
    public ItemStack read(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt));
        }
        throw new IllegalArgumentException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

