/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.event.opts.BlockOptions;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class VerticalRedstoneDiodeBlock
extends BaseBlock {
    public static final DirectionProperty VERTICAL_FACING = DirectionProperty.func_177712_a((String)"vertical_facing", d -> d.func_176740_k() == Direction.Axis.Y);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    protected VerticalRedstoneDiodeBlock(String name, AbstractBlock.Properties builder) {
        super(name, builder, new BlockOptions().hasItem(false));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)) {
            case EAST: {
                return EAST_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return VerticalRedstoneDiodeBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177972_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!this.isLocked((IWorldReader)worldIn, pos, state)) {
            boolean flag = (Boolean)state.func_177229_b((Property)POWERED);
            boolean flag1 = this.shouldBePowered((World)worldIn, pos, state);
            if (flag && !flag1) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!flag) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                if (!flag1) {
                    worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.getDelay(state), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return blockState.func_177229_b((Property)VERTICAL_FACING) == side ? this.getActiveSignal(blockAccess, pos, blockState) : 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)worldIn, pos)) {
            this.updateState(worldIn, pos, state);
        } else {
            TileEntity tileentity = state.hasTileEntity() ? worldIn.func_175625_s(pos) : null;
            VerticalRedstoneDiodeBlock.func_220059_a((BlockState)state, (IWorld)worldIn, (BlockPos)pos, (TileEntity)tileentity);
            worldIn.func_217377_a(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    protected void updateState(World worldIn, BlockPos pos, BlockState state) {
        boolean flag1;
        boolean flag;
        if (!this.isLocked((IWorldReader)worldIn, pos, state) && (flag = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) != (flag1 = this.shouldBePowered(worldIn, pos, state)) && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.isFacingTowardsRepeater((IBlockReader)worldIn, pos, state)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.getDelay(state), tickpriority);
        }
    }

    public boolean isLocked(IWorldReader worldIn, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean shouldBePowered(World worldIn, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(worldIn, pos, state) > 0;
    }

    protected int calculateInputStrength(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)VERTICAL_FACING);
        BlockPos blockpos = pos.func_177972_a(direction);
        int i = worldIn.func_175651_c(blockpos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return Math.max(i, blockstate.func_203425_a(Blocks.field_150488_af) ? (Integer)blockstate.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0);
    }

    protected int getPowerOnSides(IWorldReader worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        Direction direction1 = direction.func_176746_e();
        Direction direction2 = direction.func_176735_f();
        return Math.max(this.getPowerOnSide(worldIn, pos.func_177972_a(direction1), direction1), this.getPowerOnSide(worldIn, pos.func_177972_a(direction2), direction2));
    }

    protected int getPowerOnSide(IWorldReader worldIn, BlockPos pos, Direction side) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (this.isAlternateInput(blockstate)) {
            if (blockstate.func_203425_a(Blocks.field_150451_bX)) {
                return 15;
            }
            return blockstate.func_203425_a(Blocks.field_150488_af) ? ((Integer)blockstate.func_177229_b((Property)RedstoneWireBlock.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side);
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        boolean flag;
        boolean bl = flag = c.func_221532_j().field_72448_b - (double)c.func_195995_a().func_177956_o() - 0.5 < 0.0;
        if (c.func_196000_l().func_176740_k() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)c.func_195992_f())).func_206870_a((Property)VERTICAL_FACING, (Comparable)c.func_196000_l());
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)c.func_196000_l().func_176734_d())).func_206870_a((Property)VERTICAL_FACING, (Comparable)(flag ? Direction.UP : Direction.DOWN));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.notifyNeighbors(worldIn, pos, state);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            this.notifyNeighbors(worldIn, pos, state);
        }
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)VERTICAL_FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (BlockState)worldIn.func_180495_p(pos), EnumSet.of(direction.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)this, pos);
        worldIn.func_175695_a(blockpos, (Block)this, direction);
    }

    protected boolean isAlternateInput(BlockState state) {
        return state.func_185897_m();
    }

    protected int getActiveSignal(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return 15;
    }

    public static boolean isDiode(BlockState state) {
        return state.func_177230_c() instanceof RedstoneDiodeBlock;
    }

    public boolean isFacingTowardsRepeater(IBlockReader worldIn, BlockPos pos, BlockState state) {
        Direction direction = ((Direction)state.func_177229_b((Property)VERTICAL_FACING)).func_176734_d();
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        return VerticalRedstoneDiodeBlock.isDiode(blockstate) && blockstate.func_177229_b((Property)VERTICAL_FACING) != direction;
    }

    protected abstract int getDelay(BlockState var1);
}

