/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.state.HedgeState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;

public class Hedge
extends BaseDerivativeBlock
implements IWaterLoggable,
IForgeShearable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<HedgeState> STATE = EnumProperty.func_177709_a((String)"state", HedgeState.class);
    private static VoxelShape SHAPE_NONE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_STRAIGHT_Z = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_STRAIGHT_X = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SHORT_N = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
    private static VoxelShape SHAPE_SHORT_E = Block.func_208617_a((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_SHORT_S = Block.func_208617_a((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SHORT_W = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_CORNER_NE = VoxelShapes.func_216384_a((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_N, SHAPE_SHORT_E});
    private static VoxelShape SHAPE_CORNER_NW = VoxelShapes.func_216384_a((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_N, SHAPE_SHORT_W});
    private static VoxelShape SHAPE_CORNER_SE = VoxelShapes.func_216384_a((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_S, SHAPE_SHORT_E});
    private static VoxelShape SHAPE_CORNER_SW = VoxelShapes.func_216384_a((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_S, SHAPE_SHORT_W});
    private static VoxelShape SHAPE_T_N = VoxelShapes.func_197872_a((VoxelShape)SHAPE_STRAIGHT_Z, (VoxelShape)SHAPE_SHORT_N);
    private static VoxelShape SHAPE_T_E = VoxelShapes.func_197872_a((VoxelShape)SHAPE_STRAIGHT_X, (VoxelShape)SHAPE_SHORT_E);
    private static VoxelShape SHAPE_T_S = VoxelShapes.func_197872_a((VoxelShape)SHAPE_STRAIGHT_Z, (VoxelShape)SHAPE_SHORT_S);
    private static VoxelShape SHAPE_T_W = VoxelShapes.func_197872_a((VoxelShape)SHAPE_STRAIGHT_X, (VoxelShape)SHAPE_SHORT_W);
    private static VoxelShape SHAPE_CROSS = VoxelShapes.func_197872_a((VoxelShape)SHAPE_STRAIGHT_X, (VoxelShape)SHAPE_STRAIGHT_Z);
    private static VoxelShape COL_NONE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_STRAIGHT_Z = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_STRAIGHT_X = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)24.0, (double)16.0);
    private static VoxelShape COL_SHORT_N = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)24.0, (double)4.0);
    private static VoxelShape COL_SHORT_E = Block.func_208617_a((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_SHORT_S = Block.func_208617_a((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)24.0, (double)16.0);
    private static VoxelShape COL_SHORT_W = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_CORNER_NE = VoxelShapes.func_216384_a((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_N, COL_SHORT_E});
    private static VoxelShape COL_CORNER_NW = VoxelShapes.func_216384_a((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_N, COL_SHORT_W});
    private static VoxelShape COL_CORNER_SE = VoxelShapes.func_216384_a((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_S, COL_SHORT_E});
    private static VoxelShape COL_CORNER_SW = VoxelShapes.func_216384_a((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_S, COL_SHORT_W});
    private static VoxelShape COL_T_N = VoxelShapes.func_197872_a((VoxelShape)COL_STRAIGHT_Z, (VoxelShape)COL_SHORT_N);
    private static VoxelShape COL_T_E = VoxelShapes.func_197872_a((VoxelShape)COL_STRAIGHT_X, (VoxelShape)COL_SHORT_E);
    private static VoxelShape COL_T_S = VoxelShapes.func_197872_a((VoxelShape)COL_STRAIGHT_Z, (VoxelShape)COL_SHORT_S);
    private static VoxelShape COL_T_W = VoxelShapes.func_197872_a((VoxelShape)COL_STRAIGHT_X, (VoxelShape)COL_SHORT_W);
    private static VoxelShape COL_CROSS = VoxelShapes.func_197872_a((VoxelShape)COL_STRAIGHT_X, (VoxelShape)COL_STRAIGHT_Z);

    public Hedge(String name, Block source) {
        super("hedge_" + name, source);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(STATE, (Comparable)((Object)HedgeState.None)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE, WATERLOGGED});
    }

    public boolean isShearable(ItemStack item, World world, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state) {
        switch ((HedgeState)((Object)state.func_177229_b(STATE))) {
            case None: {
                return SHAPE_NONE;
            }
            case Straight_X: {
                return SHAPE_STRAIGHT_X;
            }
            case Straight_Z: {
                return SHAPE_STRAIGHT_Z;
            }
            case Corner_NE: {
                return SHAPE_CORNER_NE;
            }
            case Corner_NW: {
                return SHAPE_CORNER_NW;
            }
            case Corner_SE: {
                return SHAPE_CORNER_SE;
            }
            case Corner_SW: {
                return SHAPE_CORNER_SW;
            }
            case TCross_N: {
                return SHAPE_T_N;
            }
            case TCross_E: {
                return SHAPE_T_E;
            }
            case TCross_S: {
                return SHAPE_T_S;
            }
            case TCross_W: {
                return SHAPE_T_W;
            }
            case Cross: {
                return SHAPE_CROSS;
            }
        }
        return SHAPE_NONE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((HedgeState)((Object)state.func_177229_b(STATE))) {
            case None: {
                return COL_NONE;
            }
            case Straight_X: {
                return COL_STRAIGHT_X;
            }
            case Straight_Z: {
                return COL_STRAIGHT_Z;
            }
            case Corner_NE: {
                return COL_CORNER_NE;
            }
            case Corner_NW: {
                return COL_CORNER_NW;
            }
            case Corner_SE: {
                return COL_CORNER_SE;
            }
            case Corner_SW: {
                return COL_CORNER_SW;
            }
            case TCross_N: {
                return COL_T_N;
            }
            case TCross_E: {
                return COL_T_E;
            }
            case TCross_S: {
                return COL_T_S;
            }
            case TCross_W: {
                return COL_T_W;
            }
            case Cross: {
                return COL_CROSS;
            }
        }
        return COL_NONE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public BlockState getState(BlockState state, IWorld worldIn, BlockPos pos) {
        BlockState bn = worldIn.func_180495_p(pos.func_177978_c());
        BlockState be = worldIn.func_180495_p(pos.func_177974_f());
        BlockState bs = worldIn.func_180495_p(pos.func_177968_d());
        BlockState bw = worldIn.func_180495_p(pos.func_177976_e());
        boolean n = bn.func_177230_c() instanceof Hedge;
        boolean e = be.func_177230_c() instanceof Hedge;
        boolean s = bs.func_177230_c() instanceof Hedge;
        boolean w = bw.func_177230_c() instanceof Hedge;
        if (n && e && s && w) {
            return this.getNextState(state, HedgeState.Cross);
        }
        if (!(n || e || s || w)) {
            return this.getNextState(state, HedgeState.None);
        }
        if (n && e && !s && w) {
            return this.getNextState(state, HedgeState.TCross_N);
        }
        if (n && e && s && !w) {
            return this.getNextState(state, HedgeState.TCross_E);
        }
        if (!n && e && s && w) {
            return this.getNextState(state, HedgeState.TCross_S);
        }
        if (n && !e && s && w) {
            return this.getNextState(state, HedgeState.TCross_W);
        }
        if (!e && !w && (n || s)) {
            return this.getNextState(state, HedgeState.Straight_X);
        }
        if (!n && !s && (e || w)) {
            return this.getNextState(state, HedgeState.Straight_Z);
        }
        if (n && e && !s && !w) {
            return this.getNextState(state, HedgeState.Corner_NE);
        }
        if (n && !e && !s && w) {
            return this.getNextState(state, HedgeState.Corner_NW);
        }
        if (!n && e && s && !w) {
            return this.getNextState(state, HedgeState.Corner_SE);
        }
        if (!n && !e && s && w) {
            return this.getNextState(state, HedgeState.Corner_SW);
        }
        return this.func_176223_P();
    }

    private BlockState getNextState(BlockState state, HedgeState shape) {
        return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)shape));
    }

    public BlockState getState(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.getState(state, (IWorld)worldIn, pos);
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        return (BlockState)this.getState(this.func_176223_P(), (IWorld)c.func_195991_k(), c.func_195995_a()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.func_195991_k().func_204610_c(c.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return this.getState(stateIn, worldIn, currentPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

