/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2DoubleArrayMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Upgrade;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.OwnerDisplay;
import mekanism.common.util.text.UpgradeDisplay;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TripWireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class MekanismUtils {
    public static final Codec<Direction> DIRECTION_CODEC = IStringSerializable.func_233023_a_(Direction::values, Direction::func_176739_a);
    public static final float ONE_OVER_ROOT_TWO = (float)(1.0 / Math.sqrt(2.0));
    public static final Direction[] SIDE_DIRS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final List<UUID> warnedFails = new ArrayList<UUID>();

    public static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            Mekanism.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected, (Object)new Exception());
        }
    }

    public static void logExpectedZero(FloatingLong actual) {
        if (!actual.isZero()) {
            Mekanism.logger.error("Energy value changed by a different amount ({}) than requested (zero).", (Object)actual, (Object)new Exception());
        }
    }

    public static ITextComponent logFormat(Object message) {
        return MekanismUtils.logFormat(EnumColor.GRAY, message);
    }

    public static ITextComponent logFormat(EnumColor messageColor, Object message) {
        return MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, messageColor, message);
    }

    @Nonnull
    public static String getModId(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        String modid = item.getCreatorModId(stack);
        if (modid == null) {
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                Mekanism.logger.error("Unexpected null registry name for item of class type: {}", (Object)item.getClass().getSimpleName());
                return "";
            }
            return registryName.func_110624_b();
        }
        return modid;
    }

    public static ItemStack getItemInHand(LivingEntity entity, HandSide side) {
        if (entity instanceof PlayerEntity) {
            return MekanismUtils.getItemInHand((PlayerEntity)entity, side);
        }
        if (side == HandSide.RIGHT) {
            return entity.func_184614_ca();
        }
        return entity.func_184592_cb();
    }

    public static ItemStack getItemInHand(PlayerEntity player, HandSide side) {
        if (player.func_184591_cq() == side) {
            return player.func_184614_ca();
        }
        return player.func_184592_cb();
    }

    public static Direction getLeft(Direction orientation) {
        return orientation.func_176746_e();
    }

    public static Direction getRight(Direction orientation) {
        return orientation.func_176735_f();
    }

    public static double fractionUpgrades(IUpgradeTile tile, Upgrade type) {
        if (tile.supportsUpgrade(type)) {
            return (double)tile.getComponent().getUpgrades(type) / (double)type.getMax();
        }
        return 0.0;
    }

    public static float getScale(float prevScale, IExtendedFluidTank tank) {
        return MekanismUtils.getScale(prevScale, tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, IChemicalTank<?, ?> tank) {
        return MekanismUtils.getScale(prevScale, tank.getStored(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, int stored, int capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0 ? 0.0f : (float)stored / (float)capacity, empty, stored == capacity);
    }

    public static float getScale(float prevScale, long stored, long capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0L ? 0.0f : (float)((double)stored / (double)capacity), empty, stored == capacity);
    }

    public static float getScale(float prevScale, IEnergyContainer container) {
        FloatingLong stored = container.getEnergy();
        FloatingLong capacity = container.getMaxEnergy();
        float targetScale = capacity.isZero() ? 0.0f : stored.divide(capacity).floatValue();
        return MekanismUtils.getScale(prevScale, targetScale, container.isEmpty(), stored.equals(capacity));
    }

    public static float getScale(float prevScale, float targetScale, boolean empty, boolean full) {
        float difference = Math.abs(prevScale - targetScale);
        if ((double)difference > 0.01) {
            return (9.0f * prevScale + targetScale) / 10.0f;
        }
        if (!empty && full && difference > 0.0f) {
            return targetScale;
        }
        if (!empty && prevScale == 0.0f) {
            return targetScale;
        }
        if (empty && (double)prevScale < 0.01) {
            return 0.0f;
        }
        return prevScale;
    }

    public static long getBaseUsage(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades() && tile.supportsUpgrade(Upgrade.GAS)) {
            return Math.round((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS)));
        }
        return def;
    }

    public static int getTicks(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToInt((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), -MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED)));
        }
        return def;
    }

    public static FloatingLong getEnergyPerTick(IUpgradeTile tile, FloatingLong def) {
        if (tile.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static double getGasPerTickMeanMultiplier(IUpgradeTile tile) {
        if (tile.supportsUpgrades()) {
            if (tile.supportsUpgrade(Upgrade.GAS)) {
                return Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS));
            }
            return Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED));
        }
        return 1.0;
    }

    public static FloatingLong getMaxEnergy(IUpgradeTile tile, FloatingLong def) {
        if (tile.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static FloatingLong getMaxEnergy(ItemStack stack, FloatingLong def) {
        Map<Upgrade, Integer> upgrades;
        float numUpgrades = 0.0f;
        if (ItemDataUtils.hasData(stack, "componentUpgrade", 10) && (upgrades = Upgrade.buildMap(ItemDataUtils.getCompound(stack, "componentUpgrade"))).containsKey(Upgrade.ENERGY)) {
            numUpgrades = upgrades.get(Upgrade.ENERGY).intValue();
        }
        return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), numUpgrades / (float)Upgrade.ENERGY.getMax()));
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return Mekanism.rl(type.getPrefix() + name);
    }

    public static boolean canFunction(TileEntityMekanism tile) {
        if (!tile.supportsRedstone()) {
            return true;
        }
        switch (tile.getControlType()) {
            case DISABLED: {
                return true;
            }
            case HIGH: {
                return tile.isPowered();
            }
            case LOW: {
                return !tile.isPowered();
            }
            case PULSE: {
                return tile.isPowered() && !tile.wasPowered();
            }
        }
        return false;
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player) {
        return MekanismUtils.rayTrace(player, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return MekanismUtils.rayTrace(player, player.func_233637_b_((net.minecraft.entity.ai.attributes.Attribute)ForgeMod.REACH_DISTANCE.get()), fluidMode);
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player, double reach) {
        return MekanismUtils.rayTrace(player, reach, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player, double reach, RayTraceContext.FluidMode fluidMode) {
        Vector3d headVec = MekanismUtils.getHeadVec(player);
        Vector3d lookVec = player.func_70676_i(1.0f);
        Vector3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.func_130014_f_().func_217299_a(new RayTraceContext(headVec, endVec, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    private static Vector3d getHeadVec(PlayerEntity player) {
        double posY = player.func_226278_cu_() + (double)player.func_70047_e();
        if (player.func_213453_ef()) {
            posY -= 0.08;
        }
        return new Vector3d(player.func_226277_ct_(), posY, player.func_226281_cx_());
    }

    public static void addFrequencyToTileTooltip(ItemStack stack, FrequencyType<?> frequencyType, List<ITextComponent> tooltip) {
        CompoundNBT frequencyComponent;
        if (ItemDataUtils.hasData(stack, "componentFrequency", 10) && (frequencyComponent = ItemDataUtils.getCompound(stack, "componentFrequency")).func_150297_b(frequencyType.getName(), 10)) {
            String owner;
            Object frequency = frequencyType.create(frequencyComponent.func_74775_l(frequencyType.getName()));
            ((Frequency)frequency).setValid(false);
            tooltip.add((ITextComponent)MekanismLang.FREQUENCY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, ((Frequency)frequency).getName()));
            if (((Frequency)frequency).getOwner() != null && (owner = OwnerDisplay.getOwnerName(MekanismClient.tryGetClientPlayer(), ((Frequency)frequency).getOwner(), ((Frequency)frequency).getClientOwner())) != null) {
                tooltip.add((ITextComponent)MekanismLang.OWNER.translateColored(EnumColor.INDIGO, EnumColor.GRAY, owner));
            }
            tooltip.add((ITextComponent)MekanismLang.MODE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, ((Frequency)frequency).isPublic() ? MekanismLang.PUBLIC : MekanismLang.PRIVATE));
        }
    }

    public static void addFrequencyItemTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        Frequency.FrequencyIdentity frequency = ((IFrequencyItem)stack.func_77973_b()).getFrequencyIdentity(stack);
        if (frequency != null) {
            String owner;
            tooltip.add((ITextComponent)MekanismLang.FREQUENCY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, frequency.getKey()));
            CompoundNBT frequencyCompound = ItemDataUtils.getCompound(stack, "frequency");
            if (frequencyCompound.func_186855_b("owner") && (owner = OwnerDisplay.getOwnerName(MekanismClient.tryGetClientPlayer(), frequencyCompound.func_186857_a("owner"), null)) != null) {
                tooltip.add((ITextComponent)MekanismLang.OWNER.translateColored(EnumColor.INDIGO, EnumColor.GRAY, owner));
            }
            tooltip.add((ITextComponent)MekanismLang.MODE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, frequency.isPublic() ? MekanismLang.PUBLIC : MekanismLang.PRIVATE));
        }
    }

    public static void addUpgradesToTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        if (ItemDataUtils.hasData(stack, "componentUpgrade", 10)) {
            Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getCompound(stack, "componentUpgrade"));
            for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                tooltip.add(UpgradeDisplay.of(entry.getKey(), entry.getValue()).getTextComponent());
            }
        }
    }

    public static ITextComponent getEnergyDisplayShort(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case J: {
                return UnitDisplayUtils.getDisplayShort(energy, UnitDisplayUtils.ElectricUnit.JOULES);
            }
            case FE: {
                return UnitDisplayUtils.getDisplayShort(EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(energy), UnitDisplayUtils.ElectricUnit.FORGE_ENERGY);
            }
            case EU: {
                return UnitDisplayUtils.getDisplayShort(EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(energy), UnitDisplayUtils.ElectricUnit.ELECTRICAL_UNITS);
            }
        }
        return MekanismLang.ERROR.translate(new Object[0]);
    }

    public static FloatingLong convertToJoules(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case FE: {
                return EnergyCompatUtils.EnergyType.FORGE.convertFrom(energy);
            }
            case EU: {
                return EnergyCompatUtils.EnergyType.EU.convertFrom(energy);
            }
        }
        return energy;
    }

    public static FloatingLong convertToDisplay(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case FE: {
                return EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(energy);
            }
            case EU: {
                return EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(energy);
            }
        }
        return energy;
    }

    public static ITextComponent getTemperatureDisplay(double temp, UnitDisplayUtils.TemperatureUnit unit, boolean shift) {
        double tempKelvin = unit.convertToK(temp, true);
        switch ((UnitDisplayUtils.TempType)MekanismConfig.general.tempUnit.get()) {
            case K: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.KELVIN, shift);
            }
            case C: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.CELSIUS, shift);
            }
            case R: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.RANKINE, shift);
            }
            case F: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT, shift);
            }
            case STP: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.AMBIENT, shift);
            }
        }
        return MekanismLang.ERROR.translate(new Object[0]);
    }

    public static CraftingInventory getDummyCraftingInv() {
        Container tempContainer = new Container(ContainerType.field_221518_l, 1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        };
        return new CraftingInventory(tempContainer, 3, 3);
    }

    public static boolean canUseAsWrench(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemConfigurator) {
            return ((ItemConfigurator)item).getMode(stack) == ItemConfigurator.ConfiguratorMode.WRENCH;
        }
        return item.func_206844_a(MekanismTags.Items.CONFIGURATORS);
    }

    @Nonnull
    public static String getLastKnownUsername(@Nullable UUID uuid) {
        GameProfile gp;
        if (uuid == null) {
            return "<???>";
        }
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && EffectiveSide.get().isServer() && (gp = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(uuid)) != null) {
            ret = gp.getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", (Object)uuid);
            warnedFails.add(uuid);
        }
        return ret != null ? ret : "<" + uuid + ">";
    }

    public static void speedUpEffectSafely(LivingEntity entity, EffectInstance effectInstance) {
        int remainingDuration;
        if (effectInstance.func_76459_b() > 0 && (remainingDuration = effectInstance.func_76454_e()) == 0 && effectInstance.field_230115_j_ != null) {
            effectInstance.func_230117_a_(effectInstance.field_230115_j_);
            effectInstance.field_230115_j_ = effectInstance.field_230115_j_.field_230115_j_;
            MekanismUtils.onChangedPotionEffect(entity, effectInstance, true);
        }
    }

    private static void onChangedPotionEffect(LivingEntity entity, EffectInstance effectInstance, boolean reapply) {
        entity.field_70752_e = true;
        if (reapply && !entity.field_70170_p.field_72995_K) {
            Effect effect = effectInstance.func_188419_a();
            effect.func_111187_a(entity, entity.func_233645_dx_(), effectInstance.func_76458_c());
            effect.func_111185_a(entity, entity.func_233645_dx_(), effectInstance.func_76458_c());
        }
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectInstance));
            CriteriaTriggers.field_193139_z.func_193153_a((ServerPlayerEntity)entity);
        }
    }

    public static boolean isSameTypeFactory(Block block, TileEntityType<?> factoryTileType) {
        AttributeFactoryType attribute = Attribute.get(block, AttributeFactoryType.class);
        if (attribute == null) {
            return false;
        }
        FactoryType factoryType = attribute.getFactoryType();
        for (FactoryTier factoryTier : EnumUtils.FACTORY_TIERS) {
            if (MekanismTileEntityTypes.getFactoryTile(factoryTier, factoryType).get() != factoryTileType) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static ActionResultType performActions(ActionResultType firstAction, Supplier<ActionResultType> ... secondaryActions) {
        if (firstAction == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        ActionResultType result = firstAction;
        boolean hasFailed = result == ActionResultType.FAIL;
        for (Supplier<ActionResultType> secondaryAction : secondaryActions) {
            result = secondaryAction.get();
            if (result == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            hasFailed &= result == ActionResultType.FAIL;
        }
        if (hasFailed) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static int redstoneLevelFromContents(long amount, long capacity) {
        double fractionFull = capacity == 0L ? 0.0 : (double)amount / (double)capacity;
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int redstoneLevelFromContents(FloatingLong amount, FloatingLong capacity) {
        if (capacity.isZero() || amount.isZero()) {
            return 0;
        }
        return 1 + amount.divide(capacity).multiply(14L).intValue();
    }

    public static int redstoneLevelFromContents(List<IInventorySlot> slots) {
        long totalCount = 0L;
        long totalLimit = 0L;
        for (IInventorySlot slot : slots) {
            if (slot.isEmpty()) {
                totalLimit += (long)slot.getLimit(ItemStack.field_190927_a);
                continue;
            }
            totalCount += (long)slot.getCount();
            totalLimit += (long)slot.getLimit(slot.getStack());
        }
        return MekanismUtils.redstoneLevelFromContents(totalCount, totalLimit);
    }

    public static boolean isPlayingMode(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static Map<Fluid, FluidInDetails> getFluidsIn(PlayerEntity player, UnaryOperator<AxisAlignedBB> modifyBoundingBox) {
        int zMax;
        AxisAlignedBB bb = (AxisAlignedBB)modifyBoundingBox.apply(player.func_174813_aQ().func_186664_h(0.001));
        int xMin = MathHelper.func_76128_c((double)bb.field_72340_a);
        int xMax = MathHelper.func_76143_f((double)bb.field_72336_d);
        int yMin = MathHelper.func_76128_c((double)bb.field_72338_b);
        int yMax = MathHelper.func_76143_f((double)bb.field_72337_e);
        int zMin = MathHelper.func_76128_c((double)bb.field_72339_c);
        if (!player.field_70170_p.func_217344_a(xMin, yMin, zMin, xMax, yMax, zMax = MathHelper.func_76143_f((double)bb.field_72334_f))) {
            return Collections.emptyMap();
        }
        HashMap<Fluid, FluidInDetails> fluidsIn = new HashMap<Fluid, FluidInDetails>();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    double fluidY;
                    mutablePos.func_181079_c(x, y, z);
                    FluidState fluidState = player.field_70170_p.func_204610_c((BlockPos)mutablePos);
                    if (fluidState.func_206888_e() || !(bb.field_72338_b <= (fluidY = (double)((float)y + fluidState.func_215679_a((IBlockReader)player.field_70170_p, (BlockPos)mutablePos))))) continue;
                    Fluid fluid = fluidState.func_206886_c();
                    if (fluid instanceof FlowingFluid) {
                        fluid = ((FlowingFluid)fluid).func_210198_f();
                    }
                    FluidInDetails details = fluidsIn.computeIfAbsent(fluid, f -> new FluidInDetails());
                    details.positions.add(mutablePos.func_185334_h());
                    double actualFluidHeight = fluidY > bb.field_72337_e ? bb.field_72337_e - Math.max(bb.field_72338_b, (double)y) : fluidY - Math.max(bb.field_72338_b, (double)y);
                    details.heights.merge(ChunkPos.func_77272_a((int)x, (int)z), actualFluidHeight, Double::sum);
                }
            }
        }
        return fluidsIn;
    }

    public static void veinMineArea(IEnergyContainer energyContainer, World world, BlockPos pos, ServerPlayerEntity player, ItemStack stack, Item usedTool, Collection<BlockPos> found, boolean shears, Function<Float, FloatingLong> destroyEnergyFunction, DoubleUnaryOperator distanceMultiplier, BlockState sourceState) {
        FloatingLong energyUsed = FloatingLong.ZERO;
        FloatingLong energyAvailable = energyContainer.getEnergy();
        energyAvailable = energyAvailable.subtract(destroyEnergyFunction.apply(Float.valueOf(sourceState.func_185887_b((IBlockReader)world, pos))));
        for (BlockPos foundPos : found) {
            int exp;
            BlockState targetState;
            FloatingLong destroyEnergy;
            if (pos.equals((Object)foundPos) || energyUsed.add(destroyEnergy = destroyEnergyFunction.apply(Float.valueOf((targetState = world.func_180495_p(foundPos)).func_185887_b((IBlockReader)world, foundPos))).multiply(distanceMultiplier.applyAsDouble(WorldUtils.distanceBetween(pos, foundPos)))).greaterThan(energyAvailable) || (exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)foundPos)) == -1) continue;
            if (shears && targetState.func_203425_a(Blocks.field_150473_bD) && !((Boolean)targetState.func_177229_b((Property)TripWireBlock.field_176295_N)).booleanValue()) {
                targetState = (BlockState)targetState.func_206870_a((Property)TripWireBlock.field_176295_N, (Comparable)Boolean.valueOf(true));
                world.func_180501_a(foundPos, targetState, 4);
            }
            Block block = targetState.func_177230_c();
            TileEntity tileEntity = WorldUtils.getTileEntity((IBlockReader)world, foundPos);
            if (!targetState.removedByPlayer(world, foundPos, (PlayerEntity)player, true, targetState.func_204520_s())) continue;
            block.func_176206_d((IWorld)world, foundPos, targetState);
            block.func_180657_a(world, (PlayerEntity)player, foundPos, targetState, tileEntity, stack);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)usedTool));
            if (exp > 0) {
                block.func_180637_b((ServerWorld)world, foundPos, exp);
            }
            energyUsed = energyUsed.plusEqual(destroyEnergy);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
    }

    public static class FluidInDetails {
        private final List<BlockPos> positions = new ArrayList<BlockPos>();
        private final Long2DoubleMap heights = new Long2DoubleArrayMap();

        public List<BlockPos> getPositions() {
            return this.positions;
        }

        public double getMaxHeight() {
            return this.heights.values().stream().mapToDouble(value -> value).max().orElse(0.0);
        }
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_BUTTON("gui/button"),
        GUI_BAR("gui/bar"),
        GUI_HUD("gui/hud"),
        GUI_GAUGE("gui/gauge"),
        GUI_PROGRESS("gui/progress"),
        GUI_SLOT("gui/slot"),
        GUI_TAB("gui/tabs"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/block"),
        TEXTURE_ITEMS("textures/item"),
        MODEL("models"),
        INFUSE("infuse"),
        PIGMENT("pigment"),
        SLURRY("slurry");

        private final String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

