/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityQIOImporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private int delay = 0;
    private boolean importWithoutFilter = true;

    public TileEntityQIOImporter() {
        super(MekanismBlocks.QIO_IMPORTER);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction(this)) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.tryImport();
            this.delay = 10;
        }
    }

    private void tryImport() {
        QIOFrequency freq = this.getQIOFrequency();
        Direction direction = this.getDirection();
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(direction.func_176734_d()));
        if (freq == null || !InventoryUtils.isItemHandler(back, direction)) {
            return;
        }
        if (!this.importWithoutFilter && this.getFilters().isEmpty()) {
            return;
        }
        Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)back, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve();
        if (!capability.isPresent()) {
            return;
        }
        IItemHandler inventory = (IItemHandler)capability.get();
        HashSet<HashedItem> typesAdded = new HashSet<HashedItem>();
        int maxTypes = this.getMaxTransitTypes();
        int maxCount = this.getMaxTransitCount();
        int countAdded = 0;
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack ret;
            HashedItem type;
            ItemStack stack = inventory.extractItem(i, maxCount - countAdded, true);
            if (stack.func_190926_b() || !typesAdded.contains(type = HashedItem.create(stack)) && typesAdded.size() == maxTypes || !this.canFilter(stack)) continue;
            ItemStack used = TransporterManager.getToUse(stack, freq.addItem(stack));
            if (!InventoryUtils.areItemsStackable(used, ret = inventory.extractItem(i, used.func_190916_E(), false)) || used.func_190916_E() != ret.func_190916_E()) {
                Mekanism.logger.error("QIO insertion error: item handler {} returned {} during simulated extraction, but returned {} during execution. This is wrong!", (Object)back, (Object)stack, (Object)ret);
            }
            typesAdded.add(type);
            countAdded += used.func_190916_E();
        }
    }

    private boolean canFilter(ItemStack stack) {
        if (this.importWithoutFilter && this.getFilters().isEmpty()) {
            return true;
        }
        for (QIOFilter<?> filter : this.getFilters()) {
            if (!filter.getFinder().modifies(stack)) continue;
            return true;
        }
        return false;
    }

    @ComputerMethod
    public boolean getImportWithoutFilter() {
        return this.importWithoutFilter;
    }

    public void toggleImportWithoutFilter() {
        this.importWithoutFilter = !this.importWithoutFilter;
        this.markDirty(false);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getImportWithoutFilter, value -> {
            this.importWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        super.writeSustainedData(itemStack);
        ItemDataUtils.setBoolean(itemStack, "auto", this.importWithoutFilter);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        super.readSustainedData(itemStack);
        this.importWithoutFilter = ItemDataUtils.getBoolean(itemStack, "auto");
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Map<String, String> remap = super.getTileDataRemap();
        remap.put("auto", "auto");
        return remap;
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74757_a("auto", this.importWithoutFilter);
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setBooleanIfPresent(data, "auto", value -> {
            this.importWithoutFilter = value;
        });
    }

    @ComputerMethod
    private void setImportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.importWithoutFilter != value) {
            this.toggleImportWithoutFilter();
        }
    }
}

