/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityQIOExporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private int delay = 0;
    private boolean exportWithoutFilter;
    private final EfficientEjector<Object2LongMap.Entry<HashedItem>> filterEjector = new EfficientEjector(Map.Entry::getKey, e -> MathUtils.clampToInt(e.getLongValue()));
    private final EfficientEjector<Map.Entry<HashedItem, QIOFrequency.QIOItemTypeData>> filterlessEjector = new EfficientEjector(Map.Entry::getKey, e -> MathUtils.clampToInt(((QIOFrequency.QIOItemTypeData)e.getValue()).getCount()));

    public TileEntityQIOExporter() {
        super(MekanismBlocks.QIO_EXPORTER);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction(this)) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.tryEject();
            this.delay = 10;
        }
    }

    private void tryEject() {
        QIOFrequency freq = this.getQIOFrequency();
        Direction direction = this.getDirection();
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(direction.func_176734_d()));
        if (freq == null || !InventoryUtils.isItemHandler(back, direction)) {
            return;
        }
        if (!this.exportWithoutFilter && this.getFilters().isEmpty()) {
            return;
        }
        if (this.exportWithoutFilter && this.getFilters().isEmpty()) {
            ((EfficientEjector)this.filterlessEjector).eject(freq, back, freq.getItemDataMap().entrySet());
        } else if (!this.getFilters().isEmpty()) {
            ((EfficientEjector)this.filterEjector).eject(freq, back, (Collection)this.getFilterEjectMap(back, freq).object2LongEntrySet());
        }
    }

    private Object2LongMap<HashedItem> getFilterEjectMap(TileEntity back, QIOFrequency freq) {
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        for (QIOFilter<?> filter : this.getFilters()) {
            if (filter instanceof QIOItemStackFilter) {
                QIOItemStackFilter itemFilter = (QIOItemStackFilter)filter;
                if (itemFilter.fuzzyMode) {
                    map.putAll(freq.getStacksByItem(itemFilter.getItemStack().func_77973_b()));
                    continue;
                }
                HashedItem type = HashedItem.create(itemFilter.getItemStack());
                map.put((Object)type, freq.getStored(type));
                continue;
            }
            if (filter instanceof QIOTagFilter) {
                String tagName = ((QIOTagFilter)filter).getTagName();
                map.putAll(freq.getStacksByTagWildcard(tagName));
                continue;
            }
            if (!(filter instanceof QIOModIDFilter)) continue;
            String modID = ((QIOModIDFilter)filter).getModID();
            map.putAll(freq.getStacksByModIDWildcard(modID));
        }
        return map;
    }

    @ComputerMethod
    public boolean getExportWithoutFilter() {
        return this.exportWithoutFilter;
    }

    public void toggleExportWithoutFilter() {
        this.exportWithoutFilter = !this.exportWithoutFilter;
        this.markDirty(false);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getExportWithoutFilter, value -> {
            this.exportWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        super.writeSustainedData(itemStack);
        ItemDataUtils.setBoolean(itemStack, "auto", this.exportWithoutFilter);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        super.readSustainedData(itemStack);
        this.exportWithoutFilter = ItemDataUtils.getBoolean(itemStack, "auto");
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Map<String, String> remap = super.getTileDataRemap();
        remap.put("auto", "auto");
        return remap;
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74757_a("auto", this.exportWithoutFilter);
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setBooleanIfPresent(data, "auto", value -> {
            this.exportWithoutFilter = value;
        });
    }

    @ComputerMethod
    private void setExportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.exportWithoutFilter != value) {
            this.toggleExportWithoutFilter();
        }
    }

    private final class EfficientEjector<T> {
        private static final int MAX_EJECT_ATTEMPTS = 100;
        private final Function<T, HashedItem> typeSupplier;
        private final ToIntFunction<T> countSupplier;

        private EfficientEjector(Function<T, HashedItem> typeSupplier, ToIntFunction<T> countSupplier) {
            this.typeSupplier = typeSupplier;
            this.countSupplier = countSupplier;
        }

        private void eject(QIOFrequency freq, TileEntity tile, Collection<T> ejectMap) {
            if (ejectMap.isEmpty()) {
                return;
            }
            double ejectChance = Math.min(1.0, 100.0 / (double)ejectMap.size());
            int maxTypes = TileEntityQIOExporter.this.getMaxTransitTypes();
            int maxCount = TileEntityQIOExporter.this.getMaxTransitCount();
            Object2IntOpenHashMap removed = new Object2IntOpenHashMap();
            int amountRemoved = 0;
            Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileEntityQIOExporter.this.getDirection()).resolve();
            if (capability.isPresent()) {
                IItemHandler inventory = (IItemHandler)capability.get();
                for (T obj : ejectMap) {
                    if (amountRemoved == maxCount || removed.size() == maxTypes) break;
                    if (TileEntityQIOExporter.this.func_145831_w().func_201674_k().nextDouble() > ejectChance) continue;
                    HashedItem type = this.typeSupplier.apply(obj);
                    ItemStack origInsert = type.createStack(Math.min(maxCount - amountRemoved, this.countSupplier.applyAsInt(obj)));
                    ItemStack toInsert = origInsert.func_77946_l();
                    for (int i = 0; !(i >= inventory.getSlots() || inventory.isItemValid(i, toInsert) && (toInsert = inventory.insertItem(i, toInsert, false)).func_190926_b()); ++i) {
                    }
                    ItemStack toUse = TransporterManager.getToUse(origInsert, toInsert);
                    if (toUse.func_190926_b()) continue;
                    amountRemoved += toUse.func_190916_E();
                    removed.put((Object)type, removed.getOrDefault((Object)type, 0) + toUse.func_190916_E());
                }
            }
            for (Object2IntMap.Entry entry : removed.object2IntEntrySet()) {
                int amount = entry.getIntValue();
                ItemStack ret = freq.removeByType((HashedItem)entry.getKey(), amount);
                if (ret.func_190916_E() == amount) continue;
                Mekanism.logger.error("QIO ejection item removal didn't line up with prediction: removed {}, expected {}", (Object)ret.func_190916_E(), (Object)amount);
            }
        }
    }
}

