/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityThermalEvaporationValve
extends TileEntityThermalEvaporationBlock {
    public TileEntityThermalEvaporationValve() {
        super(MekanismBlocks.THERMAL_EVAPORATION_VALVE);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> ((EvaporationMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(CachedAmbientTemperature ambientTemperature) {
        return side -> ((EvaporationMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return side -> ((EvaporationMultiblockData)this.getMultiblock()).getInventorySlots(side);
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.FLUID || type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    @Nonnull
    public FluidStack insertFluid(@Nonnull FluidStack stack, Direction side, @Nonnull Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute()) {
            ((EvaporationMultiblockData)this.getMultiblock()).triggerValveTransfer(this);
        }
        return ret;
    }

    @Override
    public int getRedstoneLevel() {
        return ((EvaporationMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

