/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.chemical.ChemicalChemicalToChemicalCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.PigmentInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IEitherSideRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;

public class TileEntityPigmentMixer
extends TileEntityRecipeMachine<PigmentMixingRecipe>
implements IBoundingBlock,
IEitherSideRecipeLookupHandler.EitherSideChemicalRecipeLookupHandler<Pigment, PigmentStack, PigmentMixingRecipe> {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getLeftInput", "getLeftInputCapacity", "getLeftInputNeeded", "getLeftInputFilledPercentage"})
    public IPigmentTank leftInputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getRightInput", "getRightInputCapacity", "getRightInputNeeded", "getRightInputFilledPercentage"})
    public IPigmentTank rightInputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"})
    public IPigmentTank outputTank;
    private FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull PigmentStack> outputHandler;
    private final IInputHandler<@NonNull PigmentStack> leftInputHandler;
    private final IInputHandler<@NonNull PigmentStack> rightInputHandler;
    private MachineEnergyContainer<TileEntityPigmentMixer> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getLeftInputItem"})
    private PigmentInventorySlot leftInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private PigmentInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getRightInputItem"})
    private PigmentInventorySlot rightInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityPigmentMixer() {
        super(MekanismBlocks.PIGMENT_MIXER);
        ConfigInfo pigmentConfig;
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.PIGMENT, TransmissionType.ENERGY);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT_1, new InventorySlotInfo(true, true, this.leftInputSlot));
            itemConfig.addSlotInfo(DataType.INPUT_2, new InventorySlotInfo(true, true, this.rightInputSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(true, true, this.outputSlot));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, this.leftInputSlot, this.rightInputSlot, this.outputSlot));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, this.energySlot));
            itemConfig.setDataType(DataType.INPUT_1, RelativeSide.LEFT);
            itemConfig.setDataType(DataType.INPUT_2, RelativeSide.RIGHT);
            itemConfig.setDataType(DataType.OUTPUT, RelativeSide.FRONT);
            itemConfig.setDataType(DataType.ENERGY, RelativeSide.BACK);
        }
        if ((pigmentConfig = this.configComponent.getConfig(TransmissionType.PIGMENT)) != null) {
            pigmentConfig.addSlotInfo(DataType.INPUT_1, new ChemicalSlotInfo.PigmentSlotInfo(true, false, this.leftInputTank));
            pigmentConfig.addSlotInfo(DataType.INPUT_2, new ChemicalSlotInfo.PigmentSlotInfo(true, false, this.rightInputTank));
            pigmentConfig.addSlotInfo(DataType.OUTPUT, new ChemicalSlotInfo.PigmentSlotInfo(false, true, this.outputTank));
            pigmentConfig.addSlotInfo(DataType.INPUT_OUTPUT, new ChemicalSlotInfo.PigmentSlotInfo(true, true, this.leftInputTank, this.rightInputTank, this.outputTank));
            pigmentConfig.setDataType(DataType.INPUT_1, RelativeSide.LEFT);
            pigmentConfig.setDataType(DataType.INPUT_2, RelativeSide.RIGHT);
            pigmentConfig.setDataType(DataType.OUTPUT, RelativeSide.FRONT);
            pigmentConfig.setEjecting(true);
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.PIGMENT);
        this.leftInputHandler = InputHelper.getInputHandler(this.leftInputTank);
        this.rightInputHandler = InputHelper.getInputHandler(this.rightInputTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks() {
        ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder = ChemicalTankHelper.forSidePigmentWithConfig(this::getDirection, this::getConfig);
        this.leftInputTank = ChemicalTankBuilder.PIGMENT.input(1000L, pigment -> this.containsRecipe((Chemical)pigment, (ChemicalStack)this.rightInputTank.getStack()), this::containsRecipe, this.recipeCacheLookupMonitor);
        builder.addTank(this.leftInputTank);
        this.rightInputTank = ChemicalTankBuilder.PIGMENT.input(1000L, pigment -> this.containsRecipe((Chemical)pigment, (ChemicalStack)this.leftInputTank.getStack()), this::containsRecipe, this.recipeCacheLookupMonitor);
        builder.addTank(this.rightInputTank);
        this.outputTank = ChemicalTankBuilder.PIGMENT.output(2000L, this);
        builder.addTank(this.outputTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.leftInputSlot = PigmentInventorySlot.fill(this.leftInputTank, this, 6, 56);
        builder.addSlot(this.leftInputSlot);
        this.rightInputSlot = PigmentInventorySlot.fill(this.rightInputTank, this, 154, 56);
        builder.addSlot(this.rightInputSlot);
        this.outputSlot = PigmentInventorySlot.drain(this.outputTank, this, 80, 65);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPigmentMixer)this).func_145831_w(), this, 154, 14);
        builder.addSlot(this.energySlot);
        this.leftInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.rightInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.rightInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.leftInputSlot.fillTank();
        this.rightInputSlot.fillTank();
        this.outputSlot.drainTank();
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
    }

    @Nonnull
    @ComputerMethod(nameOverride="getEnergyUsage")
    public FloatingLong getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<PigmentMixingRecipe, InputRecipeCache.EitherSideChemical<Pigment, PigmentStack, PigmentMixingRecipe>> getRecipeType() {
        return MekanismRecipeType.PIGMENT_MIXING;
    }

    @Override
    @Nullable
    public PigmentMixingRecipe getRecipe(int cacheIndex) {
        return (PigmentMixingRecipe)this.findFirstRecipe(this.leftInputHandler, this.rightInputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<PigmentMixingRecipe> createNewCachedRecipe(@Nonnull PigmentMixingRecipe recipe, int cacheIndex) {
        return new ChemicalChemicalToChemicalCachedRecipe(recipe, this.leftInputHandler, this.rightInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    @Override
    public void onPlace() {
        super.onPlace();
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
        }
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public MachineEnergyContainer<TileEntityPigmentMixer> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

