/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalDissolutionCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;

public class TileEntityChemicalDissolutionChamber
extends TileEntityProgressMachine<ChemicalDissolutionRecipe>
implements IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, ChemicalDissolutionRecipe> {
    private static final long MAX_CHEMICAL = 10000L;
    public static final int BASE_TICKS_REQUIRED = 100;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGasInput", "getGasInputCapacity", "getGasInputNeeded", "getGasInputFilledPercentage"})
    public IGasTank injectTank;
    public MergedChemicalTank outputTank;
    public double injectUsage = 1.0;
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityChemicalDissolutionChamber> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputGasItem"})
    private GasInventorySlot gasInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private MergedChemicalInventorySlot<MergedChemicalTank> outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityChemicalDissolutionChamber() {
        super(MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, 100);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY, TransmissionType.ENERGY);
        this.configComponent.setupItemIOExtraConfig(this.inputSlot, this.outputSlot, this.gasInputSlot, this.energySlot);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.injectTank, this.outputTank.getGasTank(), RelativeSide.RIGHT).setEjecting(true);
        this.configComponent.setupOutputConfig(TransmissionType.INFUSION, this.outputTank.getInfusionTank(), RelativeSide.RIGHT);
        this.configComponent.setupOutputConfig(TransmissionType.PIGMENT, this.outputTank.getPigmentTank(), RelativeSide.RIGHT);
        this.configComponent.setupOutputConfig(TransmissionType.SLURRY, this.outputTank.getSlurryTank(), RelativeSide.RIGHT);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.gasInputHandler = InputHelper.getInputHandler(this.injectTank);
        this.outputHandler = new BoxedChemicalOutputHandler(this.outputTank);
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.outputTank = MergedChemicalTank.create(ChemicalTankBuilder.GAS.output(10000L, this), ChemicalTankBuilder.INFUSION.output(10000L, this), ChemicalTankBuilder.PIGMENT.output(10000L, this), ChemicalTankBuilder.SLURRY.output(10000L, this));
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.injectTank = ChemicalTankBuilder.GAS.input(10000L, gas -> this.containsRecipeBA(this.inputSlot.getStack(), (Chemical)gas), this::containsRecipeB, this.recipeCacheLookupMonitor);
        builder.addTank(this.injectTank);
        builder.addTank(this.outputTank.getGasTank());
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks() {
        ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder = ChemicalTankHelper.forSideInfusionWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.outputTank.getInfusionTank());
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks() {
        ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder = ChemicalTankHelper.forSidePigmentWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.outputTank.getPigmentTank());
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks() {
        ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder = ChemicalTankHelper.forSideSlurryWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.outputTank.getSlurryTank());
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.gasInputSlot = GasInventorySlot.fillOrConvert(this.injectTank, () -> ((TileEntityChemicalDissolutionChamber)this).func_145831_w(), this, 8, 65);
        builder.addSlot(this.gasInputSlot);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, this.injectTank.getStack()), this::containsRecipeA, (IContentsListener)this.recipeCacheLookupMonitor, 28, 36);
        builder.addSlot(this.inputSlot);
        this.outputSlot = MergedChemicalInventorySlot.drain(this.outputTank, this, 152, 55);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalDissolutionChamber)this).func_145831_w(), this, 152, 14);
        builder.addSlot(this.energySlot);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasInputSlot.fillTankOrConvert();
        this.outputSlot.drainChemicalTanks();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDissolutionRecipe>> getRecipeType() {
        return MekanismRecipeType.DISSOLUTION;
    }

    @Override
    @Nullable
    public ChemicalDissolutionRecipe getRecipe(int cacheIndex) {
        return (ChemicalDissolutionRecipe)this.findFirstRecipe(this.itemInputHandler, this.gasInputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<ChemicalDissolutionRecipe> createNewCachedRecipe(@Nonnull ChemicalDissolutionRecipe recipe, int cacheIndex) {
        return new ChemicalDissolutionCachedRecipe(recipe, this.itemInputHandler, this.gasInputHandler, () -> StatUtils.inversePoisson(this.injectUsage), this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.GAS || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMeanMultiplier(this);
        }
    }

    public MachineEnergyContainer<TileEntityChemicalDissolutionChamber> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"})
    private IChemicalTank<?, ?> getOutputTank() {
        MergedChemicalTank.Current current = this.outputTank.getCurrent();
        return this.outputTank.getTankFromCurrent(current == MergedChemicalTank.Current.EMPTY ? MergedChemicalTank.Current.GAS : current);
    }
}

