/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.chemical.ItemStackConstantChemicalToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;

public class TileEntityItemStackGasToItemStackFactory
extends TileEntityItemToItemFactory<ItemStackGasToItemStackRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, ItemStackGasToItemStackRecipe>,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler {
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler = InputHelper.getInputHandler(this.gasTank);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItem"})
    private GasInventorySlot extraSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"})
    private IGasTank gasTank;
    private final ItemStackConstantChemicalToItemStackCachedRecipe.ChemicalUsageMultiplier gasUsageMultiplier;
    private final long[] usedSoFar;
    private double gasPerTickMeanMultiplier = 1.0;
    private long baseTotalUsage;

    public TileEntityItemStackGasToItemStackFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.setupInputConfig(TransmissionType.GAS, this.gasTank);
        this.baseTotalUsage = 200L;
        this.usedSoFar = new long[this.tier.processes];
        this.gasUsageMultiplier = this.useStatisticalMechanics() ? (usedSoFar, operatingTicks) -> StatUtils.inversePoisson(this.gasPerTickMeanMultiplier) : (usedSoFar, operatingTicks) -> {
            long baseRemaining = this.baseTotalUsage - usedSoFar;
            int remainingTicks = this.getTicksRequired() - operatingTicks;
            if (baseRemaining < (long)remainingTicks) {
                return 0L;
            }
            if (baseRemaining == (long)remainingTicks) {
                return 1L;
            }
            return Math.max(MathUtils.clampToLong((double)baseRemaining / (double)remainingTicks), 0L);
        };
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.input(210L * (long)this.tier.processes, this::containsRecipeB, this::onContentsChangedUpdateSortingAndCache);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener updateSortingListener) {
        super.addSlots(builder, updateSortingListener);
        this.extraSlot = GasInventorySlot.fillOrConvert(this.gasTank, () -> ((TileEntityItemStackGasToItemStackFactory)this).func_145831_w(), this, 7, 57);
        builder.addSlot(this.extraSlot);
    }

    public IGasTank getGasTank() {
        return this.gasTank;
    }

    @Override
    @Nullable
    protected GasInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(ItemStackGasToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt(recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackGasToItemStackRecipe> cached, @Nonnull ItemStack stack) {
        if (cached != null) {
            ItemStackGasToItemStackRecipe cachedRecipe = cached.getRecipe();
            return cachedRecipe.getItemInput().testType(stack) && (this.gasTank.isEmpty() || ((GasStackIngredient)cachedRecipe.getChemicalInput()).testType(this.gasTank.getType()));
        }
        return false;
    }

    @Override
    protected ItemStackGasToItemStackRecipe findRecipe(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        GasStack stored = (GasStack)this.gasTank.getStack();
        ItemStack output = outputSlot.getStack();
        return this.getRecipeType().getInputCache().findTypeBasedRecipe(this.field_145850_b, fallbackInput, stored, recipe -> InventoryUtils.areItemsStackable(recipe.getOutput(fallbackInput, stored), output));
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> getRecipeType() {
        switch (this.field_200663_e) {
            case INJECTING: {
                return MekanismRecipeType.INJECTING;
            }
            case PURIFYING: {
                return MekanismRecipeType.PURIFYING;
            }
        }
        return MekanismRecipeType.COMPRESSING;
    }

    private boolean useStatisticalMechanics() {
        return this.field_200663_e == FactoryType.INJECTING || this.field_200663_e == FactoryType.PURIFYING;
    }

    @Override
    @Nullable
    public ItemStackGasToItemStackRecipe getRecipe(int cacheIndex) {
        return (ItemStackGasToItemStackRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.gasInputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<ItemStackGasToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackGasToItemStackRecipe recipe, int cacheIndex) {
        return new ItemStackConstantChemicalToItemStackCachedRecipe(recipe, this.inputHandlers[cacheIndex], this.gasInputHandler, this.gasUsageMultiplier, used -> {
            this.usedSoFar[cacheIndex] = used;
        }, this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        if (nbtTags.func_150297_b("usedSoFar", 12)) {
            long[] savedUsed = nbtTags.func_197645_o("usedSoFar");
            if (this.tier.processes != savedUsed.length) {
                Arrays.fill(this.usedSoFar, 0L);
            }
            for (int i = 0; i < this.tier.processes && i < savedUsed.length; ++i) {
                this.usedSoFar[i] = savedUsed[i];
            }
        } else {
            Arrays.fill(this.usedSoFar, 0L);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_218657_a("usedSoFar", (INBT)new LongArrayNBT(Arrays.copyOf(this.usedSoFar, this.usedSoFar.length)));
        return nbtTags;
    }

    @Override
    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar[cacheIndex];
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.GAS && this.supportsUpgrade(Upgrade.GAS)) {
            if (this.useStatisticalMechanics()) {
                this.gasPerTickMeanMultiplier = MekanismUtils.getGasPerTickMeanMultiplier(this);
            } else {
                this.baseTotalUsage = MekanismUtils.getBaseUsage(this, 200);
            }
        }
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            super.parseUpgradeData(upgradeData);
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            this.gasTank.deserializeNBT(data.stored.serializeNBT());
            this.extraSlot.deserializeNBT(data.gasSlot.serializeNBT());
            System.arraycopy(data.usedSoFar, 0, this.usedSoFar, 0, data.usedSoFar.length);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Override
    @Nonnull
    public AdvancedMachineUpgradeData getUpgradeData() {
        return new AdvancedMachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.usedSoFar, this.gasTank, this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    @Override
    public void dump() {
        this.gasTank.setEmpty();
    }

    @ComputerMethod
    private void dumpChemical() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dump();
    }
}

