/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.to_client.PacketUpdateTile;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityUpdateable
extends TileEntity
implements ITileWrapper {
    @Nullable
    private Coord4D cachedCoord;
    private boolean cacheCoord;

    public TileEntityUpdateable(TileEntityType<?> type) {
        super(type);
    }

    protected void cacheCoord() {
        this.cacheCoord = true;
        this.updateCoord();
    }

    @Nonnull
    protected World getWorldNN() {
        return Objects.requireNonNull(this.func_145831_w(), "getWorldNN called before world set");
    }

    public boolean isRemote() {
        return this.getWorldNN().func_201670_d();
    }

    public void markDirtyComparator() {
    }

    protected void updateBlockState(@Nonnull BlockState newState) {
        this.field_195045_e = newState;
    }

    public void func_70296_d() {
        this.markDirty(true);
    }

    public void markDirty(boolean recheckBlockState) {
        if (this.field_145850_b != null) {
            if (recheckBlockState) {
                this.updateBlockState(this.field_145850_b.func_180495_p(this.field_174879_c));
            }
            WorldUtils.markChunkDirty(this.field_145850_b, this.field_174879_c);
            if (!this.isRemote()) {
                this.markDirtyComparator();
            }
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.func_230337_a_(state, tag);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.getReducedUpdateTag();
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        return super.func_189517_E_();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.isRemote() && net.getDirection() == PacketDirection.CLIENTBOUND) {
            this.handleUpdatePacket(pkt.func_148857_g());
        }
    }

    public void handleUpdatePacket(@Nonnull CompoundNBT tag) {
        this.handleUpdateTag(this.func_195044_w(), tag);
    }

    public void sendUpdatePacket() {
        this.sendUpdatePacket(this);
    }

    public void sendUpdatePacket(TileEntity tracking) {
        if (this.isRemote()) {
            Mekanism.logger.warn("Update packet call requested from client side", (Throwable)new IllegalStateException());
        } else if (this.func_145837_r()) {
            Mekanism.logger.warn("Update packet call requested for removed tile", (Throwable)new IllegalStateException());
        } else {
            Mekanism.packetHandler.sendToAllTracking(new PacketUpdateTile(this), tracking);
        }
    }

    @Override
    public World getTileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    public double func_145833_n() {
        return MekanismConfig.client.terRange.get();
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.updateCoord();
    }

    public void func_226984_a_(@Nonnull World world, @Nonnull BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.updateCoord();
    }

    public void func_174878_a(@Nonnull BlockPos pos) {
        super.func_174878_a(pos);
        this.updateCoord();
    }

    private void updateCoord() {
        if (this.cacheCoord && this.field_145850_b != null) {
            this.cachedCoord = new Coord4D(this.field_174879_c, this.field_145850_b);
        }
    }

    @Override
    public Coord4D getTileCoord() {
        return this.cacheCoord && this.cachedCoord != null ? this.cachedCoord : ITileWrapper.super.getTileCoord();
    }
}

