/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Upgrade;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class UpgradesRecipeData
implements RecipeUpgradeData<UpgradesRecipeData> {
    private final Map<Upgrade, Integer> upgrades;

    UpgradesRecipeData(Map<Upgrade, Integer> upgrades) {
        this.upgrades = upgrades;
    }

    @Override
    @Nullable
    public UpgradesRecipeData merge(UpgradesRecipeData other) {
        EnumMap<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
        for (Upgrade upgrade : EnumUtils.UPGRADES) {
            int total = 0;
            if (this.upgrades.containsKey(upgrade)) {
                total += this.upgrades.get(upgrade).intValue();
            }
            if (other.upgrades.containsKey(upgrade)) {
                total += other.upgrades.get(upgrade).intValue();
            }
            if (total > upgrade.getMax()) {
                return null;
            }
            if (total <= 0) continue;
            upgrades.put(upgrade, total);
        }
        return new UpgradesRecipeData(upgrades);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.upgrades.isEmpty()) {
            return true;
        }
        Set<Upgrade> supportedUpgrades = Attribute.get(((BlockItem)stack.func_77973_b()).func_179223_d(), AttributeUpgradeSupport.class).getSupportedUpgrades();
        for (Upgrade upgrade : this.upgrades.keySet()) {
            if (supportedUpgrades.contains(upgrade)) continue;
            return false;
        }
        CompoundNBT nbt = new CompoundNBT();
        Upgrade.saveMap(this.upgrades, nbt);
        ItemDataUtils.setCompound(stack, "componentUpgrade", nbt);
        return true;
    }
}

