/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.util.MekanismUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BinExtractRecipe
extends BinRecipe {
    public BinExtractRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World world) {
        ItemStack binStack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemBlockBin) {
                if (!binStack.func_190926_b()) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            return false;
        }
        if (binStack.func_190926_b()) {
            return false;
        }
        return !BinExtractRecipe.convertToSlot(binStack).isEmpty();
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack binStack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemBlockBin) {
                if (!binStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                binStack = stackInSlot;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (binStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return BinExtractRecipe.convertToSlot(binStack).getBottomStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (!(stackInSlot.func_77973_b() instanceof ItemBlockBin)) continue;
            ItemStack binStack = stackInSlot.func_77946_l();
            BinInventorySlot slot = BinExtractRecipe.convertToSlot(binStack);
            ItemStack bottomStack = slot.getBottomStack();
            if (bottomStack.func_190926_b()) break;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(bottomStack.func_190916_E(), Action.EXECUTE), bottomStack.func_190916_E());
            remaining.set(i, (Object)binStack);
            break;
        }
        return remaining;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return MekanismRecipeSerializers.BIN_EXTRACT.getRecipeSerializer();
    }
}

