/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketNewFilter
implements IMekanismPacket {
    private final BlockPos pos;
    private final IFilter<?> filter;

    public PacketNewFilter(BlockPos pos, IFilter<?> filter) {
        this.pos = pos;
        this.filter = filter;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntity tile;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, this.pos)) != null) {
            if (this.filter instanceof SorterFilter && tile instanceof TileEntityLogisticalSorter) {
                ((TileEntityLogisticalSorter)tile).getFilters().add((SorterFilter)this.filter);
            } else if (this.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).getFilters().add((MinerFilter)this.filter);
            } else if (this.filter instanceof OredictionificatorItemFilter && tile instanceof TileEntityOredictionificator) {
                ((TileEntityOredictionificator)tile).getFilters().add((OredictionificatorItemFilter)this.filter);
            } else if (this.filter instanceof QIOFilter && tile instanceof TileEntityQIOFilterHandler) {
                ((TileEntityQIOFilterHandler)tile).getFilters().add((QIOFilter)this.filter);
            }
            tile.func_70296_d();
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        this.filter.write(buffer);
    }

    public static PacketNewFilter decode(PacketBuffer buffer) {
        return new PacketNewFilter(buffer.func_179259_c(), BaseFilter.readFromPacket(buffer));
    }
}

