/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketConfigurationUpdate
implements IMekanismPacket {
    private final ConfigurationPacket packetType;
    private final BlockPos pos;
    private TransmissionType transmission;
    private RelativeSide inputSide;
    private int clickType;

    public PacketConfigurationUpdate(@Nonnull ConfigurationPacket type, BlockPos pos, TransmissionType trans) {
        this.packetType = type;
        this.pos = pos;
        this.transmission = trans;
    }

    public PacketConfigurationUpdate(BlockPos pos, int click) {
        this.packetType = ConfigurationPacket.EJECT_COLOR;
        this.pos = pos;
        this.clickType = click;
    }

    public PacketConfigurationUpdate(BlockPos pos) {
        this.packetType = ConfigurationPacket.STRICT_INPUT;
        this.pos = pos;
    }

    public PacketConfigurationUpdate(@Nonnull ConfigurationPacket type, BlockPos pos, int click, RelativeSide inputSide, TransmissionType trans) {
        this.packetType = type;
        this.pos = pos;
        if (this.packetType == ConfigurationPacket.EJECT || this.packetType == ConfigurationPacket.CLEAR_ALL) {
            this.transmission = trans;
        } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
            this.clickType = click;
        } else if (this.packetType == ConfigurationPacket.SIDE_DATA) {
            this.clickType = click;
            this.inputSide = inputSide;
            this.transmission = trans;
        } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
            this.clickType = click;
            this.inputSide = inputSide;
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, this.pos);
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)tile;
            if (this.packetType == ConfigurationPacket.EJECT) {
                ConfigInfo info = config.getConfig().getConfig(this.transmission);
                if (info != null) {
                    info.setEjecting(!info.isEjecting());
                    WorldUtils.saveChunk(tile);
                }
            } else if (this.packetType == ConfigurationPacket.CLEAR_ALL) {
                TileComponentConfig configComponent = config.getConfig();
                ConfigInfo info = configComponent.getConfig(this.transmission);
                if (info != null) {
                    for (RelativeSide side : EnumUtils.SIDES) {
                        if (!info.isSideEnabled(side) || info.getDataType(side) == DataType.NONE) continue;
                        info.setDataType(DataType.NONE, side);
                        configComponent.sideChanged(this.transmission, side);
                    }
                }
            } else if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                TileComponentConfig configComponent = config.getConfig();
                ConfigInfo info = configComponent.getConfig(this.transmission);
                if (info != null) {
                    DataType type = info.getDataType(this.inputSide);
                    boolean changed = false;
                    if (this.clickType == 0) {
                        changed = type != info.incrementDataType(this.inputSide);
                    } else if (this.clickType == 1) {
                        changed = type != info.decrementDataType(this.inputSide);
                    } else if (this.clickType == 2 && type != DataType.NONE) {
                        changed = true;
                        info.setDataType(DataType.NONE, this.inputSide);
                    }
                    if (changed) {
                        configComponent.sideChanged(this.transmission, this.inputSide);
                    }
                }
            } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
                TileComponentEjector ejector = config.getEjector();
                if (this.clickType == 0) {
                    ejector.setOutputColor(TransporterUtils.increment(ejector.getOutputColor()));
                } else if (this.clickType == 1) {
                    ejector.setOutputColor(TransporterUtils.decrement(ejector.getOutputColor()));
                } else if (this.clickType == 2) {
                    ejector.setOutputColor(null);
                }
            } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                TileComponentEjector ejector = config.getEjector();
                if (this.clickType == 0) {
                    ejector.setInputColor(this.inputSide, TransporterUtils.increment(ejector.getInputColor(this.inputSide)));
                } else if (this.clickType == 1) {
                    ejector.setInputColor(this.inputSide, TransporterUtils.decrement(ejector.getInputColor(this.inputSide)));
                } else if (this.clickType == 2) {
                    ejector.setInputColor(this.inputSide, null);
                }
            } else if (this.packetType == ConfigurationPacket.STRICT_INPUT) {
                TileComponentEjector ejector;
                ejector.setStrictInput(!(ejector = config.getEjector()).hasStrictInput());
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.packetType);
        buffer.func_179255_a(this.pos);
        if (this.packetType == ConfigurationPacket.EJECT || this.packetType == ConfigurationPacket.CLEAR_ALL) {
            buffer.func_179249_a((Enum)this.transmission);
        } else if (this.packetType == ConfigurationPacket.SIDE_DATA) {
            buffer.func_150787_b(this.clickType);
            buffer.func_179249_a((Enum)this.inputSide);
            buffer.func_179249_a((Enum)this.transmission);
        } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
            buffer.func_150787_b(this.clickType);
        } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
            buffer.func_150787_b(this.clickType);
            buffer.func_179249_a((Enum)this.inputSide);
        }
    }

    public static PacketConfigurationUpdate decode(PacketBuffer buffer) {
        ConfigurationPacket packetType = (ConfigurationPacket)buffer.func_179257_a(ConfigurationPacket.class);
        BlockPos pos = buffer.func_179259_c();
        int clickType = 0;
        RelativeSide inputSide = null;
        TransmissionType transmission = null;
        if (packetType == ConfigurationPacket.EJECT || packetType == ConfigurationPacket.CLEAR_ALL) {
            transmission = (TransmissionType)buffer.func_179257_a(TransmissionType.class);
        } else if (packetType == ConfigurationPacket.SIDE_DATA) {
            clickType = buffer.func_150792_a();
            inputSide = (RelativeSide)buffer.func_179257_a(RelativeSide.class);
            transmission = (TransmissionType)buffer.func_179257_a(TransmissionType.class);
        } else if (packetType == ConfigurationPacket.EJECT_COLOR) {
            clickType = buffer.func_150792_a();
        } else if (packetType == ConfigurationPacket.INPUT_COLOR) {
            clickType = buffer.func_150792_a();
            inputSide = (RelativeSide)buffer.func_179257_a(RelativeSide.class);
        }
        return new PacketConfigurationUpdate(packetType, pos, clickType, inputSide, transmission);
    }

    public static enum ConfigurationPacket {
        EJECT,
        SIDE_DATA,
        EJECT_COLOR,
        INPUT_COLOR,
        STRICT_INPUT,
        CLEAR_ALL;

    }
}

