/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.math;

import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class Pos3D
extends Vector3d {
    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(Vector3d vec) {
        super(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Pos3D(Coord4D coord) {
        super((double)coord.getX(), (double)coord.getY(), (double)coord.getZ());
    }

    public Pos3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3D(Entity entity) {
        this(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public static Pos3D create(TileEntity tile) {
        return Pos3D.create((Vector3i)tile.func_174877_v());
    }

    public static Pos3D create(Vector3i vec) {
        return new Pos3D(Vector3d.func_237491_b_((Vector3i)vec));
    }

    public static Pos3D read(CompoundNBT tag) {
        return new Pos3D(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"));
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.field_72450_a * matrix[0] + translation.field_72448_b * matrix[1] + translation.field_72449_c * matrix[2] + matrix[3];
        double y = translation.field_72450_a * matrix[4] + translation.field_72448_b * matrix[5] + translation.field_72449_c * matrix[6] + matrix[7];
        double z = translation.field_72450_a * matrix[8] + translation.field_72448_b * matrix[9] + translation.field_72449_c * matrix[10] + matrix[11];
        return new Pos3D(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.func_72430_b(pos2));
    }

    public static AxisAlignedBB getAABB(Vector3d pos1, Vector3d pos2) {
        return new AxisAlignedBB(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c);
    }

    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74780_a("x", this.field_72450_a);
        nbtTags.func_74780_a("y", this.field_72448_b);
        nbtTags.func_74780_a("z", this.field_72449_c);
        return nbtTags;
    }

    public Pos3D diff(Vector3d vec) {
        return new Pos3D(this.field_72450_a - vec.field_72450_a, this.field_72448_b - vec.field_72448_b, this.field_72449_c - vec.field_72449_c);
    }

    public Coord4D getCoord(RegistryKey<World> dimension) {
        return new Coord4D((int)this.field_72450_a, (int)this.field_72448_b, (int)this.field_72449_c, dimension);
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double x, double y, double z) {
        return new Pos3D(this.field_72450_a + x, this.field_72448_b + y, this.field_72449_c + z);
    }

    public Pos3D translate(Vector3d pos) {
        return this.translate(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public Pos3D translate(Vector3d ... positions) {
        double x = this.field_72450_a;
        double y = this.field_72448_b;
        double z = this.field_72449_c;
        for (Vector3d position : positions) {
            x += position.field_72450_a;
            y += position.field_72448_b;
            z += position.field_72449_c;
        }
        return new Pos3D(x, y, z);
    }

    public Pos3D translate(Direction direction, double amount) {
        return this.translate((double)direction.func_176730_m().func_177958_n() * amount, (double)direction.func_176730_m().func_177956_o() * amount, (double)direction.func_176730_m().func_177952_p() * amount);
    }

    public Pos3D translateExcludingSide(Direction direction, double amount) {
        double xPos = this.field_72450_a;
        double yPos = this.field_72448_b;
        double zPos = this.field_72449_c;
        if (direction.func_176740_k() != Direction.Axis.X) {
            xPos += amount;
        }
        if (direction.func_176740_k() != Direction.Axis.Y) {
            yPos += amount;
        }
        if (direction.func_176740_k() != Direction.Axis.Z) {
            zPos += amount;
        }
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D adjustPosition(Direction direction, Entity entity) {
        if (direction.func_176740_k() == Direction.Axis.X) {
            return new Pos3D(entity.func_226277_ct_(), this.field_72448_b, this.field_72449_c);
        }
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return new Pos3D(this.field_72450_a, entity.func_226278_cu_(), this.field_72449_c);
        }
        return new Pos3D(this.field_72450_a, this.field_72448_b, entity.func_226281_cx_());
    }

    public double distance(Vector3d pos) {
        double subX = this.field_72450_a - pos.field_72450_a;
        double subY = this.field_72448_b - pos.field_72448_b;
        double subZ = this.field_72449_c - pos.field_72449_c;
        return MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    @Nonnull
    public Pos3D yRot(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.field_72450_a;
        double zPos = this.field_72449_c;
        if (yaw != 0.0f) {
            double cos = Math.cos(yawRadians);
            double sin = Math.sin(yawRadians);
            xPos = this.field_72450_a * cos - this.field_72449_c * sin;
            zPos = this.field_72449_c * cos + this.field_72450_a * sin;
        }
        return new Pos3D(xPos, this.field_72448_b, zPos);
    }

    @Nonnull
    public Pos3D xRot(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.field_72448_b;
        double zPos = this.field_72449_c;
        if (pitch != 0.0f) {
            double cos = Math.cos(pitchRadians);
            double sin = Math.sin(pitchRadians);
            yPos = this.field_72448_b * cos - this.field_72449_c * sin;
            zPos = this.field_72449_c * cos + this.field_72448_b * sin;
        }
        return new Pos3D(this.field_72450_a, yPos, zPos);
    }

    public Pos3D rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3D rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.field_72450_a * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.field_72449_c * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.field_72448_b * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double zPos = this.field_72450_a * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.field_72449_c * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.field_72448_b * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double yPos = -this.field_72450_a * Math.sin(pitchRadians) + this.field_72449_c * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.field_72448_b * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3D(xPos, yPos, zPos);
    }

    @Nonnull
    public Pos3D multiply(Vector3d pos) {
        return this.multiply(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    @Nonnull
    public Pos3D multiply(double x, double y, double z) {
        return new Pos3D(this.field_72450_a * x, this.field_72448_b * y, this.field_72449_c * z);
    }

    @Nonnull
    public Pos3D scale(double scale) {
        return this.multiply(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public Pos3D transform(Quaternion quaternion) {
        Quaternion q = quaternion.copy();
        q.multiply(new Quaternion(this.field_72450_a, this.field_72448_b, this.field_72449_c, 0.0));
        q.multiply(quaternion.copy().conjugate());
        return new Pos3D(q.getX(), q.getY(), q.getZ());
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.normalize();
        double x = axis.field_72450_a;
        double y = axis.field_72448_b;
        double z = axis.field_72449_c;
        double angleAsRadian = Math.toRadians(angle);
        float cos = (float)Math.cos(angleAsRadian);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angleAsRadian);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.func_72430_b(pos2));
    }

    @Nonnull
    public Pos3D normalize() {
        return new Pos3D(super.func_72432_b());
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.field_72449_c, -this.field_72448_b);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.field_72448_b, this.field_72450_a, 0.0);
    }

    public Pos3D getPerpendicular() {
        return this.field_72449_c == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.field_72450_a), Math.floor(this.field_72448_b), Math.floor(this.field_72449_c));
    }

    public Pos3D clone() {
        return new Pos3D(this.field_72450_a, this.field_72448_b, this.field_72449_c);
    }

    @Nonnull
    public String toString() {
        return "[Pos3D: " + this.field_72450_a + ", " + this.field_72448_b + ", " + this.field_72449_c + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector3d && ((Vector3d)obj).field_72450_a == this.field_72450_a && ((Vector3d)obj).field_72448_b == this.field_72448_b && ((Vector3d)obj).field_72449_c == this.field_72449_c;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + Double.hashCode(this.field_72450_a);
        code = 31 * code + Double.hashCode(this.field_72448_b);
        code = 31 * code + Double.hashCode(this.field_72449_c);
        return code;
    }
}

