/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockBounding;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleShearingUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemMekaTool
extends ItemEnergized
implements IModuleContainerItem,
IModeItem {
    private final Multimap<Attribute, AttributeModifier> attributes;

    public ItemMekaTool(Item.Properties properties) {
        super(MekanismConfig.gear.mekaToolBaseChargeRate, MekanismConfig.gear.mekaToolBaseEnergyCapacity, properties.func_208103_a(Rarity.EPIC).setNoRepair());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public boolean func_150897_b(@Nonnull BlockState state) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    @Nonnull
    public Set<ToolType> getToolTypes(@Nonnull ItemStack stack) {
        if (this.isModuleEnabled(stack, MekanismModules.SHEARING_UNIT)) {
            HashSet<ToolType> types = new HashSet<ToolType>(super.getToolTypes(stack));
            types.add(ModuleShearingUnit.SHEARS_TOOL_TYPE);
            return types;
        }
        return super.getToolTypes(stack);
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && super.func_77636_d(stack) && IModuleContainerItem.hasOtherEnchants(stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        for (Module module : this.getModules(context.func_195996_i())) {
            ActionResultType result;
            if (!module.isEnabled() || (result = this.onModuleUse(module, context)) == ActionResultType.PASS) continue;
            return result;
        }
        return super.func_195939_a(context);
    }

    private <MODULE extends ICustomModule<MODULE>> ActionResultType onModuleUse(IModule<MODULE> module, ItemUseContext context) {
        return module.getCustomInstance().onItemUse(module, context);
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull LivingEntity entity, @Nonnull Hand hand) {
        for (Module module : this.getModules(stack)) {
            ActionResultType result;
            if (!module.isEnabled() || (result = this.onModuleInteract(module, player, entity, hand)) == ActionResultType.PASS) continue;
            return result;
        }
        return super.func_111207_a(stack, player, entity, hand);
    }

    private <MODULE extends ICustomModule<MODULE>> ActionResultType onModuleInteract(IModule<MODULE> module, @Nonnull PlayerEntity player, @Nonnull LivingEntity entity, @Nonnull Hand hand) {
        return module.getCustomInstance().onInteract(module, player, entity, hand);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        FloatingLong energyRequired = this.getDestroyEnergy(stack, state.field_235705_i_, this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
        FloatingLong energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable.smallerThan(energyRequired)) {
            return MekanismConfig.gear.mekaToolBaseEfficiency.get() * energyAvailable.divide(energyRequired).floatValue();
        }
        IModule module = this.getModule(stack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        return module == null || !module.isEnabled() ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityliving) {
        FloatingLong energyRequired;
        FloatingLong extractedEnergy;
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null && ((extractedEnergy = energyContainer.extract(energyRequired = this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos), this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT)), Action.EXECUTE, AutomationType.MANUAL)).equals(energyRequired) || entityliving instanceof PlayerEntity && ((PlayerEntity)entityliving).func_184812_l_()) && state.func_203425_a(Blocks.field_150473_bD) && !((Boolean)state.func_177229_b((Property)TripWireBlock.field_176295_N)).booleanValue() && this.isModuleEnabled(stack, MekanismModules.SHEARING_UNIT)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TripWireBlock.field_176295_N, (Comparable)Boolean.valueOf(true)), 4);
        }
        return true;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        int minDamage;
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        FloatingLong energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
        FloatingLong energyCost = FloatingLong.ZERO;
        int maxDamage = minDamage = MekanismConfig.gear.mekaToolBaseDamage.get();
        IModule attackAmplificationUnit = this.getModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled()) {
            maxDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage();
            if (maxDamage > minDamage) {
                energyCost = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((float)(maxDamage - minDamage) / 4.0f);
            }
            minDamage = Math.min(minDamage, maxDamage);
        }
        int damageDifference = maxDamage - minDamage;
        double percent = 1.0;
        if (energy.smallerThan(energyCost)) {
            percent = energy.divideToLevel(energyCost);
        }
        float damage = (float)((double)minDamage + (double)damageDifference * percent);
        if (attacker instanceof PlayerEntity) {
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), damage);
        } else {
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), damage);
        }
        if (energyContainer != null && !energy.isZero()) {
            energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K || player.func_184812_l_()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            boolean isOre;
            IModule veinMiningUnit;
            World world = player.field_70170_p;
            BlockState state = world.func_180495_p(pos);
            boolean silk = this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT);
            FloatingLong energyRequired = this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos), silk);
            if (energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL).greaterOrEqual(energyRequired) && (veinMiningUnit = this.getModule(stack, MekanismModules.VEIN_MINING_UNIT)) != null && veinMiningUnit.isEnabled() && !(state.func_177230_c() instanceof BlockBounding) && ((isOre = state.func_235714_a_(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE)) || ((ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance()).isExtended())) {
                FloatingLong baseDestroyEnergy = this.getDestroyEnergy(silk);
                Set<BlockPos> found = ModuleVeinMiningUnit.findPositions(state, pos, world, isOre ? -1 : ((ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance()).getExcavationRange());
                MekanismUtils.veinMineArea(energyContainer, world, pos, (ServerPlayerEntity)player, stack, this, found, this.isModuleEnabled(stack, MekanismModules.SHEARING_UNIT), hardness -> this.getDestroyEnergy(baseDestroyEnergy, hardness.floatValue()), distance -> 0.5 * Math.pow(distance, isOre ? 1.5 : 2.0), state);
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private FloatingLong getDestroyEnergy(boolean silk) {
        return silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        return this.getDestroyEnergy(this.getDestroyEnergy(itemStack, silk), hardness);
    }

    private FloatingLong getDestroyEnergy(FloatingLong baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? baseDestroyEnergy.divide(2L) : baseDestroyEnergy;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, boolean silk) {
        FloatingLong destroyEnergy = this.getDestroyEnergy(silk);
        IModule module = this.getModule(itemStack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null || !module.isEnabled() ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
        return destroyEnergy.multiply(efficiency);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributes : super.getAttributeModifiers(slot, stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        IModule module;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_201670_d() && (module = this.getModule(stack, MekanismModules.TELEPORTATION_UNIT)) != null && module.isEnabled()) {
            BlockPos pos;
            BlockRayTraceResult result = MekanismUtils.rayTrace(player, MekanismConfig.gear.mekaToolMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.func_216346_c() != RayTraceResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.func_216350_a()).func_177984_a()) && this.isValidDestinationBlock(world, pos.func_177981_b(2))) {
                double distance = player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (distance < 5.0) {
                    return new ActionResult(ActionResultType.PASS, (Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong energyNeeded = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get()).multiply(distance / 10.0);
                if (energyContainer == null || energyContainer.getEnergy().smallerThan(energyNeeded)) {
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                if (player.func_184218_aH()) {
                    player.func_184210_p();
                }
                player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
                player.field_70143_R = 0.0f;
                Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(pos.func_177984_a()), world, pos);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private boolean isValidDestinationBlock(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        return blockState.isAir((IBlockReader)world, pos) || blockState.func_177230_c() instanceof FlowingFluidBlock || blockState.func_177230_c() instanceof IFluidBlock;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        stack.func_242395_a(ItemStack.TooltipDisplayFlags.MODIFIERS);
        return super.initCapabilities(stack, nbt);
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @Nonnull EquipmentSlotType slotType) {
        return IModeItem.super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesModeChange);
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChangeMessage);
            return;
        }
    }

    @Override
    protected FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaToolBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    @Override
    protected FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaToolBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }
}

