/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitMultiTankGasHandler;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.capabilities.laser.item.LaserDissipationHandler;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemHazmatSuitArmor;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemSpecialArmor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.TriPredicate;

public class ItemMekaSuitArmor
extends ItemSpecialArmor
implements IModuleContainerItem,
IModeItem {
    private static final Set<DamageSource> ALWAYS_SUPPORTED_SOURCES = new LinkedHashSet<DamageSource>(Arrays.asList(DamageSource.field_82728_o, DamageSource.field_76367_g, DamageSource.field_191291_g, DamageSource.field_188407_q, DamageSource.field_205132_u, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_188406_j, DamageSource.field_76377_j, DamageSource.field_190095_e, DamageSource.field_76372_a, DamageSource.field_76368_d, DamageSource.field_76371_c, DamageSource.field_180137_b, DamageSource.field_76370_b, DamageSource.field_220302_v, DamageSource.field_82727_n));
    private static final MekaSuitMaterial MEKASUIT_MATERIAL = new MekaSuitMaterial();
    private final Set<RateLimitMultiTankGasHandler.GasTankSpec> gasTankSpecs = new HashSet<RateLimitMultiTankGasHandler.GasTankSpec>();
    private final float absorption;
    private final double laserDissipation;
    private final double laserRefraction;

    public static Set<DamageSource> getSupportedSources() {
        return Collections.unmodifiableSet(ALWAYS_SUPPORTED_SOURCES);
    }

    public ItemMekaSuitArmor(EquipmentSlotType slot, Item.Properties properties) {
        super(MEKASUIT_MATERIAL, slot, properties.func_208103_a(Rarity.EPIC).setNoRepair().func_200917_a(1));
        if (slot == EquipmentSlotType.HEAD) {
            this.gasTankSpecs.add(RateLimitMultiTankGasHandler.GasTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitNutritionalTransferRate, MekanismConfig.gear.mekaSuitNutritionalMaxStorage, (TriPredicate<Gas, AutomationType, ItemStack>)((TriPredicate)(gas, automationType, stack) -> this.hasModule((ItemStack)stack, MekanismModules.NUTRITIONAL_INJECTION_UNIT)), gas -> gas == MekanismGases.NUTRITIONAL_PASTE.get()));
            this.absorption = 0.15f;
            this.laserDissipation = 0.15;
            this.laserRefraction = 0.2;
        } else if (slot == EquipmentSlotType.CHEST) {
            this.gasTankSpecs.add(RateLimitMultiTankGasHandler.GasTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitJetpackTransferRate, MekanismConfig.gear.mekaSuitJetpackMaxStorage, (TriPredicate<Gas, AutomationType, ItemStack>)((TriPredicate)(gas, automationType, stack) -> this.hasModule((ItemStack)stack, MekanismModules.JETPACK_UNIT)), gas -> gas == MekanismGases.HYDROGEN.get()));
            this.absorption = 0.4f;
            this.laserDissipation = 0.3;
            this.laserRefraction = 0.4;
        } else if (slot == EquipmentSlotType.LEGS) {
            this.absorption = 0.3f;
            this.laserDissipation = 0.1875;
            this.laserRefraction = 0.25;
        } else if (slot == EquipmentSlotType.FEET) {
            this.absorption = 0.15f;
            this.laserDissipation = 0.1125;
            this.laserRefraction = 0.15;
        } else {
            throw new IllegalArgumentException("Unknown Equipment Slot Type");
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            if (!this.gasTankSpecs.isEmpty()) {
                StorageUtils.addStoredGas(stack, tooltip, true, false);
            }
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    public boolean makesPiglinsNeutral(@Nonnull ItemStack stack, @Nonnull LivingEntity wearer) {
        return true;
    }

    public boolean isEnderMask(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull EndermanEntity enderman) {
        return this.func_185083_B_() == EquipmentSlotType.HEAD;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getEnergyDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && super.func_77636_d(stack) && IModuleContainerItem.hasOtherEnchants(stack);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            items.add((Object)StorageUtils.getFilledEnergyVariant(stack, this.getMaxEnergy(stack)));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        for (Module module : this.getModules(stack)) {
            module.tick(player);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        stack.func_242395_a(ItemStack.TooltipDisplayFlags.MODIFIERS);
        ItemCapabilityWrapper wrapper = new ItemCapabilityWrapper(stack, RateLimitEnergyHandler.create(() -> this.getChargeRate(stack), () -> this.getMaxEnergy(stack), BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue), RadiationShieldingHandler.create(item -> this.isModuleEnabled((ItemStack)item, MekanismModules.RADIATION_SHIELDING_UNIT) ? ItemHazmatSuitArmor.getShieldingByArmor(this.field_77881_a) : 0.0), LaserDissipationHandler.create(item -> this.isModuleEnabled((ItemStack)item, MekanismModules.LASER_DISSIPATION_UNIT) ? this.laserDissipation : 0.0, item -> this.isModuleEnabled((ItemStack)item, MekanismModules.LASER_DISSIPATION_UNIT) ? this.laserRefraction : 0.0));
        if (!this.gasTankSpecs.isEmpty()) {
            wrapper.add(RateLimitMultiTankGasHandler.create(this.gasTankSpecs));
        }
        return wrapper;
    }

    @Nonnull
    public GasStack useGas(ItemStack stack, Gas type, long amount) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            return gasHandlerItem.extractChemical(new GasStack(type, amount), Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }

    public GasStack getContainedGas(ItemStack stack, Gas type) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            for (int i = 0; i < gasHandlerItem.getTanks(); ++i) {
                GasStack gasInTank = (GasStack)gasHandlerItem.getChemicalInTank(i);
                if (gasInTank.getType() != type) continue;
                return gasInTank;
            }
        }
        return GasStack.EMPTY;
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChangeMessage);
            return;
        }
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @Nonnull EquipmentSlotType slotType) {
        return slotType == this.func_185083_B_() && this.getModules(stack).stream().anyMatch(Module::handlesModeChange);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        IModule module;
        if (this.field_77881_a == EquipmentSlotType.CHEST && !entity.func_225608_bj_() && (module = this.getModule(stack, MekanismModules.ELYTRA_UNIT)) != null && module.isEnabled() && module.canUseEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get())) {
            IModule jetpack = this.getModule(stack, MekanismModules.JETPACK_UNIT);
            return jetpack == null || !jetpack.isEnabled() || ((ModuleJetpackUnit)jetpack.getCustomInstance()).getMode() != ItemJetpack.JetpackMode.HOVER || this.getContainedGas(stack, (Gas)MekanismGases.HYDROGEN.get()).isEmpty();
        }
        return false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        IModule module;
        if (!entity.field_70170_p.field_72995_K && (flightTicks + 1) % 20 == 0 && (module = this.getModule(stack, MekanismModules.ELYTRA_UNIT)) != null && module.isEnabled()) {
            module.useEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get());
        }
        return true;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public CustomArmor getGearModel() {
        switch (this.func_185083_B_()) {
            case HEAD: {
                return MekaSuitArmor.HELMET;
            }
            case CHEST: {
                return MekaSuitArmor.BODYARMOR;
            }
            case LEGS: {
                return MekaSuitArmor.PANTS;
            }
        }
        return MekaSuitArmor.BOOTS;
    }

    private FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaSuitBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    private FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaSuitBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }

    public static float getDamageAbsorbed(PlayerEntity player, DamageSource source, float amount) {
        return ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, null);
    }

    public static boolean tryAbsorbAll(PlayerEntity player, DamageSource source, float amount) {
        ArrayList<Runnable> energyUsageCallbacks = new ArrayList<Runnable>(4);
        if (ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, energyUsageCallbacks) >= 1.0f) {
            for (Runnable energyUsageCallback : energyUsageCallbacks) {
                energyUsageCallback.run();
            }
            return true;
        }
        return false;
    }

    private static float getDamageAbsorbed(PlayerEntity player, DamageSource source, float amount, @Nullable List<Runnable> energyUseCallbacks) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float ratioAbsorbed = 0.0f;
        ArrayList<FoundArmorDetails> armorDetails = new ArrayList<FoundArmorDetails>();
        for (Object stack : player.field_71071_by.field_70460_b) {
            IEnergyContainer energyContainer;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMekaSuitArmor) || (energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, 0)) == null) continue;
            FoundArmorDetails details = new FoundArmorDetails(energyContainer, (ItemMekaSuitArmor)stack.func_77973_b());
            armorDetails.add(details);
            for (Module module : details.armor.getModules((ItemStack)stack)) {
                ICustomModule.ModuleDamageAbsorbInfo damageAbsorbInfo;
                if (!module.isEnabled() || (damageAbsorbInfo = ItemMekaSuitArmor.getModuleDamageAbsorbInfo(module, source)) == null) continue;
                float absorption = damageAbsorbInfo.getAbsorptionRatio().getAsFloat();
                if (!((ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption, ratioAbsorbed, damageAbsorbInfo.getEnergyCost())) >= 1.0f)) continue;
                break;
            }
            if (!(ratioAbsorbed >= 1.0f)) continue;
            break;
        }
        if (ratioAbsorbed < 1.0f) {
            FloatSupplier absorbRatio = null;
            for (FoundArmorDetails details : armorDetails) {
                if (absorbRatio == null && (!ALWAYS_SUPPORTED_SOURCES.contains(source) && source.func_76363_c() || (absorbRatio = (FloatSupplier)MekanismConfig.gear.mekaSuitDamageRatios.getOrDefault(source, MekanismConfig.gear.mekaSuitUnspecifiedDamageRatio)).getAsFloat() == 0.0f)) break;
                float absorption = ((FoundArmorDetails)details).armor.absorption * absorbRatio.getAsFloat();
                if (!((ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption, ratioAbsorbed, MekanismConfig.gear.mekaSuitEnergyUsageDamage)) >= 1.0f)) continue;
                break;
            }
        }
        for (FoundArmorDetails details : armorDetails) {
            if (details.usageInfo.energyUsed.isZero()) continue;
            if (energyUseCallbacks == null) {
                details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL);
                continue;
            }
            energyUseCallbacks.add(() -> details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL));
        }
        return Math.min(ratioAbsorbed, 1.0f);
    }

    @Nullable
    private static <MODULE extends ICustomModule<MODULE>> ICustomModule.ModuleDamageAbsorbInfo getModuleDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return module.getCustomInstance().getDamageAbsorbInfo(module, damageSource);
    }

    private static float absorbDamage(EnergyUsageInfo usageInfo, float amount, float absorption, float currentAbsorbed, FloatingLongSupplier energyCost) {
        float toAbsorb = amount * (absorption = Math.min(1.0f - currentAbsorbed, absorption));
        if (toAbsorb > 0.0f) {
            FloatingLong usage = energyCost.get().multiply(toAbsorb);
            if (usage.isZero()) {
                return absorption;
            }
            if (usageInfo.energyAvailable.greaterOrEqual(usage)) {
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usage);
                usageInfo.energyAvailable = usageInfo.energyAvailable.minusEqual(usage);
                return absorption;
            }
            if (!usageInfo.energyAvailable.isZero()) {
                float absorbedPercent = usageInfo.energyAvailable.divide(usage).floatValue();
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usageInfo.energyAvailable);
                usageInfo.energyAvailable = FloatingLong.ZERO;
                return absorption * absorbedPercent;
            }
        }
        return 0.0f;
    }

    protected static class MekaSuitMaterial
    extends BaseSpecialArmorMaterial {
        protected MekaSuitMaterial() {
        }

        @Override
        public int func_200902_b(@Nonnull EquipmentSlotType slot) {
            return ArmorMaterial.NETHERITE.func_200902_b(slot);
        }

        @Override
        public float func_200901_e() {
            return ArmorMaterial.NETHERITE.func_200901_e();
        }

        @Override
        public float func_230304_f_() {
            return ArmorMaterial.NETHERITE.func_230304_f_();
        }

        @Nonnull
        public String func_200897_d() {
            return "mekanism:mekasuit";
        }
    }

    private static class EnergyUsageInfo {
        private FloatingLong energyAvailable;
        private FloatingLong energyUsed = FloatingLong.ZERO;

        public EnergyUsageInfo(FloatingLong energyAvailable) {
            this.energyAvailable = energyAvailable.copy();
        }
    }

    private static class FoundArmorDetails {
        private final IEnergyContainer energyContainer;
        private final EnergyUsageInfo usageInfo;
        private final ItemMekaSuitArmor armor;

        public FoundArmorDetails(IEnergyContainer energyContainer, ItemMekaSuitArmor armor) {
            this.energyContainer = energyContainer;
            this.usageInfo = new EnergyUsageInfo(energyContainer.getEnergy());
            this.armor = armor;
        }
    }
}

