/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.type;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.inventory.container.type.BaseMekanismContainerType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.IContainerFactory;

public class MekanismContainerType<T, CONTAINER extends Container>
extends BaseMekanismContainerType<T, CONTAINER, IMekanismContainerFactory<T, CONTAINER>> {
    public static <TILE extends TileEntityMekanism, CONTAINER extends Container> MekanismContainerType<TILE, CONTAINER> tile(Class<TILE> type, IMekanismContainerFactory<TILE, CONTAINER> constructor) {
        return new MekanismContainerType<TILE, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, MekanismContainerType.getTileFromBuf(buf, type)));
    }

    public static <TILE extends TileEntityMekanism, CONTAINER extends Container> MekanismContainerType<TILE, CONTAINER> tile(Class<TILE> type, IMekanismSidedContainerFactory<TILE, CONTAINER> constructor) {
        return new MekanismContainerType<TILE, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, MekanismContainerType.getTileFromBuf(buf, type), true));
    }

    public static <ENTITY extends Entity, CONTAINER extends Container> MekanismContainerType<ENTITY, CONTAINER> entity(Class<ENTITY> type, IMekanismContainerFactory<ENTITY, CONTAINER> constructor) {
        return new MekanismContainerType<ENTITY, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, MekanismContainerType.getEntityFromBuf(buf, type)));
    }

    public static <ENTITY extends Entity, CONTAINER extends Container> MekanismContainerType<ENTITY, CONTAINER> entity(Class<ENTITY> type, IMekanismSidedContainerFactory<ENTITY, CONTAINER> constructor) {
        return new MekanismContainerType<ENTITY, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, MekanismContainerType.getEntityFromBuf(buf, type), true));
    }

    protected MekanismContainerType(Class<T> type, IMekanismContainerFactory<T, CONTAINER> mekanismConstructor, IContainerFactory<CONTAINER> constructor) {
        super(type, mekanismConstructor, constructor);
    }

    @Nullable
    public CONTAINER create(int id, PlayerInventory inv, Object data) {
        if (this.type.isInstance(data)) {
            return ((IMekanismContainerFactory)this.mekanismConstructor).create(id, inv, this.type.cast(data));
        }
        return null;
    }

    @Nullable
    public IContainerProvider create(Object data) {
        if (this.type.isInstance(data)) {
            Object d = this.type.cast(data);
            return (id, inv, player) -> ((IMekanismContainerFactory)this.mekanismConstructor).create(id, inv, d);
        }
        return null;
    }

    @Nonnull
    private static <TILE extends TileEntity> TILE getTileFromBuf(PacketBuffer buf, Class<TILE> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer");
        }
        return (TILE)((TileEntity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlockPos pos = buf.func_179259_c();
            Object tile = WorldUtils.getTileEntity(type, (IBlockReader)Minecraft.func_71410_x().field_71441_e, pos);
            if (tile == null) {
                throw new IllegalStateException("Client could not locate tile at " + pos + " for tile container. This is likely caused by a mod breaking client side tile lookup");
            }
            return tile;
        }));
    }

    @Nonnull
    private static <ENTITY extends Entity> ENTITY getEntityFromBuf(PacketBuffer buf, Class<ENTITY> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer");
        }
        return (ENTITY)((Entity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.func_71410_x().field_71441_e == null) {
                throw new IllegalStateException("Client world is null.");
            }
            int entityId = buf.func_150792_a();
            Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId);
            if (type.isInstance(e)) {
                return e;
            }
            throw new IllegalStateException("Client could not locate entity (id: " + entityId + ")  for entity container or the entity was of an invalid type. This is likely caused by a mod breaking client side entity lookup.");
        }));
    }

    @FunctionalInterface
    public static interface IMekanismSidedContainerFactory<T, CONTAINER extends Container>
    extends IMekanismContainerFactory<T, CONTAINER> {
        public CONTAINER create(int var1, PlayerInventory var2, T var3, boolean var4);

        @Override
        default public CONTAINER create(int id, PlayerInventory inv, T data) {
            return this.create(id, inv, data, false);
        }
    }

    @FunctionalInterface
    public static interface IMekanismContainerFactory<T, CONTAINER extends Container> {
        public CONTAINER create(int var1, PlayerInventory var2, T var3);
    }
}

