/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.chemical;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.slurry.IEmptySlurryProvider;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.network.to_client.container.property.LongPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.chemical.SlurryStackPropertyData;

public class SyncableSlurryStack
extends SyncableChemicalStack<Slurry, SlurryStack>
implements IEmptySlurryProvider {
    public static SyncableSlurryStack create(ISlurryTank handler) {
        return SyncableSlurryStack.create(handler, false);
    }

    public static SyncableSlurryStack create(ISlurryTank handler, boolean isClient) {
        return SyncableSlurryStack.create(handler::getStack, isClient ? handler::setStackUnchecked : handler::setStack);
    }

    public static SyncableSlurryStack create(Supplier<@NonNull SlurryStack> getter, Consumer<@NonNull SlurryStack> setter) {
        return new SyncableSlurryStack(getter, setter);
    }

    private SyncableSlurryStack(Supplier<@NonNull SlurryStack> getter, Consumer<@NonNull SlurryStack> setter) {
        super(getter, setter);
    }

    @Override
    @Nonnull
    protected SlurryStack createStack(SlurryStack stored, long size) {
        return new SlurryStack(stored, size);
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new LongPropertyData(property, ((SlurryStack)this.get()).getAmount());
        }
        return new SlurryStackPropertyData(property, (SlurryStack)this.get());
    }
}

