/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.ItemStackMekanismInventory;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.IFrequencyItem;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PortableQIODashboardInventory
extends ItemStackMekanismInventory
implements IQIOCraftingWindowHolder {
    @Nullable
    private final World world;
    private QIOCraftingWindow[] craftingWindows;

    public PortableQIODashboardInventory(ItemStack stack, @Nonnull PlayerInventory inv) {
        super(stack);
        this.world = inv.field_70458_d.func_130014_f_();
        for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
            craftingWindow.invalidateRecipe();
        }
    }

    @Override
    protected List<IInventorySlot> getInitialInventory() {
        ArrayList<IInventorySlot> slots = new ArrayList<IInventorySlot>();
        this.craftingWindows = new QIOCraftingWindow[3];
        for (byte tableIndex = 0; tableIndex < this.craftingWindows.length; tableIndex = (byte)(tableIndex + 1)) {
            QIOCraftingWindow craftingWindow;
            this.craftingWindows[tableIndex] = craftingWindow = new QIOCraftingWindow(this, tableIndex);
            for (int slot = 0; slot < 9; ++slot) {
                slots.add(craftingWindow.getInputSlot(slot));
            }
            slots.add(craftingWindow.getOutputSlot());
        }
        return slots;
    }

    @Override
    @Nullable
    public World getHolderWorld() {
        return this.world;
    }

    @Override
    public QIOCraftingWindow[] getCraftingWindows() {
        return this.craftingWindows;
    }

    @Override
    @Nullable
    public QIOFrequency getFrequency() {
        IFrequencyItem frequencyItem;
        if (this.world != null && !this.world.func_201670_d() && (frequencyItem = (IFrequencyItem)this.stack.func_77973_b()).hasFrequency(this.stack)) {
            Frequency frequency = frequencyItem.getFrequency(this.stack);
            if (frequency instanceof QIOFrequency) {
                return (QIOFrequency)frequency;
            }
            frequencyItem.setFrequency(this.stack, null);
        }
        return null;
    }
}

