/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStack;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerFluid;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.tag.CrTChemicalTagManager;
import mekanism.common.integration.crafttweaker.tag.CrTGasTagManager;
import mekanism.common.integration.crafttweaker.tag.CrTInfuseTypeTagManager;
import mekanism.common.integration.crafttweaker.tag.CrTPigmentTagManager;
import mekanism.common.integration.crafttweaker.tag.CrTSlurryTagManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class MekanismRecipeHandler<RECIPE extends MekanismRecipe>
implements IRecipeHandler<RECIPE> {
    protected static final Object SKIP_OPTIONAL_PARAM = new Object();

    public abstract <U extends IRecipe<?>> boolean doesConflict(IRecipeManager var1, RECIPE var2, U var3);

    protected <TYPE, INGREDIENT extends InputIngredient<TYPE>> boolean ingredientConflicts(INGREDIENT a, INGREDIENT b) {
        return a.getRepresentations().stream().anyMatch(b::testType);
    }

    protected <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean chemicalIngredientConflicts(IChemicalStackIngredient<CHEMICAL, STACK> a, IChemicalStackIngredient<?, ?> b) {
        return ChemicalType.getTypeFor(a) == ChemicalType.getTypeFor(b) && this.ingredientConflicts(a, b);
    }

    protected String buildCommandString(IRecipeManager manager, RECIPE recipe, Object ... params) {
        return this.buildCommandString(manager, "addRecipe", recipe, params);
    }

    protected String buildCommandString(IRecipeManager manager, String method, RECIPE recipe, Object ... params) {
        StringBuilder commandString = new StringBuilder(manager.getCommandString()).append('.').append(method).append("(\"").append(((MekanismRecipe)recipe).func_199560_c().func_110623_a()).append('\"');
        for (Object param : params) {
            if (param == SKIP_OPTIONAL_PARAM) continue;
            commandString.append(", ").append(this.convertParam(param));
        }
        return commandString.append(");").toString();
    }

    private String convertParam(Object param) {
        if (param instanceof ItemStack) {
            return ItemStackHelper.getCommandString((ItemStack)((ItemStack)param));
        }
        if (param instanceof FluidStack) {
            return new MCFluidStack((FluidStack)param).getCommandString();
        }
        if (param instanceof GasStack) {
            return new CrTChemicalStack.CrTGasStack((GasStack)param).getCommandString();
        }
        if (param instanceof InfusionStack) {
            return new CrTChemicalStack.CrTInfusionStack((InfusionStack)param).getCommandString();
        }
        if (param instanceof PigmentStack) {
            return new CrTChemicalStack.CrTPigmentStack((PigmentStack)param).getCommandString();
        }
        if (param instanceof SlurryStack) {
            return new CrTChemicalStack.CrTSlurryStack((SlurryStack)param).getCommandString();
        }
        if (param instanceof BoxedChemicalStack) {
            return this.convertParam(((BoxedChemicalStack)param).getChemicalStack());
        }
        if (param instanceof FloatingLong) {
            FloatingLong fl = (FloatingLong)param;
            if (fl.getDecimal() == 0) {
                return fl.toString(0);
            }
            return fl.toString().replaceAll("0*$", "");
        }
        if (param instanceof Number || param instanceof Boolean) {
            return param.toString();
        }
        if (param instanceof ItemStackIngredient) {
            return this.convertIngredient((ItemStackIngredient)param);
        }
        if (param instanceof FluidStackIngredient) {
            return this.convertIngredient((FluidStackIngredient)param);
        }
        if (param instanceof GasStackIngredient) {
            return this.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.GasStackIngredient", CrTGasTagManager.INSTANCE, ChemicalIngredientDeserializer.GAS, (GasStackIngredient)param);
        }
        if (param instanceof InfusionStackIngredient) {
            return this.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.InfusionStackIngredient", CrTInfuseTypeTagManager.INSTANCE, ChemicalIngredientDeserializer.INFUSION, (InfusionStackIngredient)param);
        }
        if (param instanceof PigmentStackIngredient) {
            return this.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.PigmentStackIngredient", CrTPigmentTagManager.INSTANCE, ChemicalIngredientDeserializer.PIGMENT, (PigmentStackIngredient)param);
        }
        if (param instanceof SlurryStackIngredient) {
            return this.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.SlurryStackIngredient", CrTSlurryTagManager.INSTANCE, ChemicalIngredientDeserializer.SLURRY, (SlurryStackIngredient)param);
        }
        if (param instanceof List) {
            List list = (List)param;
            if (list.isEmpty()) {
                return "Invalid (output) list, no outputs";
            }
            return this.convertParam(list.get(0));
        }
        return "Unimplemented: " + param;
    }

    private String getTagWithExplicitAmount(MCTag<?> tag, int amount) {
        return tag.getCommandString() + " * " + amount;
    }

    @Nullable
    public static String basicImplicitIngredient(Ingredient vanillaIngredient, int amount, JsonElement serialized) {
        if (serialized.isJsonObject()) {
            JsonObject serializedIngredient = serialized.getAsJsonObject();
            if (vanillaIngredient.isVanilla()) {
                if (serializedIngredient.has("item")) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(serializedIngredient.get("item").getAsString()));
                    return ItemStackHelper.getCommandString((ItemStack)new ItemStack((IItemProvider)item, amount));
                }
                if (serializedIngredient.has("tag")) {
                    return TagManagerItem.INSTANCE.getTag(serializedIngredient.get("tag").getAsString()).withAmount(amount).getCommandString();
                }
            } else if (vanillaIngredient instanceof NBTIngredient) {
                ItemStack stack = CraftingHelper.getItemStack((JsonObject)serializedIngredient, (boolean)true);
                stack.func_190920_e(amount);
                return ItemStackHelper.getCommandString((ItemStack)stack);
            }
        }
        return null;
    }

    private String convertIngredient(ItemStackIngredient ingredient) {
        if (ingredient instanceof ItemStackIngredient.Single) {
            int amount;
            JsonObject serialized = ingredient.serialize().getAsJsonObject();
            Ingredient vanillaIngredient = ((ItemStackIngredient.Single)ingredient).getInputRaw();
            String rep = MekanismRecipeHandler.basicImplicitIngredient(vanillaIngredient, amount = JSONUtils.func_151208_a((JsonObject)serialized, (String)"amount", (int)1), serialized.get("ingredient"));
            if (rep == null) {
                rep = IIngredient.fromIngredient((Ingredient)vanillaIngredient).getCommandString();
                if (amount > 1) {
                    return "mods.mekanism.api.ingredient.ItemStackIngredient.from(" + rep + ", " + amount + ")";
                }
            }
            return rep;
        }
        if (ingredient instanceof ItemStackIngredient.Multi) {
            ItemStackIngredient.Multi multiIngredient = (ItemStackIngredient.Multi)ingredient;
            StringBuilder builder = new StringBuilder("mods.mekanism.api.ingredient.ItemStackIngredient.createMulti(");
            multiIngredient.forEachIngredient(i -> {
                builder.append(this.convertIngredient((ItemStackIngredient)i)).append(", ");
                return false;
            });
            builder.setLength(builder.length() - 2);
            builder.append(")");
            return builder.toString();
        }
        return "Unimplemented itemstack ingredient: " + ingredient;
    }

    private String convertIngredient(FluidStackIngredient ingredient) {
        if (ingredient instanceof FluidStackIngredient.Single) {
            JsonObject serialized = ingredient.serialize().getAsJsonObject();
            return new MCFluidStack(SerializerHelper.deserializeFluid(serialized)).getCommandString();
        }
        if (ingredient instanceof FluidStackIngredient.Tagged) {
            JsonObject serialized = ingredient.serialize().getAsJsonObject();
            return this.getTagWithExplicitAmount(TagManagerFluid.INSTANCE.getTag(serialized.get("tag").getAsString()), serialized.getAsJsonPrimitive("amount").getAsInt());
        }
        if (ingredient instanceof FluidStackIngredient.Multi) {
            FluidStackIngredient.Multi multiIngredient = (FluidStackIngredient.Multi)ingredient;
            StringBuilder builder = new StringBuilder("mods.mekanism.api.ingredient.FluidStackIngredient.createMulti(");
            multiIngredient.forEachIngredient(i -> {
                builder.append(this.convertIngredient((FluidStackIngredient)i)).append(", ");
                return false;
            });
            builder.setLength(builder.length() - 2);
            builder.append(")");
            return builder.toString();
        }
        return "Unimplemented fluidstack ingredient: " + ingredient;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> String convertIngredient(String crtClass, CrTChemicalTagManager<CHEMICAL> tagManager, ChemicalIngredientDeserializer<CHEMICAL, STACK, ?> deserializer, IChemicalStackIngredient<CHEMICAL, STACK> ingredient) {
        if (ingredient instanceof ChemicalStackIngredient.SingleIngredient) {
            JsonObject serialized = ingredient.serialize().getAsJsonObject();
            return this.convertParam(deserializer.deserializeStack(serialized));
        }
        if (ingredient instanceof ChemicalStackIngredient.TaggedIngredient) {
            JsonObject serialized = ingredient.serialize().getAsJsonObject();
            MCTag tag = tagManager.getTag(serialized.get("tag").getAsString());
            long amount = serialized.getAsJsonPrimitive("amount").getAsLong();
            if (amount > 0L && amount <= Integer.MAX_VALUE) {
                return this.getTagWithExplicitAmount(tag, (int)amount);
            }
            return crtClass + ".from(" + tag.getCommandString() + ", " + amount + ")";
        }
        if (ingredient instanceof ChemicalStackIngredient.MultiIngredient) {
            ChemicalStackIngredient.MultiIngredient multiIngredient = (ChemicalStackIngredient.MultiIngredient)ingredient;
            StringBuilder builder = new StringBuilder(crtClass + ".createMulti(");
            multiIngredient.forEachIngredient(i -> {
                builder.append(this.convertIngredient(crtClass, tagManager, deserializer, (IChemicalStackIngredient)i)).append(", ");
                return false;
            });
            builder.setLength(builder.length() - 2);
            builder.append(")");
            return builder.toString();
        }
        return "Unimplemented chemical stack ingredient: " + ingredient;
    }
}

