/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content.attribute.gas;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.providers.IGasProvider;
import mekanism.common.integration.crafttweaker.content.attribute.CrTChemicalAttribute;
import mekanism.common.integration.crafttweaker.content.attribute.ICrTChemicalAttribute;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.content.attribute.gas.CoolantAttribute")
public class CrTCoolantAttribute
extends CrTChemicalAttribute
implements ICrTChemicalAttribute.ICrTGasAttribute {
    @ZenCodeType.Method
    public static CrTCoolantAttribute cooled(Supplier<Gas> heatedGas, double thermalEnthalpy, double conductivity) {
        CrTCoolantAttribute.validateEnthalpyAndConductivity(thermalEnthalpy, conductivity);
        return new CrTCoolantAttribute(new GasAttributes.CooledCoolant(new CachingCrTGasProvider(heatedGas), thermalEnthalpy, conductivity));
    }

    @ZenCodeType.Method
    public static CrTCoolantAttribute heated(Supplier<Gas> cooledGas, double thermalEnthalpy, double conductivity) {
        CrTCoolantAttribute.validateEnthalpyAndConductivity(thermalEnthalpy, conductivity);
        return new CrTCoolantAttribute(new GasAttributes.HeatedCoolant(new CachingCrTGasProvider(cooledGas), thermalEnthalpy, conductivity));
    }

    private static void validateEnthalpyAndConductivity(double thermalEnthalpy, double conductivity) {
        if (thermalEnthalpy <= 0.0) {
            throw new IllegalArgumentException("Coolant attributes must have a thermal enthalpy greater than zero! Thermal Enthalpy: " + thermalEnthalpy);
        }
        if (conductivity <= 0.0 || conductivity > 1.0) {
            throw new IllegalArgumentException("Coolant attributes must have a conductivity greater than zero and at most one! Conductivity: " + conductivity);
        }
    }

    protected CrTCoolantAttribute(GasAttributes.Coolant attribute) {
        super(attribute);
    }

    private static class CachingCrTGasProvider
    implements IGasProvider {
        private Supplier<Gas> gasSupplier;
        private Gas gas = MekanismAPI.EMPTY_GAS;

        private CachingCrTGasProvider(Supplier<Gas> gasSupplier) {
            this.gasSupplier = gasSupplier;
        }

        @Override
        @Nonnull
        public Gas getChemical() {
            if (this.gas.isEmptyType()) {
                this.gas = (Gas)this.gasSupplier.get().getChemical();
                if (this.gas.isEmptyType()) {
                    throw new IllegalStateException("Empty gas used for coolant attribute via a CraftTweaker Script.");
                }
                this.gasSupplier = null;
            }
            return this.gas;
        }
    }
}

