/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.robit.RobitSkin;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CrTContentUtils {
    private static Map<ResourceLocation, Gas> queuedGases = new HashMap<ResourceLocation, Gas>();
    private static Map<ResourceLocation, InfuseType> queuedInfuseTypes = new HashMap<ResourceLocation, InfuseType>();
    private static Map<ResourceLocation, Pigment> queuedPigments = new HashMap<ResourceLocation, Pigment>();
    private static Map<ResourceLocation, Slurry> queuedSlurries = new HashMap<ResourceLocation, Slurry>();
    private static Map<ResourceLocation, RobitSkin> queuedRobitSkins = new HashMap<ResourceLocation, RobitSkin>();

    public static void queueGasForRegistration(ResourceLocation registryName, Gas gas) {
        CrTContentUtils.queueForRegistration("Gas", queuedGases, registryName, gas);
    }

    public static void queueInfuseTypeForRegistration(ResourceLocation registryName, InfuseType infuseType) {
        CrTContentUtils.queueForRegistration("Infuse Type", queuedInfuseTypes, registryName, infuseType);
    }

    public static void queuePigmentForRegistration(ResourceLocation registryName, Pigment pigment) {
        CrTContentUtils.queueForRegistration("Pigment", queuedPigments, registryName, pigment);
    }

    public static void queueSlurryForRegistration(ResourceLocation registryName, Slurry slurry) {
        CrTContentUtils.queueForRegistration("Slurry", queuedSlurries, registryName, slurry);
    }

    public static void queueRobitSkinForRegistration(ResourceLocation registryName, RobitSkin skin) {
        CrTContentUtils.queueForRegistration("Robit Skin", queuedRobitSkins, registryName, skin);
    }

    private static <V extends IForgeRegistryEntry<V>> void queueForRegistration(String type, @Nullable Map<ResourceLocation, V> queued, ResourceLocation registryName, V element) {
        if (queued == null) {
            CraftTweakerAPI.logError((String)"Cannot register %s '%s' since it was called too late. Registering must be done during '#loader mekanismcontent'!", (Object[])new Object[]{type, registryName});
        } else if (queued.put(registryName, element) == null) {
            CraftTweakerAPI.logInfo((String)"Queueing %s '%s' for registration.", (Object[])new Object[]{type, registryName});
        } else {
            CraftTweakerAPI.logWarning((String)"Registration for %s '%s' is already queued, skipping duplicate.", (Object[])new Object[]{type, registryName});
        }
    }

    public static void registerCrTGases(RegistryEvent.Register<Gas> event) {
        CraftTweakerAPI.loadScripts((ScriptLoadingOptions)new ScriptLoadingOptions().setLoaderName("mekanismcontent").execute());
        CrTContentUtils.registerQueued(event, queuedGases, () -> {
            queuedGases = null;
        }, "Gas", "gases");
    }

    public static void registerCrTInfuseTypes(RegistryEvent.Register<InfuseType> event) {
        CrTContentUtils.registerQueued(event, queuedInfuseTypes, () -> {
            queuedInfuseTypes = null;
        }, "Infuse Type", "infuse types");
    }

    public static void registerCrTPigments(RegistryEvent.Register<Pigment> event) {
        CrTContentUtils.registerQueued(event, queuedPigments, () -> {
            queuedPigments = null;
        }, "Pigment", "pigments");
    }

    public static void registerCrTSlurries(RegistryEvent.Register<Slurry> event) {
        CrTContentUtils.registerQueued(event, queuedSlurries, () -> {
            queuedSlurries = null;
        }, "Slurry", "slurries");
    }

    public static void registerCrTRobitSkins(RegistryEvent.Register<RobitSkin> event) {
        CrTContentUtils.registerQueued(event, queuedRobitSkins, () -> {
            queuedRobitSkins = null;
        }, "Robit Skin", "robit skins");
    }

    private static <V extends IForgeRegistryEntry<V>> void registerQueued(RegistryEvent.Register<V> event, Map<ResourceLocation, V> queued, Runnable setNull, String type, String plural) {
        if (queued != null) {
            setNull.run();
            int count = queued.size();
            CraftTweakerAPI.logInfo((String)"Registering %d custom %s.", (Object[])new Object[]{count, count == 1 ? type.toLowerCase(Locale.ROOT) : plural});
            for (Map.Entry<ResourceLocation, V> entry : queued.entrySet()) {
                ResourceLocation registryName = entry.getKey();
                event.getRegistry().register((IForgeRegistryEntry)((IForgeRegistryEntry)entry.getValue()).setRegistryName(registryName));
                CraftTweakerAPI.logInfo((String)"Registered %s: '%s'.", (Object[])new Object[]{type, registryName});
            }
        }
    }
}

