/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.IDynamicLuaObject;
import dan200.computercraft.api.lua.ILuaAPI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.ComputerMethodMapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.computercraft.CCMethodCaller;
import mekanism.common.integration.energy.EnergyCompatUtils;

public class CCEnergyHelper
extends CCMethodCaller
implements IDynamicLuaObject,
ILuaAPI {
    private static CCEnergyHelper energyHelper;

    public static CCEnergyHelper create(@Nonnull IComputerSystem computer) {
        if (energyHelper == null) {
            LinkedHashMap<String, BoundComputerMethod> boundMethods = new LinkedHashMap<String, BoundComputerMethod>();
            ComputerMethodMapper.INSTANCE.getAndBindToHandler(CCEnergyHelper.class, null, boundMethods);
            energyHelper = new CCEnergyHelper(boundMethods);
        }
        return energyHelper;
    }

    private CCEnergyHelper(Map<String, BoundComputerMethod> boundMethods) {
        super(boundMethods);
    }

    @Override
    protected String getCallerType() {
        return "Lua API";
    }

    public String[] getNames() {
        return new String[]{"mekanismEnergyHelper"};
    }

    @ComputerMethod
    private static FloatingLong joulesToFE(FloatingLong joules) throws ComputerException {
        if (MekanismConfig.general.blacklistForge.get()) {
            throw new ComputerException("Conversion between Joules and Forge Energy is disabled in Mekanism's config.");
        }
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(joules);
    }

    @ComputerMethod
    private static FloatingLong feToJoules(FloatingLong fe) throws ComputerException {
        if (MekanismConfig.general.blacklistForge.get()) {
            throw new ComputerException("Conversion between Forge Energy and Joules is disabled in Mekanism's config.");
        }
        return EnergyCompatUtils.EnergyType.FORGE.convertFrom(fe);
    }

    @ComputerMethod(requiredMods={"ic2"})
    private static FloatingLong joulesToEU(FloatingLong joules) throws ComputerException {
        if (!EnergyCompatUtils.useIC2()) {
            throw new ComputerException("Conversion between Joules and Electrical Units is either disabled in Mekanism's config.");
        }
        return EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(joules);
    }

    @ComputerMethod(requiredMods={"ic2"})
    private static FloatingLong euToJoules(FloatingLong eu) throws ComputerException {
        if (!EnergyCompatUtils.useIC2()) {
            throw new ComputerException("Conversion between Electrical Units and Joules is either disabled in Mekanism's config.");
        }
        return EnergyCompatUtils.EnergyType.EU.convertFrom(eu);
    }
}

