/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import javax.annotation.Nonnull;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.util.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class SorterItemStackFilter
extends SorterFilter<SorterItemStackFilter>
implements IItemStackFilter<SorterItemStackFilter> {
    private ItemStack itemType = ItemStack.field_190927_a;
    public boolean fuzzyMode;

    public SorterItemStackFilter() {
    }

    public SorterItemStackFilter(SorterItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.func_77946_l();
        this.fuzzyMode = filter.fuzzyMode;
    }

    @Override
    public Finder getFinder() {
        return this.fuzzyMode ? Finder.item(this.itemType) : Finder.strict(this.itemType);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("fuzzyMode", this.fuzzyMode);
        this.itemType.func_77955_b(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "fuzzyMode", fuzzy -> {
            this.fuzzyMode = fuzzy;
        });
        this.itemType = ItemStack.func_199557_a((CompoundNBT)nbtTags);
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.fuzzyMode);
        buffer.func_150788_a(this.itemType);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.fuzzyMode = dataStream.readBoolean();
        this.itemType = dataStream.func_150791_c();
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.itemType.hashCode();
        code = 31 * code + (this.fuzzyMode ? 1 : 0);
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof SorterItemStackFilter && ((SorterItemStackFilter)filter).itemType.func_77969_a(this.itemType) && ((SorterItemStackFilter)filter).fuzzyMode == this.fuzzyMode;
    }

    @Override
    public SorterItemStackFilter clone() {
        return new SorterItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_ITEMSTACK_FILTER;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@Nonnull ItemStack stack) {
        this.itemType = stack;
    }
}

