/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.HybridInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TankMultiblockData
extends MultiblockData
implements IValveHandler {
    @ContainerSync
    public final MergedTank mergedTank;
    @ContainerSync
    @SyntheticComputerMethod(getter="getContainerEditMode")
    public IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private HybridInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private HybridInventorySlot outputSlot;
    private int tankCapacity;
    private long chemicalTankCapacity;
    public float prevScale;

    public TankMultiblockData(TileEntityDynamicTank tile) {
        super(tile);
        this.mergedTank = MergedTank.create(MultiblockFluidTank.create(this, tile, this::getTankCapacity, BasicFluidTank.alwaysTrue), MultiblockChemicalTankBuilder.GAS.create(this, tile, this::getChemicalTankCapacity, ChemicalTankBuilder.GAS.alwaysTrue), MultiblockChemicalTankBuilder.INFUSION.create(this, tile, this::getChemicalTankCapacity, ChemicalTankBuilder.INFUSION.alwaysTrue), MultiblockChemicalTankBuilder.PIGMENT.create(this, tile, this::getChemicalTankCapacity, ChemicalTankBuilder.PIGMENT.alwaysTrue), MultiblockChemicalTankBuilder.SLURRY.create(this, tile, this::getChemicalTankCapacity, ChemicalTankBuilder.SLURRY.alwaysTrue));
        this.fluidTanks.add(this.mergedTank.getFluidTank());
        this.gasTanks.add(this.mergedTank.getGasTank());
        this.infusionTanks.add(this.mergedTank.getInfusionTank());
        this.pigmentTanks.add(this.mergedTank.getPigmentTank());
        this.slurryTanks.add(this.mergedTank.getSlurryTank());
        this.inventorySlots.addAll(this.createBaseInventorySlots());
    }

    private List<IInventorySlot> createBaseInventorySlots() {
        ArrayList<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
        this.inputSlot = HybridInventorySlot.inputOrDrain(this.mergedTank, this, 146, 21);
        inventorySlots.add(this.inputSlot);
        this.outputSlot = HybridInventorySlot.outputOrFill(this.mergedTank, this, 146, 51);
        inventorySlots.add(this.outputSlot);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return inventorySlots;
    }

    @Override
    public boolean tick(World world) {
        boolean needsPacket = super.tick(world);
        MergedTank.CurrentType type = this.mergedTank.getCurrentType();
        if (type == MergedTank.CurrentType.EMPTY) {
            this.inputSlot.handleTank(this.outputSlot, this.editMode);
            this.inputSlot.drainChemicalTanks();
            this.outputSlot.fillChemicalTanks();
        } else if (type == MergedTank.CurrentType.FLUID) {
            this.inputSlot.handleTank(this.outputSlot, this.editMode);
        } else {
            this.inputSlot.drainChemicalTank(type);
            this.outputSlot.fillChemicalTank(type);
        }
        float scale = this.getScale();
        if (scale != this.prevScale) {
            this.prevScale = scale;
            needsPacket = true;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundNBT tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
        this.mergedTank.readFromUpdateTag(tag);
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundNBT tag) {
        super.writeUpdateTag(tag);
        tag.func_74776_a("scale", this.prevScale);
        this.mergedTank.addToUpdateTag(tag);
        this.writeValves(tag);
    }

    private float getScale() {
        switch (this.mergedTank.getCurrentType()) {
            case FLUID: {
                return MekanismUtils.getScale(this.prevScale, this.getFluidTank());
            }
            case GAS: {
                return MekanismUtils.getScale(this.prevScale, this.getGasTank());
            }
            case INFUSION: {
                return MekanismUtils.getScale(this.prevScale, this.getInfusionTank());
            }
            case PIGMENT: {
                return MekanismUtils.getScale(this.prevScale, this.getPigmentTank());
            }
            case SLURRY: {
                return MekanismUtils.getScale(this.prevScale, this.getSlurryTank());
            }
        }
        return MekanismUtils.getScale(this.prevScale, 0L, this.getChemicalTankCapacity(), true);
    }

    @ComputerMethod
    public int getTankCapacity() {
        return this.tankCapacity;
    }

    @ComputerMethod
    public long getChemicalTankCapacity() {
        return this.chemicalTankCapacity;
    }

    @Override
    public void setVolume(int volume) {
        super.setVolume(volume);
        this.tankCapacity = this.getVolume() * MekanismConfig.general.dynamicTankFluidPerTank.get();
        this.chemicalTankCapacity = (long)this.getVolume() * MekanismConfig.general.dynamicTankChemicalPerTank.get();
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        long capacity = this.mergedTank.getCurrentType() == MergedTank.CurrentType.FLUID ? (long)this.getTankCapacity() : this.getChemicalTankCapacity();
        return MekanismUtils.redstoneLevelFromContents(this.getStoredAmount(), capacity);
    }

    private long getStoredAmount() {
        switch (this.mergedTank.getCurrentType()) {
            case FLUID: {
                return this.getFluidTank().getFluidAmount();
            }
            case GAS: {
                return this.getGasTank().getStored();
            }
            case INFUSION: {
                return this.getInfusionTank().getStored();
            }
            case PIGMENT: {
                return this.getPigmentTank().getStored();
            }
            case SLURRY: {
                return this.getSlurryTank().getStored();
            }
        }
        return 0L;
    }

    public IExtendedFluidTank getFluidTank() {
        return this.mergedTank.getFluidTank();
    }

    public IGasTank getGasTank() {
        return this.mergedTank.getGasTank();
    }

    public IInfusionTank getInfusionTank() {
        return this.mergedTank.getInfusionTank();
    }

    public IPigmentTank getPigmentTank() {
        return this.mergedTank.getPigmentTank();
    }

    public ISlurryTank getSlurryTank() {
        return this.mergedTank.getSlurryTank();
    }

    public boolean isEmpty() {
        return this.mergedTank.getCurrentType() == MergedTank.CurrentType.EMPTY;
    }

    @ComputerMethod
    public void setContainerEditMode(IFluidContainerManager.ContainerEditMode mode) {
        if (this.editMode != mode) {
            this.editMode = mode;
            this.markDirty();
        }
    }

    @ComputerMethod
    private void incrementContainerEditMode() {
        this.setContainerEditMode((IFluidContainerManager.ContainerEditMode)this.editMode.getNext());
    }

    @ComputerMethod
    private void decrementContainerEditMode() {
        this.setContainerEditMode((IFluidContainerManager.ContainerEditMode)this.editMode.getPrevious());
    }

    @ComputerMethod
    private Object getStored() {
        switch (this.mergedTank.getCurrentType()) {
            case FLUID: {
                return this.getFluidTank().getFluid();
            }
            case GAS: {
                return this.getGasTank().getStack();
            }
            case INFUSION: {
                return this.getInfusionTank().getStack();
            }
            case PIGMENT: {
                return this.getPigmentTank().getStack();
            }
            case SLURRY: {
                return this.getSlurryTank().getStack();
            }
        }
        return FluidStack.EMPTY;
    }

    @ComputerMethod
    private double getFilledPercentage() {
        long capacity = this.mergedTank.getCurrentType() == MergedTank.CurrentType.FLUID ? (long)this.getTankCapacity() : this.getChemicalTankCapacity();
        return (double)this.getStoredAmount() / (double)capacity;
    }
}

