/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.TagCache;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.lib.collection.BiMultimap;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.to_client.PacketQIOItemViewerGuiSync;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class QIOFrequency
extends Frequency
implements IColorableFrequency {
    private static final Random rand = new Random();
    private final Map<QIODriveData.QIODriveKey, QIODriveData> driveMap = new LinkedHashMap<QIODriveData.QIODriveKey, QIODriveData>();
    private final Map<HashedItem, QIOItemTypeData> itemDataMap = new LinkedHashMap<HashedItem, QIOItemTypeData>();
    private final Set<IQIODriveHolder> driveHolders = new HashSet<IQIODriveHolder>();
    private final BiMultimap<String, HashedItem> tagLookupMap = new BiMultimap();
    private final Map<String, Set<HashedItem>> modIDLookupMap = new HashMap<String, Set<HashedItem>>();
    private final Map<Item, Set<HashedItem>> fuzzyItemLookupMap = new HashMap<Item, Set<HashedItem>>();
    private final BiMap<HashedItem, UUID> itemTypeLookup = HashBiMap.create();
    private final Set<UUID> uuidsToInvalidate = new HashSet<UUID>();
    private final SetMultimap<String, String> tagWildcardCache = HashMultimap.create();
    private final Set<String> failedWildcardTags = new HashSet<String>();
    private final SetMultimap<String, String> modIDWildcardCache = HashMultimap.create();
    private final Set<String> failedWildcardModIDs = new HashSet<String>();
    private final Set<HashedItem.UUIDAwareHashedItem> updatedItems = new HashSet<HashedItem.UUIDAwareHashedItem>();
    private final Set<ServerPlayerEntity> playersViewingItems = new HashSet<ServerPlayerEntity>();
    private boolean needsUpdate;
    private boolean isDirty;
    private long totalCount;
    private long totalCountCapacity;
    private int totalTypeCapacity;
    private int clientTypes;
    private EnumColor color = EnumColor.INDIGO;

    public QIOFrequency(String n, @Nullable UUID uuid) {
        super(FrequencyType.QIO, n, uuid);
    }

    public QIOFrequency() {
        super(FrequencyType.QIO);
    }

    public Map<HashedItem, QIOItemTypeData> getItemDataMap() {
        return this.itemDataMap;
    }

    @Nullable
    public HashedItem getTypeByUUID(@Nullable UUID uuid) {
        return uuid == null ? null : (HashedItem)this.itemTypeLookup.inverse().get((Object)uuid);
    }

    @Nullable
    public UUID getUUIDForType(HashedItem item) {
        return (UUID)this.itemTypeLookup.get((Object)item);
    }

    public ItemStack addItem(ItemStack stack) {
        HashedItem type = HashedItem.create(stack);
        if (this.totalCount == this.totalCountCapacity || !this.itemDataMap.containsKey(type) && this.itemDataMap.size() == this.totalTypeCapacity) {
            return stack;
        }
        QIOItemTypeData data = this.itemDataMap.computeIfAbsent(type, this::createTypeDataForAbsent);
        return type.createStack((int)data.add(stack.func_190916_E()));
    }

    private QIOItemTypeData createTypeDataForAbsent(HashedItem type) {
        ItemStack stack = type.getStack();
        List<String> tags = TagCache.getItemTags(stack);
        if (!tags.isEmpty()) {
            boolean hasAllKeys = this.tagLookupMap.hasAllKeys(tags);
            if (this.tagLookupMap.putAll(tags, type) && !hasAllKeys) {
                this.tagWildcardCache.clear();
                this.failedWildcardTags.clear();
            }
        }
        this.modIDLookupMap.computeIfAbsent(MekanismUtils.getModId(stack), modID -> {
            this.modIDWildcardCache.clear();
            this.failedWildcardModIDs.clear();
            return new HashSet();
        }).add(type);
        this.fuzzyItemLookupMap.computeIfAbsent(stack.func_77973_b(), item -> new HashSet()).add(type);
        UUID oldUUID = this.getUUIDForType(type);
        if (oldUUID != null) {
            this.uuidsToInvalidate.remove(oldUUID);
        } else {
            this.itemTypeLookup.put((Object)type, (Object)UUID.randomUUID());
        }
        return new QIOItemTypeData(type);
    }

    public ItemStack removeItem(int amount) {
        return this.removeByType(null, amount);
    }

    public ItemStack removeItem(ItemStack stack, int amount) {
        return this.removeByType(HashedItem.raw(stack), amount);
    }

    public ItemStack removeByType(@Nullable HashedItem itemType, int amount) {
        QIOItemTypeData data;
        if (this.itemDataMap.isEmpty() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (itemType == null) {
            Map.Entry<HashedItem, QIOItemTypeData> entry = this.itemDataMap.entrySet().iterator().next();
            itemType = entry.getKey();
            data = entry.getValue();
        } else {
            data = this.itemDataMap.get(itemType);
            if (data == null) {
                return ItemStack.field_190927_a;
            }
        }
        ItemStack removed = data.remove(amount);
        if (data.count == 0L) {
            this.removeItemData(data.itemType);
        }
        return removed;
    }

    private void removeItemData(HashedItem type) {
        Item item;
        Set<HashedItem> itemsByFuzzy;
        ItemStack stack;
        String modID;
        Set<HashedItem> itemsForMod;
        this.itemDataMap.remove(type);
        UUID toInvalidate = this.getUUIDForType(type);
        if (toInvalidate != null) {
            this.uuidsToInvalidate.add(toInvalidate);
        }
        HashSet<String> tags = new HashSet<String>(this.tagLookupMap.getKeys(type));
        if (this.tagLookupMap.removeValue(type) && !this.tagLookupMap.hasAllKeys(tags)) {
            this.tagWildcardCache.clear();
        }
        if ((itemsForMod = this.modIDLookupMap.get(modID = MekanismUtils.getModId(stack = type.getStack()))) != null && itemsForMod.remove(type) && itemsForMod.isEmpty()) {
            this.modIDLookupMap.remove(modID);
            this.modIDWildcardCache.clear();
        }
        if ((itemsByFuzzy = this.fuzzyItemLookupMap.get(item = stack.func_77973_b())) != null && itemsByFuzzy.remove(type) && itemsByFuzzy.isEmpty()) {
            this.fuzzyItemLookupMap.remove(item);
        }
    }

    public Set<HashedItem> getTypesForItem(Item item) {
        return Collections.unmodifiableSet(this.fuzzyItemLookupMap.getOrDefault(item, Collections.emptySet()));
    }

    public Object2LongMap<HashedItem> getStacksByItem(Item item) {
        return this.getStacksWithCounts(this.fuzzyItemLookupMap.get(item));
    }

    public Object2LongMap<HashedItem> getStacksByTag(String tag) {
        return this.getStacksWithCounts(this.tagLookupMap.getValues(tag));
    }

    public Object2LongMap<HashedItem> getStacksByModID(String modID) {
        return this.getStacksWithCounts(this.modIDLookupMap.get(modID));
    }

    private Object2LongMap<HashedItem> getStacksWithCounts(@Nullable Set<HashedItem> items) {
        if (items == null || items.isEmpty()) {
            return Object2LongMaps.emptyMap();
        }
        Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
        for (HashedItem item : items) {
            ret.put((Object)item, this.getStored(item));
        }
        return ret;
    }

    public Object2LongMap<HashedItem> getStacksByTagWildcard(String wildcard) {
        if (this.hasMatchingElements(this.tagWildcardCache, this.failedWildcardTags, wildcard, this.tagLookupMap::getAllKeys)) {
            Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
            for (String match : this.tagWildcardCache.get((Object)wildcard)) {
                for (HashedItem item : this.tagLookupMap.getValues(match)) {
                    ret.computeLongIfAbsent((Object)item, this::getStored);
                }
            }
            return ret;
        }
        return Object2LongMaps.emptyMap();
    }

    public Object2LongMap<HashedItem> getStacksByModIDWildcard(String wildcard) {
        if (this.hasMatchingElements(this.modIDWildcardCache, this.failedWildcardModIDs, wildcard, this.modIDLookupMap::keySet)) {
            Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
            for (String match : this.modIDWildcardCache.get((Object)wildcard)) {
                for (HashedItem item : this.modIDLookupMap.get(match)) {
                    ret.put((Object)item, this.getStored(item));
                }
            }
            return ret;
        }
        return Object2LongMaps.emptyMap();
    }

    private boolean hasMatchingElements(SetMultimap<String, String> wildcardCache, Set<String> failedWildcards, String wildcard, Supplier<Set<String>> entriesSupplier) {
        if (failedWildcards.contains(wildcard)) {
            return false;
        }
        if (!wildcardCache.containsKey((Object)wildcard) && !this.buildWildcardMapping(wildcardCache, wildcard, entriesSupplier.get())) {
            failedWildcards.add(wildcard);
            return false;
        }
        return true;
    }

    private boolean buildWildcardMapping(SetMultimap<String, String> wildcardCache, String wildcard, Set<String> entries) {
        boolean added = false;
        for (String entry : entries) {
            if (!WildcardMatcher.matches(wildcard, entry)) continue;
            added |= wildcardCache.put((Object)wildcard, (Object)entry);
        }
        return added;
    }

    public void openItemViewer(ServerPlayerEntity player) {
        this.playersViewingItems.add(player);
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        for (QIOItemTypeData data : this.itemDataMap.values()) {
            map.put((Object)new HashedItem.UUIDAwareHashedItem(data.itemType, this.getUUIDForType(data.itemType)), data.count);
        }
        Mekanism.packetHandler.sendTo(PacketQIOItemViewerGuiSync.batch((Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, this.totalCountCapacity, this.totalTypeCapacity), player);
    }

    public void closeItemViewer(ServerPlayerEntity player) {
        this.playersViewingItems.remove(player);
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor color) {
        this.color = color;
    }

    public long getTotalItemCount() {
        return this.totalCount;
    }

    public long getTotalItemCountCapacity() {
        return this.totalCountCapacity;
    }

    public int getTotalItemTypes(boolean remote) {
        return remote ? this.clientTypes : this.itemDataMap.size();
    }

    public int getTotalItemTypeCapacity() {
        return this.totalTypeCapacity;
    }

    public long getStored(HashedItem itemType) {
        QIOItemTypeData data = this.itemDataMap.get(itemType);
        return data == null ? 0L : data.count;
    }

    public QIODriveData getDriveData(QIODriveData.QIODriveKey key) {
        return this.driveMap.get(key);
    }

    public Collection<QIODriveData> getAllDrives() {
        return this.driveMap.values();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.uuidsToInvalidate.isEmpty()) {
            for (UUID uuidToInvalidate : this.uuidsToInvalidate) {
                this.itemTypeLookup.inverse().remove((Object)uuidToInvalidate);
            }
            this.uuidsToInvalidate.clear();
        }
        if (!this.updatedItems.isEmpty() || this.needsUpdate) {
            Object2LongOpenHashMap map = new Object2LongOpenHashMap();
            this.updatedItems.forEach(arg_0 -> this.lambda$tick$2((Object2LongMap)map, arg_0));
            this.playersViewingItems.removeIf(player -> !(player.field_71070_bA instanceof QIOItemViewerContainer));
            this.playersViewingItems.forEach(arg_0 -> this.lambda$tick$4((Object2LongMap)map, arg_0));
            this.updatedItems.clear();
            this.needsUpdate = false;
        }
        if (this.isDirty && rand.nextInt(100) == 0) {
            this.saveAll();
            this.isDirty = false;
        }
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.tagLookupMap.clear();
            this.tagWildcardCache.clear();
            this.itemDataMap.values().forEach(item -> this.tagLookupMap.putAll(TagCache.getItemTags(((QIOItemTypeData)item).itemType.getStack()), ((QIOItemTypeData)item).itemType));
        }
    }

    @Override
    public void onDeactivate(TileEntity tile) {
        super.onDeactivate(tile);
        if (tile instanceof IQIODriveHolder) {
            IQIODriveHolder holder = (IQIODriveHolder)tile;
            for (int i = 0; i < holder.getDriveSlots().size(); ++i) {
                QIODriveData.QIODriveKey key = new QIODriveData.QIODriveKey(holder, i);
                this.removeDrive(key, true);
                this.driveMap.remove(key);
            }
        }
    }

    @Override
    public void update(TileEntity tile) {
        IQIODriveHolder holder;
        super.update(tile);
        if (tile instanceof IQIODriveHolder && !this.driveHolders.contains(holder = (IQIODriveHolder)tile)) {
            this.addHolder(holder);
        }
    }

    @Override
    public void onRemove() {
        super.onRemove();
        HashSet<QIODriveData.QIODriveKey> keys = new HashSet<QIODriveData.QIODriveKey>(this.driveMap.keySet());
        keys.forEach(key -> this.removeDrive((QIODriveData.QIODriveKey)key, false));
        this.driveMap.clear();
        this.playersViewingItems.forEach(player -> Mekanism.packetHandler.sendTo(PacketQIOItemViewerGuiSync.kill(), (ServerPlayerEntity)player));
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + Long.hashCode(this.totalCount);
        code = 31 * code + Long.hashCode(this.totalCountCapacity);
        code = 31 * code + this.itemDataMap.size();
        code = 31 * code + this.totalTypeCapacity;
        code = 31 * code + this.color.ordinal();
        return code;
    }

    @Override
    public void write(PacketBuffer buf) {
        super.write(buf);
        buf.func_179254_b(this.totalCount);
        buf.func_179254_b(this.totalCountCapacity);
        buf.func_150787_b(this.itemDataMap.size());
        buf.func_150787_b(this.totalTypeCapacity);
        buf.func_179249_a((Enum)this.color);
    }

    @Override
    public void read(PacketBuffer buf) {
        super.read(buf);
        this.totalCount = buf.func_179260_f();
        this.totalCountCapacity = buf.func_179260_f();
        this.clientTypes = buf.func_150792_a();
        this.totalTypeCapacity = buf.func_150792_a();
        this.setColor((EnumColor)buf.func_179257_a(EnumColor.class));
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("color", this.color.ordinal());
    }

    @Override
    protected void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "color", EnumColor::byIndexStatic, this::setColor);
    }

    public void addDrive(QIODriveData.QIODriveKey key) {
        if (key.getDriveStack().func_77973_b() instanceof IQIODriveItem) {
            if (this.driveMap.containsKey(key)) {
                this.removeDrive(key, true);
            }
            QIODriveData data = new QIODriveData(key);
            this.totalCountCapacity += data.getCountCapacity();
            this.totalTypeCapacity += data.getTypeCapacity();
            this.driveMap.put(key, data);
            data.getItemMap().forEach((storedKey, value) -> {
                this.itemDataMap.computeIfAbsent((HashedItem)storedKey, this::createTypeDataForAbsent).addFromDrive(data, value);
                this.updatedItems.add(new HashedItem.UUIDAwareHashedItem((HashedItem)storedKey, this.getUUIDForType((HashedItem)storedKey)));
            });
            this.setNeedsUpdate();
        }
    }

    public void removeDrive(QIODriveData.QIODriveKey key, boolean updateItemMap) {
        if (!this.driveMap.containsKey(key)) {
            return;
        }
        QIODriveData data = this.driveMap.get(key);
        if (updateItemMap) {
            data.getItemMap().forEach((storedKey, value) -> {
                QIOItemTypeData itemData = this.itemDataMap.get(storedKey);
                if (itemData != null) {
                    itemData.containingDrives.remove(key);
                    QIOItemTypeData qIOItemTypeData = itemData;
                    qIOItemTypeData.count = qIOItemTypeData.count - value;
                    this.totalCount -= value.longValue();
                    this.updatedItems.add(new HashedItem.UUIDAwareHashedItem((HashedItem)storedKey, this.getUUIDForType((HashedItem)storedKey)));
                    if (itemData.containingDrives.isEmpty() || itemData.count == 0L) {
                        this.removeItemData((HashedItem)storedKey);
                    }
                }
            });
            this.setNeedsUpdate();
        }
        this.totalCountCapacity -= data.getCountCapacity();
        this.totalTypeCapacity -= data.getTypeCapacity();
        this.driveMap.remove(key);
        key.updateMetadata(data);
        key.save(data);
    }

    public void saveAll() {
        this.driveMap.forEach((key, value) -> {
            key.updateMetadata((QIODriveData)value);
            key.save((QIODriveData)value);
        });
    }

    private void addHolder(IQIODriveHolder holder) {
        this.driveHolders.add(holder);
        for (int i = 0; i < holder.getDriveSlots().size(); ++i) {
            this.addDrive(new QIODriveData.QIODriveKey(holder, i));
        }
    }

    private void setNeedsUpdate(@Nullable HashedItem changedItem) {
        this.needsUpdate = true;
        this.isDirty = true;
        if (changedItem != null) {
            this.updatedItems.add(new HashedItem.UUIDAwareHashedItem(changedItem, this.getUUIDForType(changedItem)));
        }
    }

    private void setNeedsUpdate() {
        this.setNeedsUpdate(null);
    }

    private /* synthetic */ void lambda$tick$4(Object2LongMap map, ServerPlayerEntity player) {
        Mekanism.packetHandler.sendTo(PacketQIOItemViewerGuiSync.update((Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, this.totalCountCapacity, this.totalTypeCapacity), player);
    }

    private /* synthetic */ void lambda$tick$2(Object2LongMap map, HashedItem.UUIDAwareHashedItem type) {
        QIOItemTypeData data = this.itemDataMap.get(type);
        map.put((Object)type, data == null ? 0L : data.count);
    }

    public class QIOItemTypeData {
        private final HashedItem itemType;
        private long count = 0L;
        private final Set<QIODriveData.QIODriveKey> containingDrives = new HashSet<QIODriveData.QIODriveKey>();

        public QIOItemTypeData(HashedItem itemType) {
            this.itemType = itemType;
        }

        private void addFromDrive(QIODriveData data, long toAdd) {
            this.count += toAdd;
            QIOFrequency.this.totalCount = QIOFrequency.this.totalCount + toAdd;
            this.containingDrives.add(data.getKey());
            QIOFrequency.this.setNeedsUpdate();
        }

        private long add(long amount) {
            long toAdd = amount;
            for (QIODriveData.QIODriveKey key : this.containingDrives) {
                if ((toAdd = this.addItemsToDrive(toAdd, (QIODriveData)QIOFrequency.this.driveMap.get(key))) != 0L) continue;
                break;
            }
            if (toAdd > 0L) {
                QIODriveData data;
                Iterator<QIODriveData.QIODriveKey> iterator = QIOFrequency.this.driveMap.values().iterator();
                while (iterator.hasNext() && (this.containingDrives.contains((data = (QIODriveData)((Object)iterator.next())).getKey()) || (toAdd = this.addItemsToDrive(toAdd, data)) != 0L)) {
                }
            }
            this.count += amount - toAdd;
            QIOFrequency.this.totalCount = QIOFrequency.this.totalCount + (amount - toAdd);
            QIOFrequency.this.setNeedsUpdate(this.itemType);
            return toAdd;
        }

        private long addItemsToDrive(long toAdd, QIODriveData data) {
            long rejects = data.add(this.itemType, toAdd);
            if (rejects < toAdd) {
                this.containingDrives.add(data.getKey());
            }
            return rejects;
        }

        private ItemStack remove(int amount) {
            ItemStack ret = ItemStack.field_190927_a;
            Iterator<QIODriveData.QIODriveKey> iter = this.containingDrives.iterator();
            while (iter.hasNext()) {
                QIODriveData data = (QIODriveData)QIOFrequency.this.driveMap.get(iter.next());
                ItemStack stack = data.remove(this.itemType, amount - ret.func_190916_E());
                if (ret.func_190926_b()) {
                    ret = stack;
                } else {
                    ret.func_190917_f(stack.func_190916_E());
                }
                if (data.getStored(this.itemType) == 0L) {
                    iter.remove();
                }
                if (ret.func_190916_E() != amount) continue;
                break;
            }
            this.count -= (long)ret.func_190916_E();
            QIOFrequency.this.totalCount = QIOFrequency.this.totalCount - (long)ret.func_190916_E();
            QIOFrequency.this.setNeedsUpdate(this.itemType);
            return ret;
        }

        public long getCount() {
            return this.count;
        }
    }
}

