/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public class DiversionTransporter
extends LogisticalTransporterBase {
    public final DiversionControl[] modes = new DiversionControl[EnumUtils.DIRECTIONS.length];

    public DiversionTransporter(TileEntityTransmitter tile) {
        super(tile, TransporterTier.BASIC);
        Arrays.fill(this.modes, DiversionControl.DISABLED);
    }

    @Override
    public void onNeighborBlockChange(Direction side) {
        byte current = this.getAllCurrentConnections();
        this.refreshConnections();
        if (current != this.getAllCurrentConnections()) {
            this.markDirtyTransmitters();
        }
    }

    private void readModes(@Nonnull CompoundNBT tag) {
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setEnumIfPresent(tag, "mode" + index, DiversionControl::byIndexStatic, mode -> {
                this.modes[index] = mode;
            });
        }
    }

    @Nonnull
    private CompoundNBT writeModes(@Nonnull CompoundNBT nbtTags) {
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            nbtTags.func_74768_a("mode" + i, this.modes[i].ordinal());
        }
        return nbtTags;
    }

    @Override
    public void read(@Nonnull CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.readModes(nbtTags);
    }

    @Override
    @Nonnull
    public CompoundNBT write(@Nonnull CompoundNBT nbtTags) {
        return this.writeModes(super.write(nbtTags));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag(CompoundNBT updateTag) {
        return this.writeModes(super.getReducedUpdateTag(updateTag));
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.readModes(tag);
    }

    public void updateMode(Direction side, DiversionControl mode) {
        int ordinal = side.ordinal();
        if (this.modes[ordinal] != mode) {
            this.modes[ordinal] = mode;
            this.refreshConnections();
            this.notifyTileChange();
            this.getTransmitterTile().sendUpdatePacket();
        }
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        side = this.getTransmitterTile().getSideLookingAt(player, side);
        DiversionControl newMode = (DiversionControl)this.modes[side.ordinal()].getNext();
        this.updateMode(side, newMode);
        player.func_145747_a(MekanismUtils.logFormat(MekanismLang.TOGGLE_DIVERTER.translate(EnumColor.RED, newMode)), Util.field_240973_b_);
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean canConnect(Direction side) {
        if (super.canConnect(side)) {
            DiversionControl mode = this.modes[side.ordinal()];
            if (mode == DiversionControl.HIGH) {
                return this.isGettingPowered();
            }
            if (mode == DiversionControl.LOW) {
                return !this.isGettingPowered();
            }
            return true;
        }
        return false;
    }

    private boolean isGettingPowered() {
        return WorldUtils.isGettingPowered(this.getTileWorld(), this.getTilePos());
    }

    public static enum DiversionControl implements IIncrementalEnum<DiversionControl>,
    IHasTextComponent
    {
        DISABLED(MekanismLang.DIVERSION_CONTROL_DISABLED),
        HIGH(MekanismLang.DIVERSION_CONTROL_HIGH),
        LOW(MekanismLang.DIVERSION_CONTROL_LOW);

        private static final DiversionControl[] MODES;
        private final ILangEntry langEntry;

        private DiversionControl(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        @Nonnull
        public DiversionControl byIndex(int index) {
            return DiversionControl.byIndexStatic(index);
        }

        public static DiversionControl byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = DiversionControl.values();
        }
    }
}

