/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class MinerModIDFilter
extends MinerFilter<MinerModIDFilter>
implements IModIDFilter<MinerModIDFilter> {
    private String modID;

    public MinerModIDFilter(String modID) {
        this.modID = modID;
    }

    public MinerModIDFilter() {
    }

    public MinerModIDFilter(MinerModIDFilter filter) {
        super(filter);
        this.modID = filter.modID;
    }

    @Override
    public boolean canFilter(BlockState state) {
        return WildcardMatcher.matches(this.modID, state.func_177230_c().getRegistryName().func_110624_b());
    }

    @Override
    public boolean hasBlacklistedElement() {
        return TagCache.modIDHasMinerBlacklisted(this.modID);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74778_a("modID", this.modID);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.modID = nbtTags.func_74779_i("modID");
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.func_180714_a(this.modID);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.modID = BasePacketHandler.readString(dataStream);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.modID.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof MinerModIDFilter && ((MinerModIDFilter)filter).modID.equals(this.modID);
    }

    @Override
    public MinerModIDFilter clone() {
        return new MinerModIDFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_MODID_FILTER;
    }

    @Override
    public void setModID(String id) {
        this.modID = id;
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

